/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ant.listener;

import com.huawei.elog.ant.executor.AntExecutor4Esight;
import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.sdk.IInstallContext;
import com.huawei.elog.ui.card.install.CopyFilesCard;
import com.huawei.elog.ui.util.CMDHelper;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.ResourceManager;
import com.huawei.elog.util.UIUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegoInstallBuildListener
implements BuildListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LegoInstallBuildListener.class);
    private static IInstallContext ctx = InstallContext.getInstance();
    private static String basePath = ctx.getEnvirments().getBasePath();
    private static double percent = 0.0;
    private static double nextPercent = 0.0;
    private String pwdString = ContextUtil.getStrValueFromCtx("lego.db.password");
    private String title;
    private String bundleName;
    private CopyFilesCard card;
    private int index = -1;
    private int size;
    private Map<?, ?> targets;
    private List<String> unexecuted;
    private double progress = 0.0;
    private String targetName;
    private String message;
    private String simpleMsg;
    private Object eventSource;
    private ExecTask et;
    private Throwable th;
    private boolean initFlag = false;

    public LegoInstallBuildListener() {
    }

    public LegoInstallBuildListener(CopyFilesCard card, String bundleName, String title) {
        this.card = card;
        this.bundleName = bundleName;
        this.title = title;
        if (null != title) {
            String[] ts = title.split("/");
            this.index = Integer.parseInt(ts[0].substring(1));
            this.size = Integer.parseInt(ts[1].substring(0, 1));
        }
    }

    public void buildStarted(BuildEvent event) {
        LOGGER.info("finished start: " + event.getProject().getName(), (Object)"LegoBuildListener.buildStarted");
        Project project = event.getProject();
        this.targets = project.getTargets();
        BarThread stepper = new BarThread(this.card.getProcessBar());
        stepper.start();
    }

    public void buildFinished(BuildEvent event) {
        LOGGER.info("finished build: " + event.getProject().getName(), (Object)"LegoBuildListener.buildFinished");
        if (UIUtil.isSilentMode()) {
            return;
        }
        this.setPercent(this.index / this.size * 100);
        this.card.getFileName().setText("Finished...");
        this.card.getProcessBar().setValue((int)percent);
    }

    public void messageLogged(BuildEvent event) {
        this.message = event.getMessage();
        this.th = event.getException();
        if (null != this.th) {
            if (StringUtils.isNotEmpty((CharSequence)basePath)) {
                this.simpleMsg = this.message.replace(basePath, "...");
            }
            if (StringUtils.isNotEmpty((CharSequence)this.pwdString)) {
                this.simpleMsg = this.simpleMsg.replace(this.pwdString, "******");
            }
            LOGGER.error("----- build.faild:-----\n " + this.th, (Object)"messageLogged");
            LOGGER.error("messageLogged: " + this.simpleMsg, (Object)"messageLogged");
        }
        this.eventSource = event.getSource();
        if (this.eventSource instanceof ExecTask) {
            this.et = (ExecTask)this.eventSource;
            if ("exec".equals(this.et.getTaskName())) {
                return;
            }
        }
        this.message = event.getMessage();
        if (null == this.message || this.message.trim().isEmpty()) {
            return;
        }
        if (!this.message.contains("Setting") && !this.message.contains("antcontrib") && InstallContext.getInstance().getInstallType().contains("legoPlat")) {
            if (StringUtils.isNotEmpty((CharSequence)basePath)) {
                this.simpleMsg = this.message.replace(basePath, "...");
            }
            if (StringUtils.isNotEmpty((CharSequence)this.pwdString)) {
                this.simpleMsg = this.simpleMsg.replace(this.pwdString, "******");
            }
            this.targetName = event.getTarget() == null ? "" : event.getTarget().getName();
            this.setPercent(((double)(this.index - 1) + this.progress) / (double)this.size * 100.0);
            this.setNextPercent(((double)this.index + this.progress) / (double)this.size * 100.0);
            this.setNextPercent(nextPercent > 98.0 ? 98.0 : nextPercent);
            if (UIUtil.isSilentMode()) {
                StringBuilder sb = new StringBuilder();
                sb.append('[').append((int)percent).append("%]");
                sb.append(this.title).append(' ');
                sb.append(ResourceManager.getString(this.bundleName)).append(' ');
                sb.append(this.targetName).append(' ');
                sb.append(this.simpleMsg);
                CMDHelper.getInstance().println(sb.toString());
            } else {
                this.card.getCopingFile().setText(this.title + " " + ResourceManager.getString(this.bundleName) + "  " + this.targetName);
                this.card.getFileName().setText(this.simpleMsg);
                int value = this.card.getProcessBar().getValue();
                if ((int)percent > value) {
                    this.card.getProcessBar().setValue((int)percent);
                }
            }
        }
    }

    public void targetStarted(BuildEvent event) {
        LOGGER.info("target started: -*-*-*-" + event.getTarget().getName() + "-*-*-*-", (Object)"LegoBuildListener.targetStarted");
        if (!this.initFlag) {
            Hashtable htb;
            Project project = event.getProject();
            this.targets = htb = project.getTargets();
            this.unexecuted = new ArrayList<String>();
            Enumeration en = htb.elements();
            while (en.hasMoreElements()) {
                Target tar = (Target)en.nextElement();
                if (null == tar) continue;
                this.unexecuted.add(tar.getName());
                LOGGER.info("---- target list: " + tar.getLocation() + "/" + tar.getName());
            }
            this.initFlag = true;
        }
    }

    public void targetFinished(BuildEvent event) {
        Target tar = event.getTarget();
        if (tar != null && this.unexecuted.contains(tar.getName())) {
            this.unexecuted.remove(tar.getName());
        }
        this.progress = (double)(this.targets.size() - this.unexecuted.size()) / (double)this.targets.size();
    }

    public void taskFinished(BuildEvent arg0) {
    }

    public void taskStarted(BuildEvent arg0) {
    }

    public void setPercent(double d) {
        LegoInstallBuildListener.setPercentValue(d);
    }

    public static void setPercentValue(double percentTepm) {
        percent = percentTepm;
    }

    public void setNextPercent(double d) {
        LegoInstallBuildListener.setNextPercentValue(d);
    }

    public static void setNextPercentValue(double nextPercentTepm) {
        nextPercent = nextPercentTepm;
    }

    static {
        if (basePath.indexOf("/") > -1) {
            basePath = basePath.replaceAll("/", "\\\\");
        }
    }

    static class BarThread
    extends Thread {
        private static final int DELAY = 5000;
        JProgressBar progressBar;

        public BarThread(JProgressBar bar) {
            this.progressBar = bar;
        }

        @Override
        public void run() {
            if (null == this.progressBar) {
                return;
            }
            int minimum = this.progressBar.getMinimum();
            int maximum = this.progressBar.getMaximum();
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    int value = progressBar.getValue();
                    if ((double)value < nextPercent && !AntExecutor4Esight.isExceptionFlag()) {
                        progressBar.setValue(value + 1);
                    }
                }
            };
            for (int i = minimum; i < maximum; ++i) {
                try {
                    SwingUtilities.invokeAndWait(runner);
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException ignoredException) {
                    LOGGER.error("run", (Throwable)ignoredException);
                    continue;
                }
                catch (InvocationTargetException ignoredException) {
                    LOGGER.error("run", (Throwable)ignoredException);
                }
            }
        }
    }
}

