/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ant.task;

import com.huawei.elog.util.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.tools.ant.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendLogCenterMenuTask
extends Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppendLogCenterMenuTask.class);
    private String appendFilePath;
    private String baseFilePath;

    public void execute() {
        super.execute();
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(this.getBaseContent()).append(System.getProperty("line.separator"));
            sb.append(this.getAppendContent()).append(System.getProperty("line.separator"));
            sb.append("</DESC>").append(System.getProperty("line.separator"));
            sb.append("</COMMINIDATA>").append(System.getProperty("line.separator"));
            FileUtil.writeContent2File(new File(this.baseFilePath), sb.toString());
        }
        catch (Exception e) {
            LOGGER.error("AppendLogCenterMenuTask.getBaseContent()", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBaseContent() {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = null;
        InputStreamReader isr = null;
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(this.baseFilePath);
            isr = new InputStreamReader((InputStream)fin, "utf-8");
            br = new BufferedReader(isr);
            String preLine = "";
            String line = null;
            while (null != (line = br.readLine())) {
                if (preLine.indexOf("</DESC>") > -1 && line.indexOf("</COMMINIDATA>") > -1) {
                    break;
                }
                sb.append(preLine).append(System.getProperty("line.separator"));
                preLine = line;
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("AppendLogCenterMenuTask.getBaseContent()", (Throwable)e);
        }
        catch (IOException ioe) {
            LOGGER.error("AppendLogCenterMenuTask.getBaseContent()", (Throwable)ioe);
        }
        finally {
            if (null != br) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    LOGGER.error("AppendLogCenterMenuTask.getBaseContent()", (Throwable)e);
                }
            }
            if (null != isr) {
                try {
                    isr.close();
                }
                catch (IOException e) {
                    LOGGER.error("AppendLogCenterMenuTask.getBaseContent()", (Throwable)e);
                }
            }
            if (null != fin) {
                try {
                    fin.close();
                }
                catch (IOException e) {
                    LOGGER.error("AppendLogCenterMenuTask.getBaseContent()", (Throwable)e);
                }
            }
        }
        return sb.toString();
    }

    private String getAppendContent() {
        File f = new File(this.appendFilePath);
        String content = FileUtil.getContentFromFile(f);
        return content;
    }

    public String getAppendFilePath() {
        return this.appendFilePath;
    }

    public void setAppendFilePath(String appendFilePath) {
        this.appendFilePath = appendFilePath;
    }

    public String getBaseFilePath() {
        return this.baseFilePath;
    }

    public void setBaseFilePath(String baseFilePath) {
        this.baseFilePath = baseFilePath;
    }
}

