/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ant.task;

import com.huawei.elog.util.FileUtil;
import java.io.File;
import java.text.Normalizer;
import org.apache.tools.ant.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendLogCenterNginxConfTask
extends Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppendLogCenterNginxConfTask.class);
    private static final String ESIGHT_HTTPS_PORT_REGEX = "<param name=\"httpsPort\">";
    private String omsConfFile;
    private String negixConfFile;
    private String negixElogFilePath;
    private String esightHttpPort;
    private String esightHttpsPort;
    private String elogIp;
    private String elogHttpPort;
    private String elogHttpsPort;

    public void execute() {
        super.execute();
        try {
            String[] paras;
            String negixConfContent = this.getNegixConfContent();
            String normalizeNegixConfContent = Normalizer.normalize(negixConfContent, Normalizer.Form.NFKC);
            if (normalizeNegixConfContent.indexOf("upstream vsm") > -1 && normalizeNegixConfContent.indexOf("account:target=vsm") > -1) {
                LOGGER.info("has configged vsm nginx, spikked.", (Object)"exec");
                return;
            }
            String esightOmsConf = FileUtil.getContentFromFile(new File(this.getOmsConfFile()));
            for (String para : paras = esightOmsConf.split("\n")) {
                String normalizePara = Normalizer.normalize(para, Normalizer.Form.NFKC);
                if (!normalizePara.contains(ESIGHT_HTTPS_PORT_REGEX)) continue;
                this.setEsightHttpsPort(normalizePara.trim().substring(ESIGHT_HTTPS_PORT_REGEX.length(), normalizePara.trim().indexOf("</param>")));
                break;
            }
            if (null == this.getEsightHttpsPort() || this.getEsightHttpsPort().isEmpty()) {
                this.setEsightHttpsPort("31943");
            }
            String negixHttps4ElogCont = FileUtil.getContentFromFile(new File(this.negixElogFilePath + File.separator + "negixHttps4Elog.txt"));
            negixHttps4ElogCont = negixHttps4ElogCont.replace("{eSightHttpsPort}", this.getEsightHttpsPort());
            String negixProxy4ElogCont = FileUtil.getContentFromFile(new File(this.negixElogFilePath + File.separator + "negixProxy4Elog.txt"));
            negixProxy4ElogCont = negixProxy4ElogCont.replace("{elogIp}", this.getElogIp());
            negixProxy4ElogCont = negixProxy4ElogCont.replace("{elogHttpsPort}", this.getElogHttpsPort());
            normalizeNegixConfContent = normalizeNegixConfContent.replace("#nodejs", negixHttps4ElogCont);
            normalizeNegixConfContent = normalizeNegixConfContent.substring(0, normalizeNegixConfContent.lastIndexOf("}")) + negixProxy4ElogCont;
            FileUtil.writeContent2File(new File(this.negixConfFile), normalizeNegixConfContent);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            LOGGER.error("AppendLogCenterNginxConfTask.execute", (Throwable)ex);
        }
    }

    private String getNegixConfContent() {
        File f = new File(this.getNegixConfFile());
        String content = FileUtil.getContentFromFile(f);
        return content;
    }

    public void setEsightHttpsPort(String esightHttpsPort) {
        this.esightHttpsPort = esightHttpsPort;
    }

    public String getEsightHttpsPort() {
        return this.esightHttpsPort;
    }

    public void setEsightHttpPort(String esightHttpPort) {
        this.esightHttpPort = esightHttpPort;
    }

    public String getEsightHttpPort() {
        return this.esightHttpPort;
    }

    public void setElogIp(String elogIp) {
        this.elogIp = elogIp;
    }

    public String getElogIp() {
        return this.elogIp;
    }

    public void setElogHttpsPort(String elogHttpsPort) {
        this.elogHttpsPort = elogHttpsPort;
    }

    public String getElogHttpsPort() {
        return this.elogHttpsPort;
    }

    public void setNegixConfFile(String negixConfFile) {
        this.negixConfFile = negixConfFile;
    }

    public String getNegixConfFile() {
        return this.negixConfFile;
    }

    public String getOmsConfFile() {
        return this.omsConfFile;
    }

    public void setOmsConfFile(String omsConfFile) {
        this.omsConfFile = omsConfFile;
    }

    public void setNegixElogFilePath(String negixElogFilePath) {
        this.negixElogFilePath = negixElogFilePath;
    }

    public String getNegixElogFilePath() {
        return this.negixElogFilePath;
    }

    public void setElogHttpPort(String elogHttpPort) {
        this.elogHttpPort = elogHttpPort;
    }

    public String getElogHttpPort() {
        return this.elogHttpPort;
    }
}

