/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ant.task;

import com.huawei.elog.util.FileUtil;
import java.io.File;
import java.text.Normalizer;
import org.apache.tools.ant.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetJettyKeyStorePwdTask
extends Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetJettyKeyStorePwdTask.class);
    private static final String PASS_PRO_BEGIN = "ssl.keystore.password";
    private String roaInstXml;
    private String securityProperties;

    public void execute() {
        super.execute();
        String jettyServerKeyStorePwd = this.getJettyServerKeyStorePwd();
        String securityPropertiesCont = FileUtil.getContentFromFile(new File(this.securityProperties));
        LOGGER.info("securityProperties: " + this.securityProperties);
        securityPropertiesCont = securityPropertiesCont.replace("{jettyServerKeyStorePwd}", jettyServerKeyStorePwd);
        FileUtil.writeContent2File(new File(this.securityProperties), securityPropertiesCont);
    }

    private String getJettyServerKeyStorePwd() {
        String jettyServerKeyStorePwd = "";
        String smXmlContent = FileUtil.getContentFromFile(new File(this.roaInstXml));
        String[] smXmls = smXmlContent.split("\n");
        boolean jetty = false;
        for (String smpara : smXmls) {
            String normalizeSmpara = Normalizer.normalize(smpara, Normalizer.Form.NFKC);
            if (normalizeSmpara.contains("JettyServerKeyStore")) {
                jetty = true;
            }
            if (!jetty || !normalizeSmpara.contains(PASS_PRO_BEGIN)) continue;
            normalizeSmpara = normalizeSmpara.substring(normalizeSmpara.indexOf("value"));
            jettyServerKeyStorePwd = normalizeSmpara.substring(normalizeSmpara.indexOf("\"") + 1, normalizeSmpara.lastIndexOf("\""));
            return jettyServerKeyStorePwd;
        }
        return jettyServerKeyStorePwd;
    }

    public String getRoaInstXml() {
        return this.roaInstXml;
    }

    public void setRoaInstXml(String roaInstXml) {
        this.roaInstXml = roaInstXml;
    }

    public String getSecurityProperties() {
        return this.securityProperties;
    }

    public void setSecurityProperties(String securityProperties) {
        this.securityProperties = securityProperties;
    }
}

