/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ant.task;

import com.huawei.elog.base.tools.StartInstallWindow;
import com.huawei.elog.common.StreamProcUtil;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.util.CmdUtil;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.FileUtil;
import com.huawei.elog.util.ResourceManager;
import com.huawei.elog.util.ServiceUtil;
import com.huawei.elog.util.sdp.EncryptData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import org.apache.tools.ant.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallMySQLUtil
extends Task {
    private static double heightTmb = 4096.0;
    private static double lowBb = 2048.0;
    private static final Logger LOGGER = LoggerFactory.getLogger(InstallMySQLUtil.class);
    private static String basePath;
    private static String installPath;
    private static String dbPort;
    private static String password;
    private static String dbType;
    private static String dbUrl;
    private static String mySQLSVC;

    public void execute() {
        super.execute();
        try {
            InstallMySQLUtil.replaceMysqlMB();
            InstallMySQLUtil.createMySQLServiceFile();
            InstallMySQLUtil.startMySqlDBService();
            InstallMySQLUtil.updataMysqlPass();
        }
        catch (Exception e) {
            StartInstallWindow.getInstance().setVisible(false);
            OptionPane.showErrorDialog(ResourceManager.getString("VSM.SILENT.INSTALL.MYSQL.FAILURE"));
            LOGGER.error("InstallMySQLUtil error" + e, (Object)"execute");
        }
    }

    public static void copyMySQLRunFiles() {
        String srcDir = basePath + "data" + File.separator + "db" + File.separator + "MySQL";
        String destDir = installPath + File.separator + "MySQL";
        FileUtil.copyFolder(srcDir, destDir);
    }

    public static boolean startMySqlDBService() throws InterruptedException {
        boolean startRet = false;
        String baseDir = installPath + File.separator + "MySQL" + File.separator + "bin" + File.separator + "";
        String dataDir = installPath + File.separator + "MySQL" + File.separator + "data" + File.separator + "";
        String strCmd = baseDir + "addToSystemService.bat";
        LOGGER.debug("start MySqlDBService...", (Object)"startMySqlDBService");
        CmdUtil.runbatParams(strCmd, null);
        int i = 0;
        while (ServiceUtil.isServiceNotExist(mySQLSVC)) {
            Thread.sleep(1000L);
            if (i == 60) {
                LOGGER.error("mysql service is not exist, check the service list of server.");
                throw new InterruptedException("mysql service is not exist, check the service list of server.");
            }
            LOGGER.debug("Retry time of adding mysqlservice is: " + i, (Object)"startMySqlDBService");
            ++i;
        }
        LOGGER.info("start MySqlDBService...end");
        LOGGER.debug("Initialize MySqlDBService...", (Object)"Initialize");
        LOGGER.info("Initialize MySqlDBService..." + dataDir + "mysql");
        ServiceUtil.mysqlDataDirClear(dataDir);
        CmdUtil.runbatParams(baseDir + "initialize_service.bat", null);
        i = 0;
        while (!ServiceUtil.isServiceDataInitialize(dataDir)) {
            Thread.sleep(1000L);
            if (i == 60) {
                LOGGER.error("mysql service initialize fail.");
                throw new InterruptedException("mysql service initialize fail.");
            }
            LOGGER.debug("Retry time of initialize mysqlservice is: " + i, (Object)"startMySqlDBService");
            LOGGER.info("Retry time of initialize mysqlservice is: " + i, (Object)"startMySqlDBService");
            ++i;
        }
        LOGGER.info("end Initialize MySqlDBService..." + dataDir + "mysql");
        strCmd = baseDir + "startMysqlService.bat";
        CmdUtil.runbatParams(strCmd, null);
        i = 0;
        while (ServiceUtil.isServiceNotRunning(mySQLSVC)) {
            Thread.sleep(1000L);
            if (i == 60) {
                LOGGER.error("mysql service is not in RUNNING state.");
                throw new InterruptedException("mysql service is not in RUNNING state.");
            }
            LOGGER.debug("Retry time of get RUNNING state is: " + i, (Object)"startMySqlDBService");
            ++i;
        }
        startRet = true;
        return startRet;
    }

    public static void replaceMysqlMB() {
        String filePath = installPath + File.separator + "MySQL" + File.separator;
        double mb = InstallMySQLUtil.findMemony();
        LOGGER.info("ExtendReplaceUtil.replaceMysqlMB>>filepath: replaceMysqlMB");
        if (mb < lowBb) {
            FileUtil.copyFile(filePath + "my-small.ini", filePath + "my.ini");
        } else if (mb < heightTmb && mb >= lowBb) {
            FileUtil.copyFile(filePath + "my-medium.ini", filePath + "my.ini");
        } else {
            FileUtil.copyFile(filePath + "my-large.ini", filePath + "my.ini");
        }
        InstallMySQLUtil.changeMyIniPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void changeMyIniPort() {
        FileOutputStream outStreamTemp;
        InputStreamReader inReaderTemp;
        FileInputStream inStreamTemp;
        OutputStreamWriter fw;
        BufferedReader reader;
        block8: {
            String myIniPath = installPath + File.separator + "MySQL" + File.separator + "my.ini";
            LOGGER.debug(myIniPath, (Object)"Change mysql ini file path");
            reader = null;
            fw = null;
            inStreamTemp = null;
            inReaderTemp = null;
            outStreamTemp = null;
            try {
                String port;
                File myFile = new File(myIniPath);
                if (!myFile.exists()) break block8;
                inStreamTemp = new FileInputStream(myFile);
                inReaderTemp = new InputStreamReader((InputStream)inStreamTemp, "utf-8");
                reader = new BufferedReader(inReaderTemp);
                StringBuffer stringBuffer = new StringBuffer();
                while ((port = reader.readLine()) != null) {
                    String[] index;
                    if (port.contains("=") && (index = port.split("="))[0].trim().equalsIgnoreCase("port")) {
                        port = index[0] + "= " + dbPort;
                    }
                    stringBuffer.append(port + "\n");
                }
                outStreamTemp = new FileOutputStream(myFile);
                fw = new OutputStreamWriter((OutputStream)outStreamTemp, "utf-8");
                fw.write(stringBuffer.toString());
            }
            catch (FileNotFoundException e) {
                LOGGER.error("Failed to found file: ", (Throwable)e);
                StreamProcUtil.close(reader);
                StreamProcUtil.close(inReaderTemp);
                StreamProcUtil.close((InputStream)inStreamTemp);
                StreamProcUtil.close(fw);
                StreamProcUtil.close(outStreamTemp);
            }
            catch (IOException e2) {
                LOGGER.error("Change mysql ini file error", (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        StreamProcUtil.close(reader);
                        StreamProcUtil.close(inReaderTemp);
                        StreamProcUtil.close(inStreamTemp);
                        StreamProcUtil.close(fw);
                        StreamProcUtil.close(outStreamTemp);
                        throw throwable;
                    }
                }
                StreamProcUtil.close(reader);
                StreamProcUtil.close(inReaderTemp);
                StreamProcUtil.close((InputStream)inStreamTemp);
                StreamProcUtil.close(fw);
                StreamProcUtil.close(outStreamTemp);
            }
        }
        StreamProcUtil.close(reader);
        StreamProcUtil.close(inReaderTemp);
        StreamProcUtil.close((InputStream)inStreamTemp);
        StreamProcUtil.close(fw);
        StreamProcUtil.close(outStreamTemp);
    }

    public static void createMySQLServiceFile() {
        String tmpFilePath = basePath + "antiddos_collector" + File.separator + "template";
        String createFileName = installPath + File.separator + "MySQL" + File.separator + "bin" + File.separator;
        HashMap<String, Object> configSource = new HashMap<String, Object>();
        String strMysqlPath = installPath + File.separator + "MySQL";
        configSource.put("mysql_install_path", strMysqlPath);
        InstallMySQLUtil.wait(createFileName);
        CommonUtil.createTemplateFile(tmpFilePath, "addToSystem_service_template.bat", createFileName + "addToSystemService.bat", configSource);
        CommonUtil.createTemplateFile(tmpFilePath, "initialize_service_template.bat", createFileName + "initialize_service.bat", configSource);
    }

    public static void wait(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            LOGGER.info("wait the folder build:", (Object)"wait");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOGGER.debug("wait end: ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double findMemony() {
        Runtime runtime = Runtime.getRuntime();
        BufferedReader bufReader = null;
        InputStreamReader inStreamReader = null;
        InputStream inStream = null;
        Process process = null;
        double mb = 0.0;
        try {
            String str = "cmd /c chcp 437 && cmd /c systeminfo | findstr \"Total\"";
            process = runtime.exec(str);
            inStream = process.getInputStream();
            inStreamReader = new InputStreamReader(inStream, "utf-8");
            bufReader = new BufferedReader(inStreamReader);
            String listeningCmdLine = bufReader.readLine();
            if (null != listeningCmdLine && !listeningCmdLine.startsWith("Total") && null != (listeningCmdLine = bufReader.readLine()) && listeningCmdLine.startsWith("Total")) {
                mb = Double.parseDouble(listeningCmdLine.split(":")[1].trim().split(" ")[0].replaceAll(",", ""));
            }
            LOGGER.info("find System's memony is:::", (Object)"findMemony");
        }
        catch (IOException e) {
            LOGGER.error("find System's memony Exception " + e, (Object)"findMemony");
        }
        finally {
            if (null != bufReader) {
                try {
                    bufReader.close();
                }
                catch (IOException e) {
                    LOGGER.debug("findMemony", (Throwable)e);
                }
            }
            if (null != inStreamReader) {
                try {
                    inStreamReader.close();
                }
                catch (IOException e) {
                    LOGGER.debug("findMemony", (Throwable)e);
                }
            }
            if (null != inStream) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    LOGGER.debug("findMemony", (Throwable)e);
                }
            }
            if (null != process) {
                process.destroy();
            }
        }
        return mb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updataMysqlPass() {
        Connection conn = null;
        Statement ps = null;
        Properties info = new Properties();
        info.setProperty("user", "root");
        try {
            LOGGER.info("dbUrl: " + dbUrl);
            conn = InstallMySQLUtil.getMysqlConn(dbUrl, info);
            if (null == conn) {
                LOGGER.error("Conncetion Is Null...", (Object)"updataMysqlPass");
            }
            if (null != conn) {
                LOGGER.info("password: ALTER USER 'root'@'localhost' IDENTIFIED BY ?");
                ps = conn.prepareStatement("ALTER USER 'root'@'localhost' IDENTIFIED BY ?");
                ps.setString(1, password);
                ps.execute();
                ps.close();
                ps = conn.prepareStatement("CREATE USER 'root'@'127.0.0.1' IDENTIFIED BY ?");
                ps.setString(1, password);
                ps.execute();
                ps.close();
                ps = conn.prepareStatement("GRANT ALL PRIVILEGES ON *.* TO 'root'@'%' IDENTIFIED BY ? WITH GRANT OPTION");
                ps.setString(1, password);
                ps.execute();
                ps.close();
                ps = conn.prepareStatement("FLUSH PRIVILEGES");
                ps.execute();
                ps.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Conncetion DataBase Faile...", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Conncetion DataBase Faile...", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.error("Conncetion DataBase Faile...", (Throwable)e);
        }
        finally {
            if (null != ps) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    LOGGER.error("updataMysqlPass", (Throwable)e);
                }
            }
            if (null != conn) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    LOGGER.error("updataMysqlPass", (Throwable)e);
                }
            }
        }
    }

    public static Connection getMysqlConn(String url, String user, String oldPassword) throws InterruptedException, ClassNotFoundException {
        Connection conn = null;
        Class.forName("com.mysql.jdbc.Driver");
        for (int i = 0; i < 3; ++i) {
            if (null != conn) continue;
            try {
                conn = DriverManager.getConnection(url, user, oldPassword);
                LOGGER.debug("....getMysqlConn Is Ok....");
                continue;
            }
            catch (SQLException e) {
                Thread.sleep(3000L);
                LOGGER.debug("--getMysqlConn Is Null---");
            }
        }
        return conn;
    }

    public static Connection getMysqlConn(String url, Properties info) throws InterruptedException, ClassNotFoundException {
        Connection conn = null;
        Class.forName("com.mysql.jdbc.Driver");
        for (int i = 0; i < 3; ++i) {
            if (null != conn) continue;
            try {
                conn = DriverManager.getConnection(url, info);
                LOGGER.info("....getMysqlConn Is Ok...." + conn);
                continue;
            }
            catch (Exception e) {
                Thread.sleep(3000L);
                LOGGER.error("--getMysqlConn Is Null---" + e);
            }
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getConfigPassword(String savePath) {
        String configPath = "";
        String pw = "";
        String text = "";
        BufferedReader reader = null;
        InputStreamReader fileReader = null;
        try {
            configPath = savePath + File.separator + "config" + File.separator + "conf" + File.separator + "config.properties";
            FileInputStream file = new FileInputStream(new File(configPath));
            fileReader = new InputStreamReader((InputStream)file, "utf-8");
            reader = new BufferedReader(fileReader);
            while ((text = reader.readLine()) != null) {
                if (text.indexOf("lego.install.db.mysql.host.pswd") == -1) continue;
                EncryptData encryptData = EncryptData.getInstanse();
                pw = encryptData.decrypt(text.substring(text.indexOf("=") + 1, text.length()));
            }
        }
        catch (IOException e) {
            LOGGER.error("getConfigPassword", (Throwable)e);
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOGGER.error("InstallMySQLUtil.getConfigPassword()", (Throwable)e);
                }
            }
            if (null != fileReader) {
                try {
                    fileReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("InstallMySQLUtil.getConfigPassword()", (Throwable)e);
                }
            }
        }
        return pw;
    }

    public static String getPassword() {
        return password;
    }

    public static void setPassword(String password) {
        InstallMySQLUtil.password = password;
    }

    public static String getDbType() {
        return dbType;
    }

    public static void setDbType(String dbType) {
        InstallMySQLUtil.dbType = dbType;
    }

    public static String getBasePath() {
        return basePath;
    }

    public static void setBasePath(String basePath) {
        InstallMySQLUtil.basePath = basePath;
    }

    public static String getInstallPath() {
        return installPath;
    }

    public static void setInstallPath(String installPath) {
        InstallMySQLUtil.installPath = installPath;
    }

    public static String getDbPort() {
        return dbPort;
    }

    public static void setDbPort(String dbPort) {
        InstallMySQLUtil.dbPort = dbPort;
    }

    public static String getDbUrl() {
        return dbUrl;
    }

    public static void setDbUrl(String dbUrl) {
        InstallMySQLUtil.dbUrl = dbUrl;
    }

    static {
        mySQLSVC = "mysqlservice";
    }
}

