/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ant.task;

import com.huawei.elog.base.model.DataBaseInfo;
import com.huawei.elog.common.StreamProcUtil;
import com.huawei.elog.util.FileUtil;
import com.huawei.elog.util.IgnoreDTDEntityResolver;
import com.huawei.elog.util.JarFileUtil;
import com.huawei.elog.util.PropertyManager;
import com.huawei.elog.util.XmlWriterFactory;
import com.huawei.elog.util.sdp.EncryptData;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.tools.ant.Task;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;

public class InstallPlatDBInfoTask
extends Task {
    private static final String DEFAULT_IP = "[IPADDRESS]";
    private static final String DEFAULT_PORT = "[PORT]";
    private static final String MYSQL = "MySQL";
    private static final Logger LOGGER = LoggerFactory.getLogger(InstallPlatDBInfoTask.class);
    private static EncryptData encryptData = EncryptData.getInstanse();
    private String dbHost;
    private String dbPort;
    private String dbUserName;
    private String dbPassword;
    private String dbType;
    private String src;
    private String dest;

    public String getDbHost() {
        return this.dbHost;
    }

    public void setDbHost(String dbHost) {
        this.dbHost = dbHost;
    }

    public String getDbPort() {
        return this.dbPort;
    }

    public void setDbPort(String dbPort) {
        this.dbPort = dbPort;
    }

    public String getDbUserName() {
        return this.dbUserName;
    }

    public void setDbUserName(String dbUserName) {
        this.dbUserName = dbUserName;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public String getSrc() {
        return this.src;
    }

    public void setDest(String dest) {
        this.dest = dest;
    }

    public String getDest() {
        return this.dest;
    }

    public void execute() {
        DataBaseInfo dbInfo = new DataBaseInfo();
        dbInfo.setDbHost(this.dbHost);
        dbInfo.setDbType(this.dbType);
        dbInfo.setDbPassword(this.dbPassword);
        dbInfo.setDbPort(this.dbPort);
        dbInfo.setDbUserName(this.dbUserName);
        try {
            this.copyDataSchema(dbInfo);
        }
        catch (Exception e) {
            LOGGER.error("exec configPropDBFileTask occurs error.", (Throwable)e);
        }
    }

    public void changePropDBFile(DataBaseInfo dbInfor, String savePath) throws IOException {
        LOGGER.info("Change DB Properties ", (Object)"changePropDBFile");
        String dhhost = dbInfor.getDbHost();
        String dbuseName = dbInfor.getDbUserName();
        String dbtype = dbInfor.getDbType();
        String dbport = dbInfor.getDbPort();
        String dbpw = dbInfor.getDbPassword();
        String fileNameOne = "";
        String[] keys = new String[5];
        String[] values = new String[5];
        keys[0] = "hibernate.connection.driver_class";
        keys[1] = "hibernate.connection.username";
        keys[2] = "hibernate.dialect";
        keys[3] = "hibernate.connection.url";
        keys[4] = "hibernate.connection.password";
        if (dbtype.equalsIgnoreCase(MYSQL)) {
            fileNameOne = this.src + PropertyManager.getProValue("hibernate.dbfile.mysql.prop");
            values[0] = PropertyManager.getProValue("hibernate.mysql.connection.driver_class");
            values[1] = dbuseName;
            values[2] = PropertyManager.getProValue("hibernate.mysql.dialect");
            values[3] = PropertyManager.getProValue("hibernate.mysql.connection.url.property").replace(DEFAULT_IP, dhhost).replace(DEFAULT_PORT, dbport);
            values[4] = dbpw;
        }
        String targetFile = savePath + PropertyManager.getProValue("hibernate.dbfile.prop.replace");
        FileUtil.modifyDBPropFileUsingStr(fileNameOne, keys, values, targetFile);
        JarFileUtil.editJar(savePath + "/" + PropertyManager.getProValue("install.lego_version.backend.jar.path") + "/" + PropertyManager.getProValue("install.db.propfile.jar"), "lego.properties", targetFile);
        LOGGER.info("Finish Replace the lego.properties file in jar ", (Object)"changePropDBFile");
    }

    private void copyDataSchema(DataBaseInfo dbInfor) {
        LOGGER.info("Copy DB DataSchema ", (Object)"copyDataSchema");
        String dbtype = dbInfor.getDbType();
        String oldPath = "";
        String target = this.dest + "/" + PropertyManager.getProValue("hibernate.dbfile.target.dataschema");
        if (dbtype.equalsIgnoreCase(MYSQL)) {
            oldPath = this.dest + "/" + PropertyManager.getProValue("hibernate.dbfile.mysql.dataschema");
        }
        FileUtil.copyFile(oldPath, target);
        LOGGER.info("Copy DB DataSchema :", (Object)"copyDataSchema");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void changeDBXmlFile(DataBaseInfo dbInfor, String savePath) throws DocumentException, IOException {
        String targetFile = savePath + PropertyManager.getProValue("hibernate.dbfile.xml.replace");
        LOGGER.info("Change DB XML ", (Object)"changeDBXmlFile");
        String fileNameTow = "";
        SAXReader reader = new SAXReader();
        reader.setEntityResolver((EntityResolver)new IgnoreDTDEntityResolver());
        Document document = null;
        if (dbInfor.getDbType().equalsIgnoreCase(MYSQL)) {
            fileNameTow = this.src + PropertyManager.getProValue("hibernate.dbfile.mysql.xml");
            document = reader.read(new File(fileNameTow));
            InstallPlatDBInfoTask.changeXmlInMysql(document, dbInfor);
        }
        if (null == document) {
            LOGGER.error("changeDBXmlFile error,document is null.");
            return;
        }
        XMLWriter writer = null;
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            writer = XmlWriterFactory.getXmlWriter(new File(targetFile), format);
            writer.write(document);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("File no found." + e);
            StreamProcUtil.close(writer);
        }
        catch (UnsupportedEncodingException e2) {
            LOGGER.error("File no found." + e2);
            {
                catch (Throwable throwable) {
                    StreamProcUtil.close(writer);
                    throw throwable;
                }
            }
            StreamProcUtil.close(writer);
        }
        StreamProcUtil.close(writer);
        JarFileUtil.editJar(savePath + "/" + PropertyManager.getProValue("install.lego_version.backend.jar.path") + "/" + PropertyManager.getProValue("install.db.xmlfile.jar"), "hibernate.cfg.xml", targetFile);
        LOGGER.info("Finish Replace the lego.properties file in jar", (Object)"changeDBXmlFile");
    }

    private static void changeXmlInMysql(Document document, DataBaseInfo dbInfor) {
        List eleList = document.selectNodes("/hibernate-configuration/session-factory/property");
        for (Element element : eleList) {
            String key = element.attributeValue("name");
            if ("connection.driver_class".equalsIgnoreCase(key)) {
                element.setText(PropertyManager.getProValue("hibernate.mysql.connection.driver_class"));
            } else if ("connection.url".equalsIgnoreCase(key)) {
                element.setText(PropertyManager.getProValue("hibernate.mysql.connection.url.xml").replace(DEFAULT_IP, dbInfor.getDbHost()).replace(DEFAULT_PORT, dbInfor.getDbPort()));
            } else if ("connection.username".equalsIgnoreCase(key)) {
                element.setText(dbInfor.getDbUserName());
            } else if ("connection.encryptedpassword".equalsIgnoreCase(key)) {
                element.setText(encryptData.encrypt(dbInfor.getDbPassword()));
            } else if ("dialect".equalsIgnoreCase(key)) {
                element.setText(PropertyManager.getProValue("hibernate.mysql.dialect"));
            } else if ("databasename".equalsIgnoreCase(key)) {
                element.setText("MYSQL");
            }
            LOGGER.info("modified mysql.property.");
        }
    }
}

