/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ant.task;

import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.model.Bundles;
import com.huawei.elog.base.model.ContextPropVal;
import com.huawei.elog.base.model.DataBaseInfo;
import com.huawei.elog.util.db.InitDBTool;
import java.util.Map;
import org.apache.tools.ant.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecneUpdateDBStructureTask
extends Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecneUpdateDBStructureTask.class);
    private String dbHost;
    private String dbPort;
    private String dbUserName;
    private String dbPassword;
    private String dbType;
    private String sOldPTVersion;
    private String bundlePath;

    public void execute() {
        DataBaseInfo dbInfo = new DataBaseInfo();
        dbInfo.setDbHost(this.dbHost);
        dbInfo.setDbType(this.dbType);
        dbInfo.setDbPassword(this.dbPassword);
        dbInfo.setDbPort(this.dbPort);
        dbInfo.setDbUserName(this.dbUserName);
        try {
            if ("ORACLE".equalsIgnoreCase(dbInfo.getDbType())) {
                return;
            }
            ContextPropVal propverVal = InstallContext.getInstance().getEnvirments().getPropertyMap().getProp("lego.base.components.plat");
            Map mapPt = (Map)propverVal.getValue();
            this.sOldPTVersion = ((Bundles)mapPt.get("lego.platform.base.core")).getVersion();
            InitDBTool.updateProductDB(dbInfo, this.bundlePath, this.sOldPTVersion);
        }
        catch (Exception e) {
            LOGGER.error("ChangeProdDBStrucTask" + e.getMessage(), (Object)"execute");
        }
    }

    public String getSOldPTVersion() {
        return this.sOldPTVersion;
    }

    public void setSOldPTVersion(String oldPTVersion) {
        this.sOldPTVersion = oldPTVersion;
    }

    public String getDbHost() {
        return this.dbHost;
    }

    public void setDbHost(String dbHost) {
        this.dbHost = dbHost;
    }

    public String getDbPort() {
        return this.dbPort;
    }

    public void setDbPort(String dbPort) {
        this.dbPort = dbPort;
    }

    public String getDbUserName() {
        return this.dbUserName;
    }

    public void setDbUserName(String dbUserName) {
        this.dbUserName = dbUserName;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public String getBundlePath() {
        return this.bundlePath;
    }

    public void setBundlePath(String bundlePath) {
        this.bundlePath = bundlePath;
    }
}

