/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ant.task;

import com.huawei.elog.util.ParseXmlUtil;
import com.huawei.elog.util.PropertyManager;
import com.huawei.elog.util.ServiceUtil;
import java.io.IOException;
import org.apache.tools.ant.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateProductSVCtoXml
extends Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateProductSVCtoXml.class);
    private static String installPath;

    public void execute() {
        try {
            UpdateProductSVCtoXml.writeProductSVCtoXML();
        }
        catch (Exception e) {
            LOGGER.error("CrossVersionUpdateTask" + e.getMessage(), (Object)"execute");
        }
    }

    private static void writeProductSVCtoXML() throws IOException {
        LOGGER.debug("write product service to xml.", (Object)"WriteProductSVCtoXML");
        String ddosCollectorName = PropertyManager.getProValue("COLLECTOR.DDOS.DDOSSERVER.SERVICENAME");
        String ddosGuardName = PropertyManager.getProValue("COLLECTOR.DDOS.GUARDSERVER.SERVICENAME");
        String elogCollectoName = PropertyManager.getProValue("COLLECTOR.ELOG.ELOGSERVER.SERVICENAME");
        String elogWmiName = PropertyManager.getProValue("COLLECTOR.ELOG.WMISERVER.SERVICENAME");
        String namimgName = PropertyManager.getProValue("COLLECTOR.ELOG.NAMINGSERVICE.SERVICENAME");
        String elogName = PropertyManager.getProValue("COLLECTOR.ELOG.ELOGSERVICES.SERVICENAME");
        if (ServiceUtil.isServiceExist(ddosCollectorName)) {
            ParseXmlUtil.registerServiceName(ddosCollectorName, installPath);
        }
        if (ServiceUtil.isServiceExist(ddosGuardName)) {
            ParseXmlUtil.registerServiceName(ddosGuardName, installPath);
        }
        if (ServiceUtil.isServiceExist(elogCollectoName)) {
            ParseXmlUtil.registerServiceName(elogCollectoName, installPath);
        }
        if (ServiceUtil.isServiceExist(elogWmiName)) {
            ParseXmlUtil.registerServiceName(elogWmiName, installPath);
        }
        if (ServiceUtil.isServiceExist(namimgName)) {
            ParseXmlUtil.registerServiceName(namimgName, installPath);
        }
        if (ServiceUtil.isServiceExist(elogName)) {
            ParseXmlUtil.registerServiceName(elogName, installPath);
        }
    }

    public static String getInstallPath() {
        return installPath;
    }

    public static void setInstallPath(String installPath) {
        UpdateProductSVCtoXml.installPath = installPath;
    }
}

