/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.base;

import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.model.Step;
import com.huawei.elog.base.sdk.IExecute;
import com.huawei.elog.base.sdk.IInstallContext;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.UIUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigLoader.class);

    public List<IExecute> loadExecutors(IInstallContext ctx) {
        String uiDefineFile;
        File file;
        ctx.getEnvirments().readPropMap();
        LOGGER.debug("Install Mode = {}", (Object)ctx.getInstallMode());
        ArrayList<IExecute> executes = new ArrayList<IExecute>();
        if (InstallContext.getInstance().getInstallType().contains("Collector")) {
            String basePath = InstallContext.getInstance().getEnvirments().getBasePath();
            InstallContext.getInstance().getEnvirments().setBasePath(basePath + "/Plug-In/collector/");
        }
        if (!(file = new File(uiDefineFile = ctx.getInstallConfigFile())).exists()) {
            LOGGER.warn("uiDefineFile isn't exist.");
        } else {
            LOGGER.debug("parse ui defined source file.");
        }
        SAXReader sax = new SAXReader();
        try {
            Document document = sax.read(file);
            Element eRootEle = document.getRootElement();
            List exeNodes = ((Element)eRootEle.elements("order").get(0)).elements("executor");
            for (Element exeNode : exeNodes) {
                String exeClsName = exeNode.attributeValue("classname");
                String exeMode = exeNode.attributeValue("mode");
                try {
                    if (UIUtil.isSilentMode() && "gui".equals(exeMode) || !UIUtil.isSilentMode() && "silent".equals(exeMode)) continue;
                    IExecute instance = (IExecute)Class.forName(exeClsName).newInstance();
                    executes.add(instance);
                }
                catch (InstantiationException e) {
                    LOGGER.error(e.getMessage(), (Object)"loadExecutors");
                }
                catch (IllegalAccessException e) {
                    LOGGER.error(e.getMessage(), (Object)"loadExecutors");
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("loadExecutors", (Throwable)e);
                }
            }
            List cards = ((Element)eRootEle.elements("cards").get(0)).elements("page");
            LinkedList<Step> stepList = new LinkedList<Step>();
            int cardIndex = 0;
            for (Element card : cards) {
                Step step = new Step();
                String cardName = card.attributeValue("name");
                String cardClsName = card.attributeValue("classname");
                LOGGER.debug("card name: " + cardName, (Object)"loadExecutors");
                step.setShowName(cardName);
                step.setCardClassName(cardClsName);
                step.setStepIndex(cardIndex);
                ++cardIndex;
                stepList.add(step);
            }
            int size = stepList.size();
            if (size > 1) {
                String nextClassName = ((Step)stepList.get(size - 1)).getCardClassName();
                for (int index = size - 2; index >= 0; --index) {
                    Step current = (Step)stepList.get(index);
                    current.setNextClassName(nextClassName);
                    nextClassName = current.getCardClassName();
                }
            }
            ContextUtil.saveSimpleValue2Ctx("lego.base.cardStepOrder", stepList);
            LinkedHashMap<String, Step> cardMap = new LinkedHashMap<String, Step>();
            for (Step step : stepList) {
                cardMap.put(step.getCardClassName(), step);
            }
            ContextUtil.saveSimpleValue2Ctx("lego.base.cardStepMap", cardMap);
            if (InstallContext.getInstance().getInstallType().contains("Collector")) {
                String basePath = InstallContext.getInstance().getEnvirments().getBasePath();
                basePath = basePath.substring(0, basePath.indexOf("Plug-In"));
                InstallContext.getInstance().getEnvirments().setBasePath(basePath);
            }
        }
        catch (DocumentException e) {
            LOGGER.error("parse document occurs error.", (Throwable)e);
        }
        LOGGER.debug("finish loading config file.");
        return executes;
    }
}

