/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.base;

import com.huawei.elog.base.model.EnvirmentProps;
import com.huawei.elog.base.model.PropertyMap;
import com.huawei.elog.base.sdk.IInstallContext;
import com.huawei.elog.base.sdk.IPropertyMap;
import java.io.File;
import java.text.Normalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InstallContext
implements IInstallContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstallContext.class);
    private static InstallContext instance = new InstallContext();
    private EnvirmentProps envirments = EnvirmentProps.getInstance();
    private PropertyMap propertyMap = new PropertyMap();
    private String installMode = "install";
    private String installType = "legoPlat";
    private String guiMode = "gui";
    private String dbType;
    private String haMode = "NORMAL";
    private String caller;
    private String cmpType;

    private InstallContext() {
    }

    public String getCaller() {
        return this.caller;
    }

    public String getHaMode() {
        return this.haMode;
    }

    public void setHaMode(String haMode) {
        this.haMode = "HA".equals(haMode) ? haMode : "NORMAL";
    }

    public void setCaller(String caller) {
        this.caller = caller;
    }

    @Override
    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    @Override
    public String getGuiMode() {
        return this.guiMode;
    }

    public void setGuiMode(String guiMode) {
        this.guiMode = guiMode;
    }

    public static InstallContext getInstance() {
        return instance;
    }

    @Override
    public EnvirmentProps getEnvirments() {
        return this.envirments;
    }

    @Override
    public IPropertyMap getPropertyMap() {
        return this.propertyMap;
    }

    @Override
    public String getInstallMode() {
        return this.installMode;
    }

    public void setInstallMode(String mode) {
        this.installMode = mode;
    }

    @Override
    public String getInstallConfigFile() {
        String normalInstallMode;
        String userDir;
        String baseDir = userDir = System.getProperty("user.dir");
        String normalizeInstallType = Normalizer.normalize(InstallContext.getInstance().getInstallType(), Normalizer.Form.NFKC);
        if (normalizeInstallType.contains("Collector")) {
            baseDir = this.envirments.getBasePath();
        }
        String file = baseDir + "/etc/resource/" + this.installMode + ".config";
        if ("uninstall".equalsIgnoreCase(this.installMode)) {
            file = this.envirments.getBasePath() + this.installMode + "/" + this.installMode + ".config";
            if (this.installType.contains("Collector")) {
                file = this.envirments.getBasePath().substring(0, this.envirments.getBasePath().replace("\\", "/").indexOf("/Plug-In")) + "/" + this.installMode + ".config";
            }
        }
        if ((normalInstallMode = Normalizer.normalize(this.installMode, Normalizer.Form.NFKC)).contains("patch")) {
            file = this.envirments.getBasePath() + this.installMode + File.separator + this.installMode + ".config";
        }
        return file;
    }

    @Override
    public String getInstallType() {
        return this.installType;
    }

    public void setInstallType(String installType) {
        String normalizeInstallType;
        this.installType = normalizeInstallType = Normalizer.normalize(installType, Normalizer.Form.NFKC);
    }

    public String getCmpType() {
        return this.cmpType;
    }

    public void setCmpType(String cmpType) {
        this.cmpType = cmpType;
    }
}

