/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.base;

import com.huawei.elog.base.ConfigLoader;
import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.exception.InstallException;
import com.huawei.elog.base.sdk.IExecute;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.ui.util.CMDHelper;
import com.huawei.elog.ui.util.RunningLock;
import com.huawei.elog.ui.window.PreWindows;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.ResourceManager;
import com.huawei.elog.util.UIUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);
    private static InstallContext context = InstallContext.getInstance();
    private static String exitStatue = null;

    public Main(String[] args) {
        boolean oldFlag = true;
        ArrayList<String> argOld = new ArrayList<String>();
        ArrayList<String> argNew = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String str = args[i];
            if (str.indexOf("-") == 0) {
                oldFlag = false;
            }
            if (oldFlag) {
                argOld.add(args[i]);
                continue;
            }
            argNew.add(args[i]);
        }
        if (argOld.size() == 1) {
            context.setInstallMode((String)argOld.get(0));
        } else if (argOld.size() == 2) {
            context.setInstallMode((String)argOld.get(0));
            context.setInstallType((String)argOld.get(1));
        } else if (argOld.size() == 3) {
            context.setInstallMode((String)argOld.get(0));
            context.setInstallType((String)argOld.get(1));
            context.getEnvirments().setBasePath((String)argOld.get(2));
        }
        this.parseStandardArgs(argNew.toArray(new String[argNew.size()]));
    }

    private void parseStandardArgs(String[] args) {
        String guiMode = this.getArgValue(args, "mode");
        InstallContext.getInstance().setGuiMode(guiMode);
        String dbType = this.getArgValue(args, "dbtype");
        InstallContext.getInstance().setDbType(dbType);
        String haMode = this.getArgValue(args, "haMode");
        InstallContext.getInstance().setHaMode(haMode);
        String caller = this.getArgValue(args, "caller");
        InstallContext.getInstance().setCaller(caller);
        String cmpType = this.getArgValue(args, "cmpType");
        InstallContext.getInstance().setCmpType(cmpType);
    }

    private String getArgValue(String[] args, String key) {
        return this.getArgValue(args, key, 0);
    }

    private String getArgValue(String[] args, String key, int idx) {
        int argc = args.length;
        String filterKey = "-" + key;
        String keyVal = "";
        String result = "";
        for (int i = idx; i < argc; ++i) {
            if (args[i].indexOf(filterKey) <= -1) continue;
            keyVal = args[i];
            break;
        }
        int eq = keyVal.indexOf("@");
        if (keyVal.indexOf("-") > -1 && eq > -1) {
            result = keyVal.substring(eq + 1);
        }
        return result;
    }

    public static void main(String[] args) {
        Main launcher = new Main(args);
        launcher.testRunning();
        launcher.loadStyles();
        launcher.loadExecutors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExecutors() {
        ConfigLoader loader = new ConfigLoader();
        List<IExecute> executors = loader.loadExecutors(context);
        for (IExecute iExecute : executors) {
            LOGGER.debug("executor: " + iExecute.getClass(), (Object)"loadExecutors");
        }
        boolean execFlag = false;
        try {
            for (IExecute executor : executors) {
                execFlag = executor.exec(context);
                LOGGER.debug(executor.getClass() + " execute result: " + execFlag);
                if (execFlag) continue;
                break;
            }
        }
        catch (InstallException installException) {
            LOGGER.error("main", (Throwable)installException);
        }
        catch (Exception exception) {
            LOGGER.error("main", (Throwable)exception);
        }
        finally {
            if (!execFlag && UIUtil.isSilentMode()) {
                String string = ResourceManager.getString("LogCenter.Install.Silent.Failed");
                LOGGER.error(string);
                CMDHelper.getInstance().println(string);
            }
        }
        if (null != exitStatue && "startEsight".equals(exitStatue)) {
            CommonUtil.shutDownJvm(3);
        } else if (null != exitStatue && "startLogCenter".equals(exitStatue)) {
            CommonUtil.shutDownJvm(2);
        }
        CommonUtil.shutDownJvm(0);
    }

    private void testRunning() {
        if (RunningLock.getInstance().isAnotherInstanceRunning()) {
            LOGGER.error("There is another installation program running. Please exit the program before installation.");
            String errMsg = ResourceManager.getString("AnotherInstance.InstallRunning");
            OptionPane.showErrorDialog(errMsg);
            if (UIUtil.isSilentMode()) {
                CMDHelper.getInstance().println(errMsg);
            }
            CommonUtil.shutDownJvm(-1);
        }
    }

    private void loadStyles() {
        UIUtil.setUIDefaultFont();
        if (!UIUtil.isSilentMode()) {
            PreWindows.getInstance().setVisible(true);
        }
    }

    public static void setExitStatue(String exitStatue) {
        Main.exitStatue = exitStatue;
    }
}

