/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.base.constant;

import com.huawei.elog.base.InstallContext;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.util.CommonUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultValueManager {
    private static DefaultValueManager dvmgr;
    private static final Logger LOGGER;
    private String defaultValuePath;
    private Properties defaultValues;

    private DefaultValueManager() {
        File cfgFile;
        String path = InstallContext.getInstance().getEnvirments().getBasePath();
        String cfgFilePath = "etc" + File.separator + "config" + File.separator + "DefaultValues.properties";
        if (null == path) {
            OptionPane.showErrorDialog("basepath is null...");
            CommonUtil.shutDownJvm(0);
        }
        if (!(cfgFile = new File(path = path + cfgFilePath)).exists()) {
            OptionPane.showErrorDialog("esight default value config file is not exist...");
            CommonUtil.shutDownJvm(0);
        }
        this.setDefaultValuePath(path);
    }

    public static synchronized DefaultValueManager getInstance() {
        if (dvmgr == null) {
            dvmgr = new DefaultValueManager();
        }
        return dvmgr;
    }

    public String getDefaultValue(String key) {
        String tmp = this.defaultValues.getProperty(key, "");
        try {
            tmp = new String(tmp.getBytes("ISO-8859-1"), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.warn("Encoding ISO-8859-1 is not supported for key value , getDefaultValue");
        }
        if (tmp == null || tmp.equals("")) {
            return tmp;
        }
        return tmp.trim();
    }

    public void setDefaultValue(String key, String value) {
        try {
            this.defaultValues.setProperty(key, value);
        }
        catch (Exception e) {
            LOGGER.debug("set default value  in DefaultValues.propertis failed!", (Object)"setDefaultValue");
        }
    }

    public void writePropertiesToFile() {
        FileOutputStream fis = null;
        try {
            fis = new FileOutputStream(this.defaultValuePath);
            this.defaultValues.store(fis, null);
            fis.close();
        }
        catch (IOException e) {
            LOGGER.warn("Exception while loading default values source.");
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e1) {
                    LOGGER.debug("IOException while closing the file.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultValuePath(String path) {
        if (null == path) {
            return;
        }
        this.defaultValuePath = path;
        this.defaultValues = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.defaultValuePath);
            this.defaultValues.load(fis);
            fis.close();
        }
        catch (Exception e) {
            LOGGER.error("setDefaultValuePath", (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e1) {
                    LOGGER.debug("IOException while closing the file ", (Object)"setDefaultValuePath");
                }
            }
        }
    }

    public String getDefaultValuePath() {
        return this.defaultValuePath;
    }

    static {
        LOGGER = LoggerFactory.getLogger(DefaultValueManager.class);
    }
}

