/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.base.context;

import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.model.ContextPropVal;
import com.huawei.elog.base.model.PropertyMap;
import com.huawei.elog.base.sdk.IDefaultProperty;
import com.huawei.elog.base.sdk.IPropertyMap;
import com.huawei.elog.common.StreamProcUtil;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.sdp.EncryptData;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContextLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextLoader.class);
    private static final String INSTALLED_FILE_LEGOPLAT = "/logcenter/legoPlatInstalled.xml";
    private static final String INSTALLED_FILE_COLLECTOR = "/logcenter/CollectorInstalled.xml";
    private static final String HISTORY_PROS_FILE = "/logcenter/reuseHistoryPro.xml";
    private static Map<String, String> historyProsMap = new HashMap<String, String>();

    private ContextLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IPropertyMap loadConetext() {
        PropertyMap propMap;
        FileInputStream ops;
        block8: {
            String coreCfgPath = IDefaultProperty.INSTALLED_FILE_LOGCENTER;
            File coreCfgFile = new File(coreCfgPath);
            if (!coreCfgFile.exists()) {
                LOGGER.warn("Check atic installing...........no");
                coreCfgPath = IDefaultProperty.INSTALLED_FILE_LOGCOLLECTOR;
                coreCfgFile = new File(coreCfgPath);
                if (!coreCfgFile.exists()) {
                    LOGGER.warn("Check collector installing...........no");
                }
            }
            LOGGER.info("Found installed description xml.({})", (Object)coreCfgPath);
            ops = null;
            XStream xstream = new XStream();
            propMap = null;
            try {
                String nmspwd;
                ops = new FileInputStream(coreCfgFile);
                propMap = (PropertyMap)xstream.fromXML((InputStream)ops);
                InstallContext.getInstance().getEnvirments().setPropertyMap(propMap);
                for (Map.Entry entry : propMap.getAllSerialProps().entrySet()) {
                    String key = (String)entry.getKey();
                    ContextPropVal val = (ContextPropVal)entry.getValue();
                    InstallContext.getInstance().getPropertyMap().addProp(key, val);
                }
                String installType = InstallContext.getInstance().getInstallType();
                LOGGER.debug("installType: " + installType, (Object)"getInstallConetext");
                EncryptData encryptData = EncryptData.getInstanse();
                String pwd = ContextUtil.getStrValueFromCtx("lego.db.password.encrypt");
                if (null != pwd) {
                    ContextUtil.saveSearalizeValue2Ctx("lego.db.password", encryptData.decrypt(pwd));
                }
                if (null == (nmspwd = ContextUtil.getStrValueFromCtx("esight.db.nmsdbpassword.encrypt"))) break block8;
                ContextUtil.saveSearalizeValue2Ctx("esight.db.nmsdbpassword", encryptData.decrypt(nmspwd));
            }
            catch (FileNotFoundException e) {
                try {
                    LOGGER.warn("Found no installed description xml.");
                }
                catch (Throwable throwable) {
                    StreamProcUtil.close(ops);
                    throw throwable;
                }
                StreamProcUtil.close(ops);
            }
        }
        StreamProcUtil.close(ops);
        return propMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IPropertyMap loadPreviousVersionConetext() {
        PropertyMap propMap;
        FileInputStream ops;
        block11: {
            String previousVersionPath = System.getProperty("user.home");
            String coreCfgPath = previousVersionPath + File.separator + INSTALLED_FILE_LEGOPLAT;
            File coreCfgFile = new File(coreCfgPath);
            if (!coreCfgFile.exists()) {
                LOGGER.warn("Previous core config file is not exist.");
                coreCfgPath = previousVersionPath + File.separator + INSTALLED_FILE_COLLECTOR;
                coreCfgFile = new File(coreCfgPath);
                if (!coreCfgFile.exists()) {
                    LOGGER.warn("Previous core config file is not exist.");
                }
            }
            ops = null;
            XStream xstream = new XStream();
            propMap = null;
            Iterator iter = null;
            ContextLoader.getProsForHistory();
            try {
                String nmspwd;
                ops = new FileInputStream(coreCfgFile);
                propMap = (PropertyMap)xstream.fromXML((InputStream)ops);
                if (propMap != null) {
                    InstallContext.getInstance().getEnvirments().setPropertyMap(propMap);
                }
                if (propMap != null) {
                    iter = propMap.getAllSerialProps().entrySet().iterator();
                }
                if (iter != null) {
                    while (iter.hasNext()) {
                        Map.Entry entry = iter.next();
                        String key = (String)entry.getKey();
                        ContextPropVal val = (ContextPropVal)entry.getValue();
                        if (!historyProsMap.containsKey(key)) continue;
                        InstallContext.getInstance().getPropertyMap().addProp(key, val);
                    }
                }
                String installType = InstallContext.getInstance().getInstallType();
                LOGGER.debug("installType: " + installType, (Object)"getInstallConetext");
                if (!"legoPlat".equals(installType)) break block11;
                EncryptData encryptData = EncryptData.getInstanse();
                String pwd = ContextUtil.getStrValueFromCtx("lego.db.password.encrypt");
                if (null != pwd) {
                    ContextUtil.saveSearalizeValue2Ctx("lego.db.password", encryptData.decrypt(pwd));
                }
                if (null == (nmspwd = ContextUtil.getStrValueFromCtx("esight.db.nmsdbpassword.encrypt"))) break block11;
                ContextUtil.saveSearalizeValue2Ctx("esight.db.nmsdbpassword", encryptData.decrypt(nmspwd));
            }
            catch (FileNotFoundException e) {
                try {
                    LOGGER.warn("Previous core config file is not exist.");
                }
                catch (Throwable throwable) {
                    StreamProcUtil.close(ops);
                    throw throwable;
                }
                StreamProcUtil.close(ops);
            }
        }
        StreamProcUtil.close(ops);
        return propMap;
    }

    public static void getProsForHistory() {
        SAXReader sax = new SAXReader();
        String previousVersionPath = System.getProperty("user.home");
        String historyNeedProsFile = previousVersionPath + File.separator + HISTORY_PROS_FILE;
        try {
            Document document = sax.read(new File(historyNeedProsFile));
            Element proForHistory = (Element)document.selectSingleNode("/proForHistory");
            List prosHistoyList = proForHistory.elements("pro");
            for (Element element : prosHistoyList) {
                String proName = element.attributeValue("name");
                String proValue = element.attributeValue("value");
                historyProsMap.put(proName, proValue);
            }
        }
        catch (DocumentException e) {
            LOGGER.error("parseHistoryProsMap", (Throwable)e);
        }
    }
}

