/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.base.model;

import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.Main;
import com.huawei.elog.base.context.ContextLoader;
import com.huawei.elog.base.model.PropertyMap;
import com.huawei.elog.base.sdk.IDefaultProperty;
import com.huawei.elog.base.sdk.IPropertyMap;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.ResourceManager;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.Normalizer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvirmentProps {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvirmentProps.class);
    private static String basePath = null;
    private static String osName = null;
    private static EnvirmentProps instance = null;
    private boolean ifSystemInstalled = false;
    private PropertyMap propertyMap = new PropertyMap();

    protected EnvirmentProps() {
        EnvirmentProps.initialize();
    }

    public static void setBasePathValue(String baseaPath) {
        basePath = baseaPath;
    }

    public void setBasePath(String baseaPath) {
        EnvirmentProps.setBasePathValue(baseaPath);
    }

    public String getOsName() {
        return osName;
    }

    public boolean isSystemInstalled() {
        return this.ifSystemInstalled;
    }

    public static synchronized EnvirmentProps getInstance() {
        if (instance == null) {
            instance = new EnvirmentProps();
        }
        return instance;
    }

    private static void initialize() {
        String jarPath = Main.class.getProtectionDomain().getCodeSource().getLocation().toString();
        if ((jarPath = Normalizer.normalize(jarPath, Normalizer.Form.NFKC)).contains("+")) {
            OptionPane.showErrorDialog(ResourceManager.getString("LEGO.PATH.ISNTALL.ERROR.CHAR"));
            CommonUtil.shutDownJvm(0);
        }
        try {
            jarPath = URLDecoder.decode(jarPath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("decode error:" + e.getMessage(), (Object)"initialize");
        }
        if (jarPath.contains("Rar$")) {
            OptionPane.showErrorDialog(ResourceManager.getString("LEGO.PATH.ISNTALL.ERROR.RAR"));
            CommonUtil.shutDownJvm(0);
        }
        basePath = "";
        if (-1 != jarPath.indexOf(":") && Normalizer.normalize(System.getProperty("os.name"), Normalizer.Form.NFKC).contains("Windows")) {
            basePath = jarPath.substring(jarPath.indexOf("/") + 1, jarPath.lastIndexOf("/"));
            basePath = basePath.substring(0, basePath.lastIndexOf("/") + 1);
            osName = "windows";
        } else {
            basePath = jarPath.substring(jarPath.indexOf("/"), jarPath.lastIndexOf("/"));
            basePath = Normalizer.normalize(basePath, Normalizer.Form.NFKC);
            basePath = basePath.substring(0, basePath.lastIndexOf("/") + 1);
            osName = "linux";
        }
    }

    public void setPropertyMap(IPropertyMap propMap) {
        this.propertyMap.setPropsMap(propMap.getAllSerialProps());
    }

    public IPropertyMap getPropertyMap() {
        return this.propertyMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePropMap() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("utf8"));
        FileOutputStream ops = null;
        String path = this.propertyMap.getProp("lego.base.installpath").getValue().toString() + File.separator + InstallContext.getInstance().getInstallType() + "Installed.xml";
        try {
            File file = new File(path);
            ops = new FileOutputStream(file);
            xstream.toXML((Object)this.propertyMap, (OutputStream)ops);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Object)"writePropMap");
        }
        finally {
            if (null != ops) {
                try {
                    ops.close();
                }
                catch (IOException e) {
                    LOGGER.error("close io occrus error.", (Throwable)e);
                }
            }
        }
        LOGGER.info("writePropMap success.");
    }

    public void readPropMap() {
        String coreCfgPath;
        File coreCfgFile;
        ContextLoader.loadConetext();
        LOGGER.info("Successfully loaded context.");
        if ("install".equalsIgnoreCase(InstallContext.getInstance().getInstallMode()) && (coreCfgFile = new File(coreCfgPath = IDefaultProperty.INSTALLED_INFOMATION_FILE)).exists()) {
            this.ifSystemInstalled = true;
        }
    }

    public void setSystemInstalled(boolean systemInstalled) {
        this.ifSystemInstalled = systemInstalled;
    }

    public String getBasePath() {
        if (StringUtils.isEmpty((CharSequence)basePath)) {
            String userDir = System.getProperty("user.dir");
            this.setBasePath(userDir);
            if (InstallContext.getInstance().getInstallType().contains("Collector")) {
                this.setBasePath(new File(userDir).getParent());
            }
            LOGGER.info("EnvirmentProps basepath is empty.");
        }
        return basePath;
    }
}

