/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.base.model;

import com.huawei.elog.base.model.ContextPropVal;
import com.huawei.elog.base.sdk.IPropertyMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyMap
implements IPropertyMap,
Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyMap.class);
    private Map<String, ContextPropVal> propMap = new HashMap<String, ContextPropVal>();

    @Override
    public void addProp(String name, ContextPropVal value) {
        this.propMap.put(name, value);
    }

    @Override
    public ContextPropVal getProp(String name) {
        return this.propMap.get(name);
    }

    @Override
    public void modifyProp(String name, ContextPropVal value) {
        if (this.propMap.containsKey(name)) {
            this.propMap.remove(name);
            this.propMap.put(name, value);
        }
    }

    @Override
    public void removeProp(String name) {
        this.propMap.remove(name);
    }

    @Override
    public Map getAllAntProps() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, ContextPropVal> entry : this.propMap.entrySet()) {
            String key = entry.getKey();
            ContextPropVal val = entry.getValue();
            if (!val.isIsAntProperty().booleanValue() || null == val.getValue()) continue;
            result.put(key, val.getValue().toString());
        }
        return result;
    }

    @Override
    public Map getAllSerialProps() {
        HashMap<String, ContextPropVal> result = new HashMap<String, ContextPropVal>();
        for (Map.Entry<String, ContextPropVal> entry : this.propMap.entrySet()) {
            String key = entry.getKey();
            ContextPropVal val = entry.getValue();
            if (!val.isIsSearalize().booleanValue()) continue;
            result.put(key, val);
        }
        return result;
    }

    public void setPropsMap(Map propsMap) {
        this.propMap.clear();
        this.propMap = propsMap;
    }

    @Override
    public Object clone() {
        PropertyMap pm = null;
        try {
            pm = (PropertyMap)super.clone();
            pm.propMap = new HashMap<String, ContextPropVal>();
            for (Map.Entry<String, ContextPropVal> entry : this.propMap.entrySet()) {
                String key = entry.getKey();
                ContextPropVal value = (ContextPropVal)entry.getValue().clone();
                pm.propMap.put(key, value);
            }
        }
        catch (CloneNotSupportedException e) {
            LOG.error("clone", (Throwable)e);
        }
        return pm;
    }

    @Override
    public boolean isContained(String name) {
        Iterator<String> it = this.propMap.keySet().iterator();
        String key = null;
        while (it.hasNext()) {
            key = it.next();
            if (null == key || key.trim().isEmpty() || !key.equals(name)) continue;
            return true;
        }
        return false;
    }
}

