/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.base.model;

import com.huawei.elog.base.BaseStyle;
import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.model.ContextPropVal;
import com.huawei.elog.base.model.Step;
import com.huawei.elog.base.sdk.IInstallContext;
import com.huawei.elog.base.sdk.IMainUIWizard;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.ui.card.uninstall.UninstallCard;
import com.huawei.elog.ui.util.RunningLock;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.OSUtil;
import com.huawei.elog.util.ResourceManager;
import com.huawei.elog.util.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WizardDialog
extends JFrame {
    private static final long serialVersionUID = 1967608979782240480L;
    private static final Logger LOGGER = LoggerFactory.getLogger(WizardDialog.class);
    private static final String TOP_ICON_NAME = "MainFrameIcon";
    private List<JLabel> stepLabels;
    private Card currentCard;
    private Box navigationBar;
    private JPanel contentPane;
    private int width = 0;
    private int height = 0;
    private transient IInstallContext installContext;
    private JLabel jTopImg;
    private JButton topCloseButton;
    private JButton topMinButton;
    private final JPanel northPanel = new JPanel();
    private final JLabel titleLabel = new JLabel();
    private int nXPostion = 0;
    private int nYPostion = 0;
    private Point newPoint = new Point();
    private String wizardTitle = "";

    public WizardDialog(List<String> stepNames, Card firstCard, int width, int height, IInstallContext context) {
        this.width = width;
        this.height = height;
        this.installContext = context;
        this.init(stepNames, firstCard);
    }

    @Override
    public String getTitle() {
        return this.wizardTitle;
    }

    private void init(List<String> stepNames, Card firstCard) {
        LOGGER.debug("WizardDialog init componets start...", (Object)"init");
        firstCard.container = this;
        this.stepLabels = new ArrayList<JLabel>();
        if (null != stepNames) {
            for (String stepName : stepNames) {
                JLabel label = new JLabel(stepName);
                this.stepLabels.add(label);
            }
        }
        JPanel outerPane = new JPanel(new BorderLayout());
        outerPane.setBackground(BaseStyle.BACKGROUND_COLOR);
        outerPane.setBorder(BorderFactory.createEtchedBorder(1));
        this.contentPane = new JPanel(new BorderLayout());
        outerPane.add((Component)this.contentPane, "Center");
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBackground(BaseStyle.BACKGROUND_COLOR);
        JPanel midPanel = new JPanel(new BorderLayout());
        midPanel.add((Component)titlePanel, "North");
        midPanel.add((Component)outerPane, "Center");
        JLabel tLabel = new JLabel();
        LOGGER.debug(ResourceManager.getLocale().toString(), (Object)"init");
        if (InstallContext.getInstance().getInstallType().contains("Collector")) {
            tLabel.setIcon(ResourceManager.getIcon("logo_collector", ResourceManager.getLocale()));
        } else {
            tLabel.setIcon(ResourceManager.getIcon("logo_server", ResourceManager.getLocale()));
        }
        titlePanel.add((Component)tLabel, "East");
        this.navigationBar = Box.createHorizontalBox();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBackground(this.getBackground());
        buttonPanel.setBorder(new EmptyBorder(15, 0, 15, 15));
        buttonPanel.setLayout(new BorderLayout());
        buttonPanel.add((Component)this.navigationBar, "East");
        JPanel pane = new JPanel(new BorderLayout());
        this.getContentPane().add(pane);
        LOGGER.debug(this.getLeftPictureName(), (Object)"getLeftPictureName");
        GridBagLayout gridBagLTop = new GridBagLayout();
        this.northPanel.setLayout(gridBagLTop);
        Color col = new Color(200, 200, 200);
        this.northPanel.setBackground(col);
        this.jTopImg = new JLabel();
        this.topCloseButton = new JButton();
        this.topMinButton = new JButton();
        this.jTopImg.setIcon(ResourceManager.getIcon(TOP_ICON_NAME));
        this.topMinButton.setContentAreaFilled(true);
        this.topMinButton.setBorder(BorderFactory.createEmptyBorder());
        this.topMinButton.setBackground(new Color(200, 200, 200));
        this.topCloseButton.setBackground(new Color(200, 200, 200));
        this.topCloseButton.setBorder(BorderFactory.createEmptyBorder());
        this.topMinButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                WizardDialog.this.setExtendedState(1);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                WizardDialog.this.topMinButton.setIcon(ResourceManager.getIcon("minHover"));
            }
        });
        this.topCloseButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                WizardDialog.this.topCloseButton.setIcon(ResourceManager.getIcon("closeHover"));
            }
        });
        this.topCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton cancelBtn;
                Map naviButtons = WizardDialog.this.currentCard.navigationButtons;
                if (naviButtons.containsKey((Object)Navigation.Cancel) && (cancelBtn = (JButton)naviButtons.get((Object)Navigation.Cancel)).isEnabled()) {
                    WizardDialog.this.dealCloseing();
                }
            }
        });
        this.jTopImg.setText(this.getTitle());
        this.northPanel.add((Component)this.jTopImg, new GridBagConstraints(0, 0, 2, 3, 1.0, 1.0, 13, 1, new Insets(0, 2, 0, 0), 0, 0));
        this.northPanel.add((Component)this.titleLabel, new GridBagConstraints(0, 0, 2, 3, 1.0, 1.0, 13, 1, new Insets(0, 40, 0, 0), 0, 0));
        this.northPanel.add((Component)this.topMinButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 0, 3, 1), 0, 0));
        this.northPanel.add((Component)this.topCloseButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 0, 3, 6), 0, 0));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                WizardDialog.this.topMinButton.setIcon(ResourceManager.getIcon("minCheck"));
                WizardDialog.this.topCloseButton.setIcon(ResourceManager.getIcon("closeCheck"));
                WizardDialog.this.topMinButton.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseExited(MouseEvent e) {
                        WizardDialog.this.topMinButton.setIcon(ResourceManager.getIcon("minCheck"));
                    }
                });
                WizardDialog.this.topCloseButton.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseExited(MouseEvent e) {
                        WizardDialog.this.topCloseButton.setIcon(ResourceManager.getIcon("closeCheck"));
                    }
                });
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                WizardDialog.this.topMinButton.setIcon(ResourceManager.getIcon("min"));
                WizardDialog.this.topCloseButton.setIcon(ResourceManager.getIcon("close"));
                WizardDialog.this.topMinButton.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseExited(MouseEvent e) {
                        WizardDialog.this.topMinButton.setIcon(ResourceManager.getIcon("min"));
                    }
                });
                WizardDialog.this.topCloseButton.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseExited(MouseEvent e) {
                        WizardDialog.this.topCloseButton.setIcon(ResourceManager.getIcon("close"));
                    }
                });
            }
        });
        this.northPanel.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                ((WizardDialog)WizardDialog.this).newPoint.x = e.getLocationOnScreen().x - WizardDialog.this.nXPostion;
                ((WizardDialog)WizardDialog.this).newPoint.y = e.getLocationOnScreen().y - WizardDialog.this.nYPostion;
                WizardDialog.this.setLocation(WizardDialog.this.newPoint);
            }
        });
        this.northPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point pFrame = WizardDialog.this.getLocationOnScreen();
                Point pMouse = e.getLocationOnScreen();
                WizardDialog.this.nXPostion = (int)(pMouse.getX() - pFrame.getX());
                WizardDialog.this.nYPostion = (int)(pMouse.getY() - pFrame.getY());
            }
        });
        pane.add((Component)this.northPanel, "North");
        pane.add((Component)midPanel, "Center");
        pane.add((Component)buttonPanel, "South");
        pane.setBorder(BorderFactory.createEtchedBorder(1));
        pane.setBackground(BaseStyle.BACKGROUND_COLOR);
        pane.setPreferredSize(new Dimension(this.width, this.height));
        this.setCurrentCard(firstCard);
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.setUndecorated(true);
        this.pack();
        this.setIconImage(ResourceManager.getImage(TOP_ICON_NAME));
        LOGGER.debug("WizardDialog init componets end...", (Object)"init");
    }

    public void setCurrentCard(final Card card) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null != card) {
                    WizardDialog.this.currentCard = card;
                    WizardDialog.this.contentPane.removeAll();
                    WizardDialog.this.contentPane.add(card);
                    WizardDialog.this.initNavigationHandle();
                    WizardDialog.this.updateNavigationBar();
                    WizardDialog.this.updateStepPane();
                    WizardDialog.this.updateCloseState();
                    WizardDialog.this.wizardTitle = card.getWizardTitle();
                    ContextUtil.saveSimpleValue2Ctx("lego.wizard.active.card", card);
                    WizardDialog.this.contentPane.updateUI();
                }
            }
        });
    }

    private void updateStepPane() {
        int currentStep = this.currentCard.getStep();
        if (0 <= currentStep && currentStep < this.stepLabels.size()) {
            for (int i = 0; i < this.stepLabels.size(); ++i) {
                JLabel stepLabel = this.stepLabels.get(i);
                stepLabel.setIcon(null);
                if (i < currentStep) {
                    stepLabel.setForeground(Color.GRAY);
                    continue;
                }
                if (i == currentStep) {
                    stepLabel.setForeground(Color.WHITE);
                    stepLabel.setHorizontalTextPosition(0);
                    continue;
                }
                stepLabel.setForeground(Color.BLACK);
            }
        }
    }

    private void updateCloseState() {
        boolean hideCloseFlag = false;
        if (null != this.currentCard) {
            if (this.currentCard instanceof UninstallCard) {
                hideCloseFlag = true;
            } else if (this.currentCard instanceof UninstallCard) {
                hideCloseFlag = true;
            }
        }
        if (hideCloseFlag) {
            this.setDefaultCloseOperation(0);
        } else {
            this.setDefaultCloseOperation(3);
        }
    }

    private void initNavigationHandle() {
        if (!this.currentCard.actionInjected) {
            Map naviButtons = this.currentCard.navigationButtons;
            if (naviButtons.containsKey((Object)Navigation.Previous)) {
                JButton previousButton = (JButton)naviButtons.get((Object)Navigation.Previous);
                previousButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Card previousCard = WizardDialog.this.currentCard.getPreviousCard();
                        if (null != previousCard) {
                            WizardDialog.this.setCurrentCard(previousCard);
                        }
                    }
                });
            }
            if (naviButtons.containsKey((Object)Navigation.Next)) {
                JButton nextButton = (JButton)naviButtons.get((Object)Navigation.Next);
                nextButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WizardDialog.this.currentCard.process(Navigation.Next);
                        Card nextCard = WizardDialog.this.currentCard.getNextCard();
                        if (null != nextCard) {
                            nextCard.container = WizardDialog.this.currentCard.container;
                            WizardDialog.this.setCurrentCard(nextCard);
                        }
                    }
                });
            }
            if (naviButtons.containsKey((Object)Navigation.Complete)) {
                JButton completeButton = (JButton)naviButtons.get((Object)Navigation.Complete);
                completeButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WizardDialog.this.currentCard.process(Navigation.Complete);
                    }
                });
            }
            if (naviButtons.containsKey((Object)Navigation.Cancel)) {
                JButton cancelBtn = (JButton)naviButtons.get((Object)Navigation.Cancel);
                cancelBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WizardDialog.this.dealCloseing();
                    }
                });
            }
            this.currentCard.actionInjected = true;
        }
    }

    private void updateNavigationBar() {
        JButton button;
        Map naviButtons = this.currentCard.navigationButtons;
        this.navigationBar.removeAll();
        if (naviButtons.containsKey((Object)Navigation.Previous)) {
            this.navigationBar.add(Box.createHorizontalStrut(4));
            this.navigationBar.add((Component)naviButtons.get((Object)Navigation.Previous));
        }
        if (naviButtons.containsKey((Object)Navigation.Next)) {
            this.navigationBar.add(Box.createHorizontalStrut(4));
            this.navigationBar.add((Component)naviButtons.get((Object)Navigation.Next));
        }
        if (naviButtons.containsKey((Object)Navigation.Complete)) {
            this.navigationBar.add(Box.createHorizontalStrut(4));
            this.navigationBar.add((Component)naviButtons.get((Object)Navigation.Complete));
        }
        if (naviButtons.containsKey((Object)Navigation.Cancel)) {
            this.navigationBar.add(Box.createHorizontalStrut(4));
            this.navigationBar.add((Component)naviButtons.get((Object)Navigation.Cancel));
        }
        if (naviButtons.containsKey((Object)Navigation.Next)) {
            button = (JButton)naviButtons.get((Object)Navigation.Next);
            this.getRootPane().setDefaultButton(button);
            button.requestFocus();
        }
        if (naviButtons.containsKey((Object)Navigation.Complete)) {
            button = (JButton)naviButtons.get((Object)Navigation.Complete);
            this.getRootPane().setDefaultButton(button);
            button.requestFocus();
        }
    }

    private void dealCloseing() {
        String msg = "";
        String softwareName = ContextUtil.getStrValueFromCtx("software.install.name");
        String installMode = this.installContext.getInstallMode();
        msg = installMode.equalsIgnoreCase("changedb") ? ResourceManager.getString("LEGO.UPDATE.EXIT.CHANGEDB", softwareName) : ("uninstall".equalsIgnoreCase(installMode) ? ResourceManager.getString("LEGO.DELETE.EXIT.GUAID", softwareName) : (installMode.equalsIgnoreCase("upgrade") ? ResourceManager.getString("LEGO.UPDATE.EXIT.GUAID", softwareName) : ResourceManager.getString("LEGO.SETUP.EXIT.GUAID", softwareName)));
        int result = OptionPane.showWarnConfirmDialog(this, msg);
        LOGGER.debug("result: " + result, (Object)"dealCloseing");
        if (0 == result) {
            this.dispose();
            CommonUtil.shutDownJvm(0);
        } else {
            this.setDefaultCloseOperation(0);
        }
    }

    private String getLeftPictureName() {
        String pictureName = null;
        if (this.installContext.getInstallMode().equals("install")) {
            pictureName = "pic_setup";
        } else if (this.installContext.getInstallMode().equals("update")) {
            pictureName = "pic_upgrade";
        } else if (this.installContext.getInstallMode().equals("uninstall")) {
            pictureName = "pic_uninstall";
        }
        return pictureName;
    }

    public static abstract class Card
    extends JPanel {
        private static final Logger LOGGER = LoggerFactory.getLogger(Card.class);
        protected IInstallContext installConext = InstallContext.getInstance();
        private WizardDialog container;
        private Card previousCard;
        private boolean actionInjected;
        private Map<Navigation, JButton> navigationButtons = new HashMap<Navigation, JButton>();

        public Card(Card previousCard, Navigation ... supportedNavigation) {
            LOGGER.debug("init begin..", (Object)"card constructor");
            this.setBackground(BaseStyle.BACKGROUND_COLOR);
            this.setLayout(new BorderLayout());
            this.previousCard = previousCard;
            HashSet<Navigation> naviList = new HashSet<Navigation>();
            if (null == supportedNavigation || 0 == supportedNavigation.length) {
                naviList.add(Navigation.Previous);
                naviList.add(Navigation.Next);
                naviList.add(Navigation.Cancel);
            } else {
                naviList.addAll(Arrays.asList(supportedNavigation));
            }
            for (Navigation navigation : naviList) {
                String name = navigation.toString();
                char mnemonic = navigation.mnemonic;
                JButton button = UIUtil.createButton(name, mnemonic);
                button.setMnemonic(mnemonic);
                this.navigationButtons.put(navigation, button);
            }
            this.updateNavigationBar();
            LOGGER.debug("init end..", (Object)"card constructor");
        }

        public abstract String getSummary();

        public final void updateNavigationBar() {
            for (Map.Entry<Navigation, JButton> entry : this.navigationButtons.entrySet()) {
                Navigation type = entry.getKey();
                JButton button = entry.getValue();
                button.setEnabled(this.isValid(type));
            }
        }

        public Card getPreviousCard() {
            return this.previousCard;
        }

        public void setPreviousCard(Card preCard) {
            this.previousCard = preCard;
        }

        public void closeWizardDialog() {
            ContextPropVal uiExeVal = this.installConext.getPropertyMap().getProp("lego.base.installUIExecutor");
            IMainUIWizard mainUI = (IMainUIWizard)uiExeVal.getValue();
            mainUI.closeWizard();
            RunningLock.getInstance().deleteLockTempFile();
        }

        public void hideWizardDialog() {
            ContextPropVal uiExeVal = this.installConext.getPropertyMap().getProp("lego.base.installUIExecutor");
            IMainUIWizard mainUI = (IMainUIWizard)uiExeVal.getValue();
            mainUI.hideWizard();
        }

        public String getWizardTitle() {
            String installType = InstallContext.getInstance().getInstallType();
            String product = null;
            String barndName = ContextUtil.getStrValueFromCtx("software.install.name");
            if (installType.contains("legoPlat")) {
                product = barndName;
            } else if (installType.contains("Collector")) {
                product = "ATIC";
                if (!OSUtil.isChineseLocale()) {
                    product = "ATIC " + ResourceManager.getString("COMMON.TXT.COLLECTOR");
                }
            }
            String guide = null;
            if (installType.contains("legoPlat")) {
                guide = ResourceManager.getString("COMMON.TXT.LOGCENTER.INSTALL", product);
            } else if (installType.contains("Collector")) {
                guide = ResourceManager.getString("COMMON.TXT.COLLECTOR.INSTALL", product);
            }
            return guide;
        }

        public boolean doCostTimeWork() {
            return true;
        }

        public int getStep() {
            ContextPropVal propVal = ContextUtil.getCpvValueFromCtx("lego.base.cardStepMap");
            Map cardStepMap = (Map)propVal.getValue();
            if (cardStepMap != null) {
                Step cardStep = (Step)cardStepMap.get(this.getClass().getName());
                return cardStep.getStepIndex();
            }
            return -1;
        }

        protected abstract Card getNextCard();

        protected Card getNextCardBase() {
            Card nextCard = null;
            try {
                ContextPropVal propVal = this.installConext.getPropertyMap().getProp("lego.base.cardStepMap");
                Map cardMap = (Map)propVal.getValue();
                Step curStep = (Step)cardMap.get(this.getClass().getName());
                String nextClassName = curStep.getNextClassName();
                if (null == nextClassName || nextClassName.trim().isEmpty()) {
                    return nextCard;
                }
                LOGGER.debug("nextClassName: " + nextClassName);
                Class<?> clazz = Class.forName(nextClassName);
                Method method = clazz.getMethod("getInstance", new Class[0]);
                nextCard = (Card)method.invoke(null, new Object[0]);
                LOGGER.debug("clazz: " + clazz + "  method: " + method, (Object)"getNextCardBase");
                this.refreshCardList(nextCard);
                ContextUtil.saveSimpleValue2Ctx("lego.wizard.active.card", nextCard);
                nextCard.setPreviousCard(this);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Next Page error ", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Next Page error ", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Next Page error ", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Next Page error ", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                LOGGER.error("Next Page error ", (Throwable)e);
            }
            catch (SecurityException e) {
                LOGGER.error("Next Page error ", (Throwable)e);
            }
            return nextCard;
        }

        private void refreshCardList(Card clazz) {
            ContextPropVal propVal = this.installConext.getPropertyMap().getProp("lego.base.cardStepOrder");
            LinkedList cardList = (LinkedList)propVal.getValue();
            for (Step step : cardList) {
                if (!clazz.getClass().getName().equals(step.getCardClassName())) continue;
                step.setCardClazz(clazz);
                break;
            }
            ContextUtil.saveSimpleValue2Ctx("lego.base.cardStepOrder", cardList);
        }

        protected abstract boolean isValid(Navigation var1);

        protected abstract void process(Navigation var1);

        protected WizardDialog getWizardDialog() {
            return this.container;
        }

        private void initContainer() {
            if (this.container == null) {
                ContextPropVal propVal = this.installConext.getPropertyMap().getProp("lego.base.wizarddlg");
                this.container = (WizardDialog)propVal.getValue();
            }
        }

        public WizardDialog getContainer() {
            if (this.container == null) {
                this.initContainer();
            }
            return this.container;
        }

        public void setContainer(WizardDialog container) {
            this.container = container;
        }

        public Map<Navigation, JButton> getNavigationButtons() {
            return this.navigationButtons;
        }

        public void setNavigationButtons(Map<Navigation, JButton> navigationButtons) {
            this.navigationButtons = navigationButtons;
        }

        protected void setNavigationButtonsStatus(boolean enabled, Navigation ... btns) {
            if (null == btns || btns.length == 0) {
                return;
            }
            JButton button = null;
            for (Navigation btn : btns) {
                if (btn.equals((Object)Navigation.Previous)) {
                    button = this.getNavigationButtons().get((Object)Navigation.Previous);
                } else if (btn.equals((Object)Navigation.Next)) {
                    button = this.getNavigationButtons().get((Object)Navigation.Next);
                } else if (btn.equals((Object)Navigation.Complete)) {
                    button = this.getNavigationButtons().get((Object)Navigation.Complete);
                } else if (btn.equals((Object)Navigation.Cancel)) {
                    button = this.getNavigationButtons().get((Object)Navigation.Cancel);
                }
                if (null == button) continue;
                button.setEnabled(enabled);
            }
        }
    }

    public static enum Navigation {
        Previous('P'),
        Next('N'),
        Complete('O'),
        Cancel('C');

        private char mnemonic;

        private Navigation(char mnemonicParam) {
            this.mnemonic = mnemonicParam;
        }

        public String toString() {
            String prefix = "COMMON.TXT.";
            return ResourceManager.getString(prefix + this.name().toUpperCase(Locale.ENGLISH), this.name());
        }
    }
}

