/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.base.tools;

import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.ResourceManager;
import com.huawei.elog.util.SetProcessThread;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrawProgressBar
extends JWindow {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DrawProgressBar.class);
    private static String softName = ContextUtil.getStrValueFromCtx("software.install.name");
    private static DrawProgressBar sInstance = null;
    private JProgressBar progressBar;
    private JLabel jl1 = null;

    public DrawProgressBar() {
        try {
            this.setSize(400, 85);
            this.setEnabled(true);
            this.setAlwaysOnTop(true);
            int windowWidth = this.getWidth();
            int windowHeight = this.getHeight();
            Toolkit kit = Toolkit.getDefaultToolkit();
            Dimension screenSize = kit.getScreenSize();
            int screenWidth = screenSize.width;
            int screenHeight = screenSize.height;
            this.setLocation(screenWidth / 2 - windowWidth / 2, screenHeight / 2 - windowHeight / 2);
            this.setLayout(null);
            ImageIcon img = ResourceManager.getIcon("loading-balls");
            this.jl1 = new JLabel(ResourceManager.getString("VSM.CHANGE.IP.TOOLS", softName));
            this.jl1.setBounds(10, 10, 380, 30);
            this.jl1.setIcon(img);
            this.add(this.jl1);
            this.progressBar = new JProgressBar(1, 100);
            this.progressBar.setBounds(10, 45, 380, 30);
            this.progressBar.setStringPainted(true);
            this.progressBar.setValue(0);
            this.progressBar.setStringPainted(true);
            this.add(this.progressBar);
            this.setVisible(true);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("init ui occurs error.", (Throwable)e);
        }
    }

    public static synchronized DrawProgressBar getInstance() {
        if (null == sInstance) {
            sInstance = new DrawProgressBar();
        }
        return sInstance;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setProgressBar(JProgressBar progressBar) {
        this.progressBar = progressBar;
    }

    public static void dealWithProcess() throws InterruptedException {
        SetProcessThread.getInstance().setFinished(true);
        while (!SetProcessThread.getInstance().isFeedBack()) {
            Thread.sleep(500L);
        }
        DrawProgressBar.getInstance().getProgressBar().setValue(100);
    }
}

