/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.base.tools;

import com.huawei.elog.base.InstallContext;
import com.huawei.elog.util.ContextUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class PortHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(PortHelper.class);
    private static PortHelper instance = null;
    private static Map<String, List<String>> integratePortMap = null;
    private static Map<String, List<String>> independentPortMap = null;
    private static Map<String, List<String>> collectorPortMap = null;
    private static final String SCENE_INTEGRATE = "integrate";
    private static final String SCENE_INDEPENDENT = "server";
    private static final String SCENE_COLLECTOR = "collector";

    private PortHelper() {
        this.setIntegratePortMap(new LinkedHashMap<String, List<String>>());
        this.setIndependentPortMap(new LinkedHashMap<String, List<String>>());
        this.setCollectorPortMap(new LinkedHashMap<String, List<String>>());
        PortHelper.loadPortCfgFile();
    }

    public static PortHelper getInstance() {
        if (null == instance) {
            instance = new PortHelper();
        }
        return instance;
    }

    public static void loadPortCfgFile() {
        boolean isInstalled = false;
        String installPath = ContextUtil.getStrValueFromCtx("lego.base.installpath");
        String installSoftWare = ContextUtil.getStrValueFromCtx("software.install.name");
        if (null != installPath) {
            isInstalled = true;
        } else {
            installPath = InstallContext.getInstance().getEnvirments().getBasePath();
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            List<String> portList;
            String protocol;
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", false);
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            dbf.setExpandEntityReferences(false);
            dbf.setIgnoringComments(true);
            dbf.setValidating(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = null;
            doc = isInstalled ? (installSoftWare.contains("Collector") ? db.parse(installPath + "/antiddos_collector/uninstall/etc/config/conf/checkPort.xml") : db.parse(installPath + "/Runtime/bin/etc/config/conf/checkPort.xml")) : db.parse(installPath + "/etc/config/conf/checkPort.xml");
            Element root = doc.getDocumentElement();
            NodeList versions = root.getElementsByTagName("version");
            int versionSize = versions.getLength();
            Element portDetail = null;
            String versionName = null;
            for (int i = 0; i < versionSize; ++i) {
                portDetail = (Element)versions.item(i);
                versionName = portDetail.getAttribute("name");
                NodeList nPort = portDetail.getElementsByTagName("port");
                for (int j = 0; j < nPort.getLength(); ++j) {
                    Element port = (Element)nPort.item(j);
                    String protocol2 = port.getAttribute("id");
                    String strPortValue = port.getTextContent();
                    String[] smPort = strPortValue.split(";");
                    List<String> portList2 = Arrays.asList(smPort);
                    LOGGER.debug("versionName: " + versionName, (Object)"loadPortCfgFile");
                    LOGGER.debug("protocol: " + protocol2, (Object)"loadPortCfgFile");
                    LOGGER.debug("ports: " + portList2, (Object)"loadPortCfgFile");
                    if (SCENE_INTEGRATE.equals(versionName)) {
                        integratePortMap.put(protocol2, portList2);
                        continue;
                    }
                    if (SCENE_INDEPENDENT.equals(versionName)) {
                        independentPortMap.put(protocol2, portList2);
                        continue;
                    }
                    if (SCENE_COLLECTOR.equals(versionName)) {
                        collectorPortMap.put(protocol2, portList2);
                        continue;
                    }
                    LOGGER.debug("unknown scene : " + versionName, (Object)"loadPortCfgFile");
                }
            }
            String collectorInstalled = ContextUtil.getStrValueFromCtx("collector.install.is.or.not");
            if ("true".equalsIgnoreCase(collectorInstalled)) {
                LOGGER.debug("collectorInstalled : " + collectorInstalled);
                independentPortMap = PortHelper.combineMap(independentPortMap, collectorPortMap);
            }
            for (Map.Entry<String, List<String>> entry : integratePortMap.entrySet()) {
                protocol = entry.getKey();
                portList = entry.getValue();
                LOGGER.debug("Portocol: " + protocol + ", List: " + portList, (Object)"test");
            }
            for (Map.Entry<String, List<String>> entry : independentPortMap.entrySet()) {
                protocol = entry.getKey();
                portList = entry.getValue();
                LOGGER.debug("Portocol: " + protocol + ", List: " + portList, (Object)"test");
            }
            for (Map.Entry<String, List<String>> entry : collectorPortMap.entrySet()) {
                protocol = entry.getKey();
                portList = entry.getValue();
                LOGGER.debug("Portocol: " + protocol + ", List: " + portList, (Object)"test");
            }
        }
        catch (SAXException e) {
            LOGGER.error("checkPortUsed", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("checkPortUsed", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("checkPortUsed", (Throwable)e);
        }
    }

    public Map<String, List<String>> getPortMap(String scene) {
        if (SCENE_INTEGRATE.equals(scene)) {
            return integratePortMap;
        }
        if (SCENE_INDEPENDENT.equals(scene)) {
            return independentPortMap;
        }
        if (SCENE_COLLECTOR.equals(scene)) {
            return collectorPortMap;
        }
        return new LinkedHashMap<String, List<String>>();
    }

    public static Map<String, List<String>> combineMap(Map<String, List<String>> map1, Map<String, List<String>> map2) {
        Iterator<Map.Entry<String, List<String>>> it1 = map1.entrySet().iterator();
        Iterator<Map.Entry<String, List<String>>> it2 = map2.entrySet().iterator();
        while (it1.hasNext() && it2.hasNext()) {
            Map.Entry<String, List<String>> entry1 = it1.next();
            Map.Entry<String, List<String>> entry2 = it2.next();
            String protocol = entry1.getKey();
            ArrayList<String> portList = new ArrayList<String>();
            List<String> portList1 = entry1.getValue();
            List<String> portList2 = entry2.getValue();
            portList.addAll(portList1);
            portList.addAll(portList2);
            map1.put(protocol, portList);
            LOGGER.debug("Portocol: " + protocol + ", List: " + portList1, (Object)"test");
        }
        return map1;
    }

    public void setCollectorPortMap(Map<String, List<String>> collectorPortMap) {
        PortHelper.setCollectorPortMapValue(collectorPortMap);
    }

    public static void setCollectorPortMapValue(Map<String, List<String>> collectorPortMapTemp) {
        collectorPortMap = collectorPortMapTemp;
    }

    public void setIndependentPortMap(Map<String, List<String>> independentPortMap) {
        PortHelper.setIndependentPortMapValue(independentPortMap);
    }

    public static void setIndependentPortMapValue(Map<String, List<String>> independentPortMapTemp) {
        independentPortMap = independentPortMapTemp;
    }

    public void setIntegratePortMap(Map<String, List<String>> integratePortMap) {
        PortHelper.setIntegratePortMapValue(integratePortMap);
    }

    public static void setIntegratePortMapValue(Map<String, List<String>> integratePortMapTemp) {
        integratePortMap = integratePortMapTemp;
    }
}

