/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.base.tools;

import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.tools.StartInstallWindowsThread;
import com.huawei.elog.util.PropertyManager;
import com.huawei.elog.util.ResourceManager;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StartInstallWindow
extends JWindow {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(StartInstallWindow.class);
    private static StartInstallWindow instance = null;
    private JLabel jl1 = null;
    private JProgressBar progressBar;

    private StartInstallWindow() {
        this.addItem();
    }

    public static StartInstallWindow getInstance() {
        if (null == instance) {
            instance = new StartInstallWindow();
        }
        return instance;
    }

    private void addItem() {
        try {
            this.setSize(400, 85);
            this.setEnabled(true);
            this.setAlwaysOnTop(true);
            int windowWidth = this.getWidth();
            int windowHeight = this.getHeight();
            Toolkit kit = Toolkit.getDefaultToolkit();
            Dimension screenSize = kit.getScreenSize();
            int screenWidth = screenSize.width;
            int screenHeight = screenSize.height;
            this.setLocation(screenWidth / 2 - windowWidth / 2, screenHeight / 2 - windowHeight / 2);
            this.setLayout(null);
            ImageIcon img = ResourceManager.getIcon("loading-balls");
            this.jl1 = InstallContext.getInstance().getInstallMode().equalsIgnoreCase("install") ? (InstallContext.getInstance().getInstallType().contains("Collector") ? new JLabel(ResourceManager.getString("LEGO.INSTALL.INIT", "Collector")) : new JLabel(ResourceManager.getString("LEGO.INSTALL.INIT", PropertyManager.getProValue("software.install.name")))) : (InstallContext.getInstance().getInstallMode().equalsIgnoreCase("update") ? (InstallContext.getInstance().getInstallType().contains("Collector") ? new JLabel(ResourceManager.getString("LEGO.UPDATE.INIT", "Collector")) : new JLabel(ResourceManager.getString("LEGO.UPDATE.INIT", PropertyManager.getProValue("software.install.name")))) : (InstallContext.getInstance().getInstallMode().equalsIgnoreCase("uninstall") ? (InstallContext.getInstance().getInstallType().contains("Collector") ? new JLabel(ResourceManager.getString("LEGO.UNINSTALL.INIT", "Collector")) : new JLabel(ResourceManager.getString("LEGO.UNINSTALL.INIT", PropertyManager.getProValue("software.install.name")))) : new JLabel(ResourceManager.getString("LEGO.PATCH.INIT", PropertyManager.getProValue("software.install.name")))));
            this.jl1.setBounds(10, 10, 380, 30);
            this.jl1.setIcon(img);
            this.add(this.jl1);
            this.progressBar = new JProgressBar(1, 100);
            this.progressBar.setBounds(10, 45, 380, 30);
            this.progressBar.setStringPainted(true);
            this.progressBar.setValue(0);
            this.progressBar.setStringPainted(true);
            this.add(this.progressBar);
            this.setVisible(true);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("init ui occurs error.", (Throwable)e);
        }
    }

    public void dealWithProcess() throws InterruptedException {
        StartInstallWindowsThread.getInstance().setFinished(true);
        while (!StartInstallWindowsThread.getInstance().isFeedBack()) {
            Thread.sleep(500L);
        }
        StartInstallWindow.getInstance().getProgressBar().setValue(100);
    }

    public JLabel getJl1() {
        return this.jl1;
    }

    public void setJl1(JLabel jl1) {
        this.jl1 = jl1;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setProgressBar(JProgressBar progressBar) {
        this.progressBar = progressBar;
    }

    public static void setInstance(StartInstallWindow instance) {
        StartInstallWindow.instance = instance;
    }
}

