/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.base.tools;

import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.model.CpuMemoryInfo;
import com.huawei.elog.base.sdk.IInstallContext;
import com.huawei.elog.util.MonitorCpuInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsSystemTool {
    private static final String CPU_USE_PERCENT = "CPU";
    private static final String MEM_TOTALMEM = "TOTALMEM";
    private static final String MEM_AVAILMEM = "AVAILMEM";
    private static final double LHUNDRED = 100.0;
    private static final int MAX_COUNT = 0x100000;
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowsSystemTool.class);
    private static IInstallContext installConext = InstallContext.getInstance();
    private MonitorCpuInfo monitorCpuInfo = new MonitorCpuInfo();
    private CpuMemoryInfo cpuMemoryInfo = this.monitorCpuInfo.getMonitorInfoBean();
    private String cmd = "";

    public WindowsSystemTool() {
        String currentPath = installConext.getEnvirments().getBasePath();
        this.cmd = currentPath + File.separator + "Runtime" + File.separator + "LegoRuntime" + File.separator + "tools" + File.separator + "Resource.exe ";
    }

    public int getCpuInfo() {
        long percent = 0L;
        try {
            percent = this.getCPUAndMenInfo(CPU_USE_PERCENT);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return (int)(this.cpuMemoryInfo.getCpuRatio() != 0.0 ? (double)percent : this.cpuMemoryInfo.getCpuRatio());
    }

    public int getPercentMemInfo() {
        long total = this.getTotalMemInfo();
        long avail = this.getAvailMemInfo();
        long use = total - avail;
        double percent = (double)use * 100.0 / (double)total;
        return (int)percent;
    }

    public long getAvailMemInfo() {
        return this.cpuMemoryInfo.getFreePhysicalMemorySize() != 0L ? this.cpuMemoryInfo.getFreePhysicalMemorySize() : this.getCPUAndMenInfo(MEM_AVAILMEM);
    }

    public long getTotalMemInfo() {
        return this.cpuMemoryInfo.getTotalMemorySize() != 0L ? this.cpuMemoryInfo.getTotalMemorySize() : this.getCPUAndMenInfo(MEM_TOTALMEM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long getCPUAndMenInfo(String para) {
        para = this.cmd + para;
        Process pp = null;
        long returnVaule = 1L;
        LineNumberReader input = null;
        LineNumberReader inputError = null;
        try {
            pp = Runtime.getRuntime().exec(para);
            input = new LineNumberReader(new InputStreamReader(pp.getInputStream(), "utf-8"));
            String nextStr = input.readLine();
            if (nextStr != null) {
                returnVaule = Long.parseLong(nextStr);
            }
            inputError = new LineNumberReader(new InputStreamReader(pp.getErrorStream(), "utf-8"));
            StringBuffer errorBuffer = new StringBuffer();
            while (inputError.read() != -1 && errorBuffer.length() <= 0x100000) {
                String line = inputError.readLine();
                errorBuffer.append(line);
            }
            if (errorBuffer.length() > 0) {
                LOGGER.error("errorBuffer content is:" + errorBuffer.toString());
            }
            this.closeStream(input);
            this.closeStream(inputError);
            if (null != pp) {
                pp.destroy();
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
        }
        finally {
            this.closeStream(input);
            this.closeStream(inputError);
            if (null != pp) {
                pp.destroy();
            }
        }
        return returnVaule;
    }

    private void closeStream(LineNumberReader input) {
        if (null != input) {
            try {
                input.close();
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage());
            }
        }
    }
}

