/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.check;

import com.huawei.elog.check.BasicChecker;
import com.huawei.elog.check.common.EntCheckUtil;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.FileUtil;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryIsUsingChecker
extends BasicChecker {
    private static final long serialVersionUID = -1265687137903618007L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectoryIsUsingChecker.class);

    @Override
    public int check() {
        if (this.isUsing()) {
            this.result = 0;
            String installPath = ContextUtil.getStrValueFromCtx("lego.base.installpath");
            this.setDetail(EntCheckUtil.getValue("EnvCheck.DirectoryIsUsing.result", installPath));
        } else {
            this.result = 1;
        }
        return this.result;
    }

    private boolean isUsing() {
        long time = System.nanoTime();
        String installPath = ContextUtil.getStrValueFromCtx("lego.base.installpath");
        if (StringUtils.isEmpty((CharSequence)installPath)) {
            return false;
        }
        File file = new File(installPath = FileUtil.parseSeparator4Linux(installPath));
        if (!file.exists()) {
            return false;
        }
        String installPathBak = installPath + "_" + time;
        File dest = new File(installPathBak);
        boolean result = FileUtil.fileRename(file, dest);
        if (result) {
            boolean c = FileUtil.fileRename(dest, file);
            if (!c) {
                LOGGER.error("After successful renaming, failure again renamed.");
            }
        } else {
            LOGGER.error("Rename failed, cannot continue with the upgrade");
        }
        return !result;
    }
}

