/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.check;

import com.huawei.elog.check.BasicChecker;
import com.huawei.elog.check.common.EntCheckUtil;
import com.huawei.elog.check.ui.IColorReader;
import com.huawei.elog.ui.panel.IConclusionInfo;
import com.huawei.elog.util.ArraysClone;
import com.huawei.elog.util.JarFileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EnvCheckerContainer
extends AbstractTableModel
implements IColorReader,
IConclusionInfo {
    private static final long serialVersionUID = 726330771839025389L;
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvCheckerContainer.class);
    private static EnvCheckerContainer instance = new EnvCheckerContainer();
    private List<BasicChecker> checkers = new ArrayList<BasicChecker>();
    private List<Object[]> checkErrors = new ArrayList<Object[]>();
    private int errorNum = 0;
    private int warningNum = 0;
    private String[] columns;
    private boolean isCheck = true;

    private EnvCheckerContainer() {
    }

    public static EnvCheckerContainer getInstance() {
        return instance;
    }

    public void init() {
        if (this.checkers.isEmpty()) {
            this.readXMLFile();
        }
    }

    public int doCheck() {
        this.errorNum = 0;
        this.warningNum = 0;
        this.checkErrors.clear();
        if (!this.isCheck) {
            return this.errorNum;
        }
        LOGGER.debug("------------   checker  start ---------------");
        for (BasicChecker checker : this.checkers) {
            int checkResult = 1;
            try {
                checkResult = checker.check();
            }
            catch (Exception e) {
                LOGGER.info(checker.getClass() + " excute error.", (Throwable)e);
                continue;
            }
            if (checker.isVersionChecker()) continue;
            switch (checkResult) {
                case 0: {
                    ++this.errorNum;
                    this.checkErrors.add(new Object[]{checker, checker.getName(), checker.getDetail(), checker.getRepairString(), checker.getCondition(), checker.getCheckID()});
                    break;
                }
                case 2: {
                    ++this.warningNum;
                    this.checkErrors.add(new Object[]{checker, checker.getName(), checker.getDetail(), checker.getRepairString(), checker.getCondition(), checker.getCheckID()});
                    break;
                }
            }
        }
        LOGGER.debug("------------   checker  end ---------------");
        this.formatErrors();
        return this.errorNum;
    }

    private void formatErrors() {
        ArrayList<Object[]> errorList = new ArrayList<Object[]>();
        ArrayList<Object[]> warnList = new ArrayList<Object[]>();
        for (Object[] o : this.checkErrors) {
            BasicChecker e = (BasicChecker)o[0];
            int level = e.getResult();
            if (0 == level) {
                errorList.add(o);
                continue;
            }
            warnList.add(o);
        }
        this.checkErrors = errorList;
        this.checkErrors.addAll(warnList);
    }

    @Override
    public int getWarningNum() {
        return this.warningNum;
    }

    @Override
    public int getErrorNum() {
        return this.errorNum;
    }

    @Override
    public int getColumnCount() {
        if (null == this.columns) {
            return 0;
        }
        return this.columns.length;
    }

    @Override
    public int getRowCount() {
        return this.errorNum + this.warningNum;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.checkErrors.size() || columnIndex >= this.columns.length) {
            return null;
        }
        return this.checkErrors.get(rowIndex)[columnIndex + 1];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == this.columns.length - 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columns[columnIndex];
    }

    public void setColumnNames(String[] columnsParams) {
        this.columns = (String[])ArraysClone.deepClone(columnsParams);
    }

    @Override
    public String getColor(int index) {
        int result = ((BasicChecker)this.checkErrors.get(index)[0]).getResult();
        if (result == 0) {
            return "R";
        }
        if (result == 2) {
            return "Y";
        }
        return "Z";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readXMLFile() {
        SAXReader builder = new SAXReader();
        Document doc = null;
        Element root = null;
        FileInputStream fis = null;
        String xmlFilePath = JarFileUtil.getProjectPath(this.getClass()) + "/etc/config/CheckerList.xml";
        File xmlFile = new File(xmlFilePath);
        if (!xmlFile.exists()) {
            LOGGER.error("CheckerList.xml does not exist.");
        }
        try {
            fis = new FileInputStream(xmlFilePath);
            doc = builder.read((InputStream)fis);
            root = doc.getRootElement();
            this.isCheck = "true".equalsIgnoreCase(root.attributeValue("ischeck"));
            Iterator checklist = root.elementIterator("checker");
            while (checklist.hasNext()) {
                Element element = (Element)checklist.next();
                String classname = element.elementText("classname");
                BasicChecker checker = null;
                if (classname != null && !classname.isEmpty()) {
                    try {
                        checker = (BasicChecker)Class.forName(classname).newInstance();
                    }
                    catch (Exception e) {
                        LOGGER.error(classname + " newInstance() failed" + e);
                    }
                }
                if (checker == null) {
                    break;
                }
                checker.setCheckID(element.elementText("name"));
                checker.setName(EntCheckUtil.getValue(element.elementText("name")));
                checker.setCondition(EntCheckUtil.getValue(element.elementText("suggest")));
                checker.setRepairString(EntCheckUtil.getValue(element.elementText("repairString")));
                checker.setHelp(element.elementText("help"));
                checker.setRepairable("true".equals(element.elementText("repairable")));
                if (this.checkers.contains(checker)) continue;
                this.checkers.add(checker);
            }
        }
        catch (IOException e) {
            LOGGER.error("read CheckerList.xml failed, reason is ", (Throwable)e);
        }
        catch (DocumentException e) {
            LOGGER.error("read CheckerList.xml failed, reason is ", (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    LOGGER.error("read CheckerList.xml failed, reason is ", (Throwable)e);
                }
            }
        }
    }
}

