/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.check;

import com.huawei.elog.base.tools.WindowsSystemTool;
import com.huawei.elog.check.BasicChecker;
import com.huawei.elog.util.PropertyManager;
import java.text.MessageFormat;

public class OSAvailableMemoryChecker
extends BasicChecker {
    private static final long serialVersionUID = 4221195151857985419L;
    private static final String WANT_RAM_SIZE_STRING = PropertyManager.getProValue("lego.install.available.memory.required");
    private static final int WANT_RAM_SIZE_INT_DEFAULT = 2048;

    @Override
    public int check() {
        int wantRamSizeInt = null == WANT_RAM_SIZE_STRING ? 2048 : Integer.parseInt(WANT_RAM_SIZE_STRING);
        long availableMem = this.getAvailableMemory();
        if (availableMem < (long)wantRamSizeInt) {
            this.result = 0;
            this.setDetail(availableMem + "M");
            this.setCondition(MessageFormat.format(this.getCondition(), wantRamSizeInt + "M"));
        } else {
            this.result = 1;
        }
        return this.result;
    }

    public long getAvailableMemory() {
        WindowsSystemTool wst = new WindowsSystemTool();
        return wst.getAvailMemInfo() / 1024L;
    }
}

