/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.check;

import com.huawei.elog.base.tools.WindowsSystemTool;
import com.huawei.elog.check.BasicChecker;
import com.huawei.elog.util.PropertyManager;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSTotalMemoryChecker
extends BasicChecker {
    private static final long serialVersionUID = 3224766096850004120L;
    private static final Logger LOGGER = LoggerFactory.getLogger(OSTotalMemoryChecker.class);
    private static final String WANT_RAM_SIZE_STRING = PropertyManager.getProValue("lego.install.total.memory.required");
    private static final int WANT_RAM_SIZE_INT_DEFAULT = 4096;

    @Override
    public int check() {
        int wantRamSizeInt = null == WANT_RAM_SIZE_STRING ? 4096 : Integer.parseInt(WANT_RAM_SIZE_STRING);
        long totalMem = this.getTotalMemory();
        LOGGER.debug("totalMem:{}, wantRamSizeInt:{}", (Object)totalMem, (Object)wantRamSizeInt);
        if (totalMem < (long)wantRamSizeInt) {
            this.result = 0;
            this.setDetail(totalMem + "M");
            this.setCondition(MessageFormat.format(this.getCondition(), wantRamSizeInt + "M"));
        } else {
            this.result = 1;
        }
        return this.result;
    }

    public long getTotalMemory() {
        WindowsSystemTool wst = new WindowsSystemTool();
        return wst.getTotalMemInfo() / 1024L;
    }
}

