/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.check;

import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.model.Program;
import com.huawei.elog.check.BasicChecker;
import com.huawei.elog.check.common.EntCheckUtil;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.OSUtil;
import com.huawei.elog.util.ProgramUtil;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortChecker
extends BasicChecker {
    private static final long serialVersionUID = 7573003523534957610L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PortChecker.class);

    @Override
    public int check() {
        this.result = 1;
        if (OSUtil.isWindows()) {
            List<Program> lPro = null;
            if (CommonUtil.isIntegratedScene() || "fuseWithEsight".equals(ContextUtil.getStrValueFromCtx("lego.base.fuseWithEsight"))) {
                lPro = ProgramUtil.getProgramListTakePortIllegally("integrate", false);
            } else if ("legoPlat".equals(InstallContext.getInstance().getInstallType())) {
                lPro = ProgramUtil.getProgramListTakePortIllegally("server", false);
                lPro.addAll(ProgramUtil.getProgramListTakePortIllegally("collector", false));
            } else {
                lPro = ProgramUtil.getProgramListTakePortIllegally("collector", false);
            }
            if (!lPro.isEmpty()) {
                Iterator<Program> it = lPro.iterator();
                StringBuffer pList = new StringBuffer();
                while (it.hasNext()) {
                    Program pIt = it.next();
                    List<Integer> iPort = pIt.getPorts();
                    pList.append(iPort.get(0));
                    pList.append(',');
                }
                if (pList.length() == 0) {
                    this.result = 1;
                } else {
                    String errMsg = EntCheckUtil.getValue("EnvCheck.Port.Occupied") + pList.substring(0, pList.length() - 1);
                    LOGGER.error(errMsg);
                    super.setDetail(errMsg);
                    this.result = 0;
                }
            }
        }
        return this.result;
    }
}

