/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ui;

import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.model.ContextPropVal;
import com.huawei.elog.base.model.WizardDialog;
import com.huawei.elog.ui.OptionPaneUI;
import com.huawei.elog.ui.dialog.ShowDetailDialog;
import com.huawei.elog.ui.window.WindowHolder;
import com.huawei.elog.util.ResourceManager;
import com.huawei.elog.util.UIUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OptionPane {
    public static final String STRING_YES = ResourceManager.getString("OptionPane.yes");
    public static final String STRING_NO = ResourceManager.getString("OptionPane.no");
    public static final String STRING_ALLYES = ResourceManager.getString("OptionPane.AllYes");
    public static final String STRING_ALLNO = ResourceManager.getString("OptionPane.AllNo");
    public static final String STRING_CANCEL = ResourceManager.getString("OptionPane.cancel");
    public static final String STRING_OK = ResourceManager.getString("OptionPane.ok");
    public static final String STRING_INFO = ResourceManager.getString("OptionPane.info");
    public static final String STRING_WARN = ResourceManager.getString("OptionPane.warn");
    public static final String STRING_ERROR = ResourceManager.getString("OptionPane.error");
    public static final String STRING_PROMPT = ResourceManager.getString("OptionPane.prompt");
    public static final String STRING_CONFIRMATION = ResourceManager.getString("OptionPane.Confirmation");
    public static final String STRING_SHOWDETAIL = ResourceManager.getString("OptionPane.ShowDetail");
    public static final String STRING_EXIT = ResourceManager.getString("OptionPane.Exit");
    public static final String STRING_CONTINUE = ResourceManager.getString("OptionPane.Continue");
    public static final String STRING_DETAIL = ResourceManager.getString("OptionPane.Detail");
    public static final String STRING_RETRY = ResourceManager.getString("OptionPane.Retry");
    public static final String STRING_IGNORE = ResourceManager.getString("OptionPane.Ignore");
    public static final int OK_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int YES_OPTION = 0;
    public static final int ALLYES_OPTION = 2;
    public static final int ALLNO_OPTION = 3;
    public static final int ESCAPE_OPTION = 4;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int YES_NO_OPTION = 0;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int DEFAULT_OPTION = -1;
    public static final int YES_NO_ALLYES_ALLNO_OPTION = 11;
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;
    public static final int PLAIN_MESSAGE = -1;
    private static final Logger LOGGER = LoggerFactory.getLogger(OptionPane.class);
    private static JDialog owner = null;
    private static boolean isShowDoCostTimeWorkDlg = false;

    public static void showDoCostTimeWorkDlgBegin(JDialog parent) {
        owner = parent;
        isShowDoCostTimeWorkDlg = true;
    }

    public static void showDoCostTimeWorkDlgEnd() {
        isShowDoCostTimeWorkDlg = false;
    }

    public static void showInfoDialog(String message) {
        OptionPane.showInfoDialog(message, null);
    }

    public static void showWarnDialog(String message) {
        OptionPane.showWarnDialog(message, null);
    }

    public static void errMsg(String message) {
        OptionPane.showErrorDialog(message, null);
    }

    public static void showInfoDialog(String message, String title) {
        if (title == null) {
            title = ResourceManager.getString("OptionPane.info");
        }
        OptionPane.showMessageDialog(null, message, title, 1);
    }

    public static void showMessageDialog(Component parentComponent, String message, String title, int msgType) {
        if (UIUtil.isSilentMode()) {
            LOGGER.debug("Slient mode of install,  gui dialog is hide.", (Object)"showMessageDialog");
            return;
        }
        Object[] options = new Object[]{STRING_OK};
        OptionPaneUI ui = null;
        if (isShowDoCostTimeWorkDlg) {
            ui = OptionPaneUI.createOptionPaneUI(owner, message, title, msgType, null, options, options[0], null);
        } else {
            if (null == parentComponent) {
                parentComponent = WindowHolder.getInstance().getActiveWindow();
            }
            ui = OptionPaneUI.createOptionPaneUI(parentComponent, message, title, msgType, null, options, options[0], null);
        }
        if (!OptionPaneUI.isToHandleEscAndCls()) {
            ui.setDefaultCloseOperation(0);
            ui.validate();
        }
        ui.setVisible(true);
    }

    public static void showWarnDialog(String message, String title) {
        if (title == null) {
            title = ResourceManager.getString("OptionPane.warn");
        }
        OptionPane.showMessageDialog(null, message, title, 0);
    }

    public static void showErrorDialog(String message) {
        OptionPane.showErrorDialog(message, null);
    }

    public static void showErrorDialog(String message, String title) {
        if (title == null) {
            title = ResourceManager.getString("OptionPane.error");
        }
        OptionPane.showMessageDialog(null, message, title, 0);
    }

    public static void showErrorDialog(Component c, String message, String title) {
        if (title == null) {
            title = ResourceManager.getString("OptionPane.error");
        }
        isShowDoCostTimeWorkDlg = false;
        OptionPane.showMessageDialog(c, message, title, 0);
    }

    public static int showInfoConfirmDialog(String message) {
        return OptionPane.showInfoConfirmDialog(message, null);
    }

    public static int showWarnConfirmDialog(String message) {
        return OptionPane.showWarnConfirmDialog(message, null);
    }

    public static int showWarnConfirmDialog(Component parentComponent, String message) {
        return OptionPane.showConfirmDialog(parentComponent, message, ResourceManager.getString("OptionPane.warn"), 0, 2);
    }

    public static int showErrorConfirmDialog(String message) {
        return OptionPane.showErrorConfirmDialog(message, null);
    }

    public static int showInfoConfirmDialog(String message, String title) {
        return OptionPane.showInfoConfirmDialog(message, title, 0);
    }

    public static int showWarnConfirmDialog(String message, String title) {
        return OptionPane.showWarnConfirmDialog(message, title, 0);
    }

    public static int showErrorConfirmDialog(String message, String title) {
        return OptionPane.showErrorConfirmDialog(message, title, 1);
    }

    public static int showInfoConfirmDialog(String message, String title, int optionType) {
        if (title == null) {
            title = ResourceManager.getString("OptionPane.prompt");
        }
        return OptionPane.showConfirmDialog(null, message, title, optionType, 3);
    }

    public static int showWarnConfirmDialog(String message, String title, int optionType) {
        if (title == null) {
            title = ResourceManager.getString("OptionPane.warn");
        }
        return OptionPane.showConfirmDialog(null, message, title, optionType, 2);
    }

    public static int showErrorConfirmDialog(String message, String title, int optionType) {
        if (title == null) {
            title = ResourceManager.getString("OptionPane.error");
        }
        return OptionPane.showConfirmDialog(null, message, title, optionType, 0);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType) {
        LOGGER.debug("showConfirmDialog.message :" + message, (Object)"showConfirmDialog");
        if (UIUtil.isSilentMode()) {
            LOGGER.debug("Slient mode of install,  gui dialog is hide.", (Object)"showMessageDialog");
            return 1;
        }
        Object[] options = null;
        char[] mnemonicKeys = null;
        switch (optionType) {
            case -1: {
                options = new Object[]{STRING_OK};
                break;
            }
            case 2: {
                options = new Object[]{STRING_OK, STRING_CANCEL};
                break;
            }
            case 0: {
                options = new Object[]{STRING_YES, STRING_NO};
                mnemonicKeys = new char[]{'Y', 'N'};
                break;
            }
            case 1: {
                options = new Object[]{STRING_YES, STRING_NO, STRING_CANCEL};
                mnemonicKeys = new char[]{'Y', 'N'};
                break;
            }
            case 11: {
                options = new Object[]{STRING_YES, STRING_NO, STRING_ALLYES, STRING_ALLNO};
                mnemonicKeys = new char[]{'Y', 'N', 'A', 'O'};
                break;
            }
            default: {
                options = new Object[]{STRING_OK, STRING_CANCEL};
                LOGGER.debug("Wrong optionType set. Must be one of DEFAULT_OPTION // OK_CANCEL_OPTION // YES_NO_OPTION // YES_NO_CANCEL_OPTION.", (Object)"showConfirmDialog");
            }
        }
        StringBuffer optionstr = new StringBuffer(10);
        for (int i = 0; i < options.length; ++i) {
            optionstr.append(i + ":");
            optionstr.append(options[i] + " ");
        }
        OptionPaneUI ui = null;
        ui = isShowDoCostTimeWorkDlg ? OptionPaneUI.createOptionPaneUI(owner, message.toString(), title, messageType, null, options, options[0], mnemonicKeys) : OptionPaneUI.createOptionPaneUI(parentComponent, message.toString(), title, messageType, null, options, options[0], mnemonicKeys);
        if (!OptionPaneUI.isToHandleEscAndCls()) {
            ui.setDefaultCloseOperation(0);
            ui.validate();
        }
        ui.setVisible(true);
        int retValue = ui.getValue();
        return retValue;
    }

    public static int showOptionDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue, char[] mnemonicKeys) {
        title = OptionPane.checkTitle(title);
        message = OptionPane.checkMessage(message);
        options = OptionPane.checkOptions(options);
        LOGGER.debug("showOptionDialog.message :" + message, (Object)"showOptionDialog");
        StringBuffer optionstr = new StringBuffer(10);
        for (int i = 0; i < options.length; ++i) {
            optionstr.append(i + ":");
            optionstr.append(options[i] + " ");
        }
        LOGGER.debug("showOptionDialog.options :" + optionstr.toString(), (Object)"showOptionDialog");
        int sel = -1;
        if (optionType == 11) {
            optionType = 0;
        }
        OptionPaneUI ui = null;
        LOGGER.debug("isShowDoCostTimeWorkDlg :" + isShowDoCostTimeWorkDlg, (Object)"showOptionDialog");
        ui = isShowDoCostTimeWorkDlg ? OptionPaneUI.createOptionPaneUI(owner, message.toString(), title, messageType, null, options, initialValue, mnemonicKeys) : OptionPaneUI.createOptionPaneUI(parentComponent, message.toString(), title, messageType, null, options, initialValue, mnemonicKeys);
        if (!OptionPaneUI.isToHandleEscAndCls()) {
            ui.setDefaultCloseOperation(0);
            ui.validate();
        }
        ui.setVisible(true);
        sel = ui.getValue();
        return sel;
    }

    public static void showDetailDialog(String dialogTitle, String message, String msgDetail, int messageType, boolean isShowTwoBtn, String btnOneText, String btnTwoText, char[] keys) {
        ShowDetailDialog dialog = null;
        if (isShowDoCostTimeWorkDlg) {
            dialog = new ShowDetailDialog((Dialog)owner, dialogTitle, message, msgDetail, messageType, true, isShowTwoBtn, btnOneText, btnTwoText, keys);
        } else {
            ContextPropVal propVal = InstallContext.getInstance().getPropertyMap().getProp("lego.base.wizarddlg");
            WizardDialog wizardDlg = (WizardDialog)propVal.getValue();
            dialog = new ShowDetailDialog((Frame)wizardDlg, dialogTitle, message, msgDetail, messageType, true, isShowTwoBtn, btnOneText, btnTwoText, keys);
        }
        if (!OptionPaneUI.isToHandleEscAndCls()) {
            dialog.setDefaultCloseOperation(0);
            dialog.validate();
        }
        dialog.setVisible(true);
    }

    private static Object checkMessage(Object message) {
        if (message == null) {
            LOGGER.debug("showOptionDialog: message is null.", (Object)"checkMessage");
            message = "";
        }
        return message;
    }

    private static String checkTitle(String title) {
        if (title == null) {
            LOGGER.debug("showOptionDialog: title is null.", (Object)"checkTitle");
            title = "";
        }
        return title;
    }

    private static Object[] checkOptions(Object[] options) {
        if (options == null || options.length == 0) {
            options = new Object[]{STRING_OK, STRING_CANCEL};
        }
        return options;
    }

    public static Frame getRootFrame() {
        return JOptionPane.getRootFrame();
    }
}

