/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ui;

import com.huawei.elog.base.BaseStyle;
import com.huawei.elog.ui.window.PreWindows;
import com.huawei.elog.util.ResourceManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public final class OptionPaneUI
extends JDialog {
    private static final long serialVersionUID = 7160537751834001307L;
    private static boolean ifToHandleEscAndCls = true;
    private static final double D2 = 2.0;
    private Icon iconError = null;
    private Icon iconWarn = null;
    private Icon iconInfo = null;
    private Icon iconQuestion = null;
    private int returnValue = -1;
    private Object[] btnOptions;
    private JPanel contentPanel = new JPanel();
    private JPanel messagePanel = new JPanel();
    private JPanel btnPanel = new JPanel();
    private JLabel iconLabel = new JLabel();
    private JTextArea txtMessage;

    private OptionPaneUI(Dialog parentComponent, String message, String title, int messageType, Icon icon, Object[] options, Object initialValue, char[] mnemonicKeys) {
        super(parentComponent, title, true);
        this.iconError = ResourceManager.getIcon("Error");
        this.iconWarn = ResourceManager.getIcon("Warn");
        this.iconInfo = ResourceManager.getIcon("Inform");
        this.iconQuestion = ResourceManager.getIcon("Question");
        this.initOptionPane(message, messageType, icon, options, initialValue, mnemonicKeys);
    }

    private OptionPaneUI(Frame parentComponent, String message, String title, int messageType, Icon icon, Object[] options, Object initialValue, char[] mnemonicKeys) {
        super(parentComponent, title, true);
        this.iconError = ResourceManager.getIcon("Error");
        this.iconWarn = ResourceManager.getIcon("Warn");
        this.iconInfo = ResourceManager.getIcon("Inform");
        this.iconQuestion = ResourceManager.getIcon("Question");
        this.initOptionPane(message, messageType, icon, options, initialValue, mnemonicKeys);
    }

    public static OptionPaneUI createOptionPaneUI(Component parentComponent, String message, String title, int messageType, Icon icon, Object[] options, Object initialValue, char[] mnemonicKeys) {
        PreWindows.getInstance().setVisible(false);
        if (parentComponent instanceof Dialog) {
            return new OptionPaneUI((Dialog)parentComponent, message, title, messageType, icon, options, initialValue, mnemonicKeys);
        }
        if (parentComponent instanceof Frame) {
            Frame frame = (Frame)parentComponent;
            frame.setExtendedState(0);
            return new OptionPaneUI((Frame)parentComponent, message, title, messageType, icon, options, initialValue, mnemonicKeys);
        }
        return new OptionPaneUI(JOptionPane.getFrameForComponent(parentComponent), message, title, messageType, icon, options, initialValue, mnemonicKeys);
    }

    private void initOptionPane(String message, int messageType, Icon icon, Object[] options, Object initialValue, char[] mnemonicKeys) {
        message = this.setMessage(message);
        Object[] optionsWithKey = this.setOptions(options, mnemonicKeys);
        this.initIcon(messageType, icon);
        this.txtMessage = new JTextArea(message);
        this.txtMessage.setBackground(this.messagePanel.getBackground());
        this.txtMessage.setEditable(false);
        this.contentPanel.setLayout(new GridBagLayout());
        this.messagePanel.setLayout(new GridBagLayout());
        this.btnPanel.setLayout(new GridBagLayout());
        this.messagePanel.add((Component)this.iconLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 18, 2, new Insets(3, 3, 0, 6), 0, 0));
        this.messagePanel.add((Component)this.txtMessage, new GridBagConstraints(1, 0, 3, 1, 0.0, 1.0, 12, 2, new Insets(10, 6, 0, 0), 0, 0));
        this.btnOptions = optionsWithKey;
        JButton optionBtn = null;
        for (int i = 0; i < options.length; ++i) {
            optionBtn = new JButton(optionsWithKey[i].toString());
            optionBtn.setPreferredSize(new Dimension(80, 21));
            if (mnemonicKeys != null && mnemonicKeys.length > i) {
                optionBtn.setMnemonic(mnemonicKeys[i]);
            }
            optionBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionPaneUI.this.btnActionPerform(e);
                }
            });
            if (ifToHandleEscAndCls) {
                optionBtn.addKeyListener(new KAdapter());
            }
            this.btnPanel.add((Component)optionBtn, new GridBagConstraints(i, 0, 1, 1, 0.0, 1.0, 15, 2, new Insets(0, 2, 0, 2), 0, 0));
        }
        this.contentPanel.add((Component)this.messagePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 11, 2, new Insets(6, 6, 3, 6), 0, 0));
        this.contentPanel.add((Component)this.btnPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 2, new Insets(6, 6, 10, 6), 0, 0));
        this.setContentPane(this.contentPanel);
        if (ifToHandleEscAndCls) {
            this.addWindowListener(new WAdapter());
        }
        this.pack();
        this.setBackground(BaseStyle.BACKGROUND_COLOR);
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.txtMessage.setFocusable(false);
        this.setDefaultButton(initialValue);
        Dimension dScreen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dComponent = this.getSize();
        Point pos = new Point();
        pos.x = (int)(dScreen.getWidth() / 2.0 - dComponent.getWidth() / 2.0);
        pos.y = (int)(dScreen.getHeight() / 2.0 - dComponent.getHeight() / 2.0);
        this.setLocation(pos);
    }

    private Object[] setOptions(Object[] options, char[] mnemonicKeys) {
        Object[] optionsWithKey = (Object[])options.clone();
        if (mnemonicKeys == null || mnemonicKeys.length == 0) {
            return options;
        }
        if ("zh".equalsIgnoreCase(ResourceManager.getLocale().toString())) {
            StringBuffer tmp = null;
            for (int i = 0; i < mnemonicKeys.length; ++i) {
                tmp = new StringBuffer();
                tmp.append(options[i]);
                tmp.append('(');
                tmp.append(mnemonicKeys[i]);
                tmp.append(')');
                optionsWithKey[i] = tmp.toString();
            }
            return optionsWithKey;
        }
        return optionsWithKey;
    }

    private String setMessage(String message) {
        if (message == null) {
            message = "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(message);
        if (message.trim().length() < 35) {
            for (int i = 0; i < 35 - message.trim().length(); ++i) {
                sb.append(' ');
            }
        }
        return sb.toString();
    }

    private void initIcon(int messageType, Icon icon) {
        if (icon != null) {
            this.iconLabel.setIcon(icon);
        } else {
            switch (messageType) {
                case 1: {
                    this.iconLabel.setIcon(this.iconInfo);
                    break;
                }
                case 0: {
                    this.iconLabel.setIcon(this.iconError);
                    break;
                }
                case 2: {
                    this.iconLabel.setIcon(this.iconWarn);
                    break;
                }
                case 3: {
                    this.iconLabel.setIcon(this.iconQuestion);
                    break;
                }
            }
            this.iconLabel.setPreferredSize(new Dimension(32, 32));
        }
    }

    protected void closeDialog() {
        this.dispose();
    }

    protected void btnActionPerform(ActionEvent e) {
        String actionCom = e.getActionCommand();
        for (int j = 0; j < this.btnOptions.length; ++j) {
            String tmpOption = this.btnOptions[j].toString();
            if (!tmpOption.equalsIgnoreCase(actionCom)) continue;
            this.returnValue = j;
        }
        this.closeDialog();
    }

    private void setDefaultButton(Object initialValue) {
        if (initialValue == null) {
            return;
        }
        Component[] components = this.btnPanel.getComponents();
        Component tmpComp = null;
        JButton tmpButton = null;
        for (int i = 0; i < components.length; ++i) {
            tmpComp = components[i];
            if (tmpComp == null || !(tmpComp instanceof JButton)) continue;
            tmpButton = (JButton)tmpComp;
            String btnAction = tmpButton.getActionCommand();
            if (btnAction.indexOf("(") != -1) {
                btnAction = btnAction.substring(0, btnAction.indexOf("("));
            }
            if (!btnAction.equalsIgnoreCase(initialValue.toString())) continue;
            tmpButton.requestFocus();
        }
    }

    public int getValue() {
        return this.returnValue;
    }

    public static boolean isToHandleEscAndCls() {
        return ifToHandleEscAndCls;
    }

    public static void setToHandleEscAndCls(boolean istoHandleEscAndCls) {
        ifToHandleEscAndCls = istoHandleEscAndCls;
    }

    private static class WAdapter
    extends WindowAdapter {
        private WAdapter() {
        }
    }

    private static class KAdapter
    extends KeyAdapter {
        private KAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            super.keyPressed(e);
        }
    }
}

