/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ui.card.install;

import com.huawei.elog.base.BaseStyle;
import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.Main;
import com.huawei.elog.base.model.WizardDialog;
import com.huawei.elog.base.sdk.IInstallContext;
import com.huawei.elog.util.CmdUtil;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.OSUtil;
import com.huawei.elog.util.PropertyManager;
import com.huawei.elog.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExitCard
extends WizardDialog.Card {
    private static final long serialVersionUID = -8027270506914337884L;
    private static ExitCard instance = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExitCard.class);
    private transient IInstallContext ctx = InstallContext.getInstance();
    private String installType = this.ctx.getInstallType();
    private String installPath = ContextUtil.getStrValueFromCtx("lego.base.installpath");
    private String installScene = ContextUtil.getStrValueFromCtx("esight.install.scene");
    private String httpsPort = ContextUtil.getStrValueFromCtx("lego.port.https");
    private JCheckBox runVsmCheck = null;

    private ExitCard() {
        super(null, WizardDialog.Navigation.Previous, WizardDialog.Navigation.Complete, WizardDialog.Navigation.Cancel);
        this.initComps();
        this.setNavigationButtonsStatus(true, WizardDialog.Navigation.Complete);
        this.setNavigationButtonsStatus(false, WizardDialog.Navigation.Previous, WizardDialog.Navigation.Cancel);
    }

    public static ExitCard getInstance() {
        if (null == instance) {
            instance = new ExitCard();
        }
        return instance;
    }

    @Override
    protected WizardDialog.Card getNextCard() {
        return this.getNextCardBase();
    }

    private void initComps() {
        LOGGER.info("Loading Exit Page start...", (Object)"exec");
        JLabel pageTitle = new JLabel(ResourceManager.getString("ExitPage.Title"));
        pageTitle.setBounds(20, 15, 300, 20);
        pageTitle.setFont(BaseStyle.PAGE_TITLE_FONT);
        this.add(pageTitle);
        JTextArea textArea = new JTextArea();
        textArea.setMargin(new Insets(40, 10, 0, 10));
        Box mainBox = Box.createVerticalBox();
        mainBox.add(Box.createVerticalStrut(4));
        Box line = Box.createHorizontalBox();
        textArea.setBackground(this.getBackground());
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        String infoText = null;
        String password = null;
        String ipText = ContextUtil.getStrValueFromCtx("lego.base.serverIpAddress");
        String portText = ContextUtil.getStrValueFromCtx("lego.port.https");
        password = CommonUtil.decrypt(PropertyManager.getProValue("logcenter.default.login.pwd"));
        String urlText = "https://" + ipText + ":" + portText;
        String installDir = ContextUtil.getStrValueFromCtx("lego.base.installpath");
        String prodName = ContextUtil.getStrValueFromCtx("software.install.name");
        Object[] tmp = new Object[]{prodName, installDir, urlText, password};
        if ("update".equals(this.ctx.getInstallType())) {
            infoText = MessageFormat.format(ResourceManager.getString("UpgradeExitPage.Note"), tmp);
        } else {
            String reuseHistoryDataOrNot = ContextUtil.getStrValueFromCtx("is.history.data.reused");
            if ("false".equalsIgnoreCase(reuseHistoryDataOrNot)) {
                infoText = MessageFormat.format(ResourceManager.getString("ExitPage.Note"), tmp);
                infoText = MessageFormat.format(infoText, tmp);
            } else {
                Object[] tmpHistory = new Object[]{prodName, installDir, urlText};
                infoText = MessageFormat.format(ResourceManager.getString("ExitPage.Note.HistoryReuse"), tmpHistory);
                infoText = MessageFormat.format(infoText, tmpHistory);
            }
        }
        textArea.setText(infoText);
        textArea.setFocusable(true);
        textArea.setEditable(false);
        line.add(textArea);
        mainBox.add(line);
        line = Box.createHorizontalBox();
        String serverInfo = MessageFormat.format(ResourceManager.getString("ExitPage.RunServer"), prodName);
        this.runVsmCheck = new JCheckBox(serverInfo);
        this.runVsmCheck.setSelected("fuseWithEsight".equals(ContextUtil.getStrValueFromCtx("lego.base.fuseWithEsight")));
        line.add(new JLabel("    "));
        line.add(this.runVsmCheck);
        line.add(Box.createHorizontalGlue());
        mainBox.add(line);
        if ("fuseWithEsight".equals(ContextUtil.getStrValueFromCtx("lego.base.fuseWithEsight")) && "true".equals(ContextUtil.getStrValueFromCtx("collector.install.is.or.not"))) {
            this.runVsmCheck.setSelected(false);
            mainBox.remove(line);
            line = Box.createHorizontalBox();
            line.add(new JLabel("  " + ResourceManager.getString("ExitPage.Restart.eSight")));
            line.add(Box.createHorizontalGlue());
            mainBox.add(line);
        }
        JPanel southPanel = new JPanel();
        southPanel.setBackground(this.getBackground());
        this.setLayout(new BorderLayout());
        this.add((Component)mainBox, "Center");
        this.add((Component)southPanel, "South");
        this.setBorder(BorderFactory.createEmptyBorder(0, 10, 120, 12));
        LOGGER.info("Loading Exit Page end...", (Object)"exec");
    }

    private void runElogServer() {
        if (this.installType.contains("legoPlat")) {
            this.dealWithStartUp(this.httpsPort);
        } else {
            LOGGER.warn("unknown installType: {}", (Object)this.installType);
        }
    }

    private void dealWithStartUp(String httpsPortPara) {
        if (OSUtil.isWindows()) {
            String cmdPath = this.installPath + "/Runtime/bin/startSystem.vbe";
            CmdUtil.runbatParams(cmdPath, null);
        }
    }

    @Override
    protected boolean isValid(WizardDialog.Navigation navigation) {
        return false;
    }

    @Override
    protected void process(WizardDialog.Navigation navigation) {
        if (null != this.runVsmCheck && this.runVsmCheck.isSelected()) {
            Main.setExitStatue("startLogCenter");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (null != ExitCard.this.runVsmCheck && ExitCard.this.runVsmCheck.isSelected()) {
                    ExitCard.this.runElogServer();
                }
            }
        }).start();
        this.closeWizardDialog();
    }

    @Override
    public String getSummary() {
        return null;
    }
}

