/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ui.card.install;

import com.huawei.elog.base.BaseStyle;
import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.Main;
import com.huawei.elog.base.model.WizardDialog;
import com.huawei.elog.base.sdk.IInstallContext;
import com.huawei.elog.util.CmdUtil;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.OSUtil;
import com.huawei.elog.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExitCollectorCard
extends WizardDialog.Card {
    private static final long serialVersionUID = -8027270506914337884L;
    private static ExitCollectorCard instance = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExitCollectorCard.class);
    private transient IInstallContext ctx = InstallContext.getInstance();
    private String installType = this.ctx.getInstallType();
    private String installPath = ContextUtil.getStrValueFromCtx("lego.base.installpath");
    private JCheckBox runCheck = null;

    private ExitCollectorCard() {
        super(null, WizardDialog.Navigation.Previous, WizardDialog.Navigation.Complete, WizardDialog.Navigation.Cancel);
        this.initComps();
        this.setNavigationButtonsStatus(true, WizardDialog.Navigation.Complete);
        this.setNavigationButtonsStatus(false, WizardDialog.Navigation.Previous, WizardDialog.Navigation.Cancel);
    }

    public static ExitCollectorCard getInstance() {
        if (null == instance) {
            instance = new ExitCollectorCard();
        }
        return instance;
    }

    @Override
    protected WizardDialog.Card getNextCard() {
        return this.getNextCardBase();
    }

    private void initComps() {
        LOGGER.info("Loading Exit Page start...", (Object)"exec");
        JLabel pageTitle = new JLabel(ResourceManager.getString("ExitPage.Title"));
        pageTitle.setBounds(20, 15, 300, 20);
        pageTitle.setFont(BaseStyle.PAGE_TITLE_FONT);
        this.add(pageTitle);
        JTextArea textArea = new JTextArea();
        textArea.setMargin(new Insets(45, 18, 0, 10));
        Box mainBox = Box.createVerticalBox();
        mainBox.add(Box.createVerticalStrut(4));
        Box line = Box.createHorizontalBox();
        textArea.setBackground(this.getBackground());
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        String infoText = "";
        String prodName = ContextUtil.getStrValueFromCtx("software.install.name");
        infoText = "update".equals(this.ctx.getInstallType()) ? MessageFormat.format(ResourceManager.getString("UpgradeExitPage.CollectorNote"), prodName) : MessageFormat.format(ResourceManager.getString("ExitPage.CollectorNote"), prodName);
        infoText = MessageFormat.format(infoText, prodName);
        textArea.setText(infoText);
        textArea.setFocusable(true);
        textArea.setEditable(false);
        line.add(textArea);
        mainBox.add(line);
        line = Box.createHorizontalBox();
        infoText = MessageFormat.format(ResourceManager.getString("ExitPage.RunXCollector"), prodName);
        this.runCheck = new JCheckBox(infoText);
        this.runCheck.setSelected(false);
        line.add(new JLabel("    "));
        line.add(this.runCheck);
        line.add(Box.createHorizontalGlue());
        mainBox.add(line);
        JPanel southPanel = new JPanel();
        southPanel.setBackground(this.getBackground());
        this.setLayout(new BorderLayout());
        this.add((Component)mainBox, "Center");
        this.add((Component)southPanel, "South");
        this.setBorder(BorderFactory.createEmptyBorder(0, 10, 120, 12));
        LOGGER.info("Loading Exit Page end...", (Object)"exec");
    }

    private void dealWithCollectorStartUp() {
        if (OSUtil.isWindows()) {
            String cmdPath = this.installPath + "/antiddos_collector/uninstall/startSystem.vbe";
            CmdUtil.runbatParams(cmdPath, null);
            CommonUtil.shutDownJvm(0);
        }
    }

    @Override
    protected boolean isValid(WizardDialog.Navigation navigation) {
        return false;
    }

    @Override
    protected void process(WizardDialog.Navigation navigation) {
        Properties props;
        if (this.runCheck.isSelected()) {
            Main.setExitStatue("startLogCenter");
        }
        if (!(props = System.getProperties()).getProperty("os.name").equalsIgnoreCase("linux")) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    LOGGER.debug(" runCheck.isSelected(): " + ExitCollectorCard.this.runCheck.isSelected(), (Object)"process");
                    if (ExitCollectorCard.this.runCheck.isSelected()) {
                        LOGGER.debug("installType: " + ExitCollectorCard.this.installType, (Object)"process");
                        if ("Collector".equals(ExitCollectorCard.this.installType)) {
                            ExitCollectorCard.this.dealWithCollectorStartUp();
                        }
                    }
                }
            }).start();
        }
        this.closeWizardDialog();
    }

    @Override
    public String getSummary() {
        return null;
    }
}

