/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ui.card.install;

import com.huawei.elog.CollectorHelper;
import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.model.WizardDialog;
import com.huawei.elog.base.sdk.IInstallContext;
import com.huawei.elog.ui.DoCostTimeWorkDlg;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Extend4eLogCard
extends WizardDialog.Card
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(Extend4eLogCard.class);
    private static final long serialVersionUID = 9156456010695670478L;
    private static Extend4eLogCard instance = null;
    private static JComboBox jcombLocalIpAddress = new JComboBox();
    private static int x = Locale.ENGLISH.equals(ResourceManager.getLocale()) ? 5 : 20;
    private transient IInstallContext context = InstallContext.getInstance();
    private String barndName = ContextUtil.getStrValueFromCtx("software.install.name");

    private Extend4eLogCard() {
        super(null, new WizardDialog.Navigation[0]);
        this.assembleCard();
        this.setNavigationButtonsStatus(true, WizardDialog.Navigation.Previous, WizardDialog.Navigation.Next, WizardDialog.Navigation.Cancel);
    }

    public static Extend4eLogCard getInstance() {
        if (instance == null) {
            instance = new Extend4eLogCard();
        }
        return instance;
    }

    public static JComboBox getCmbeLogIp() {
        return jcombLocalIpAddress;
    }

    public static void setCmbeLogIp(JComboBox cmbeLogIp) {
        jcombLocalIpAddress = cmbeLogIp;
    }

    private static void setAllHostAddressToCB() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    String ip;
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (inetAddress.isLoopbackAddress() || (ip = inetAddress.getHostAddress()).contains(":")) continue;
                    jcombLocalIpAddress.addItem(ip);
                }
            }
        }
        catch (SocketException e) {
            LOGGER.error("In Extend4eLogCard of Extend4eLogCard:", (Throwable)e);
        }
    }

    public void assembleCard() {
        JPanel pane = new JPanel(new BorderLayout(8, 4));
        pane.setBackground(super.getBackground());
        pane.setBorder(new EmptyBorder(15, 20, 40, 20));
        JPanel pane1 = new JPanel(new BorderLayout());
        pane1.setBackground(super.getBackground());
        pane1.add("Center", new JLabel(ResourceManager.getString("VSM.EXTEND.ELOG.CHECKBOX.LABEL")));
        pane.add("Center", this.ipsetCard());
        String reuseHistoryDataOrNot = ContextUtil.getStrValueFromCtx("is.history.data.reused");
        if ("true".equalsIgnoreCase(reuseHistoryDataOrNot) || this.context.getEnvirments().isSystemInstalled()) {
            jcombLocalIpAddress.removeAllItems();
            String localIp = (String)this.context.getEnvirments().getPropertyMap().getProp("lego.base.installIpAddress").getValue();
            jcombLocalIpAddress.addItem(localIp);
            jcombLocalIpAddress.setEnabled(false);
        }
        this.add(pane);
    }

    private JPanel ipsetCard() {
        jcombLocalIpAddress.removeAllItems();
        Extend4eLogCard.setAllHostAddressToCB();
        JPanel panel = new JPanel();
        panel.setBackground(super.getBackground());
        panel.setLayout(null);
        panel.setVisible(true);
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1), MessageFormat.format(ResourceManager.getString("VSM.EXTEND.ELOG.TITLEBORD.LABEL"), this.barndName)));
        panel.setLayout(null);
        JLabel jl1 = new JLabel();
        jl1.setText(ResourceManager.getString("vsm.extend.elog.local.ip"));
        jl1.setBounds(x, 110, 100, 20);
        jcombLocalIpAddress.setBounds(125, 110, 125, 20);
        panel.add(jl1);
        panel.add(jcombLocalIpAddress);
        return panel;
    }

    private boolean checkValid() {
        String performanceConf;
        if (jcombLocalIpAddress.getItemCount() < 1) {
            OptionPane.showErrorDialog(ResourceManager.getString("VSM.COLLECTOR.NO.IP.ERROR"));
            LOGGER.error(ResourceManager.getString("VSM.COLLECTOR.NO.IP.ERROR"), (Object)"checkValid");
        }
        if (jcombLocalIpAddress.isEnabled() && jcombLocalIpAddress.getSelectedItem().toString().length() < 1) {
            OptionPane.showErrorDialog(ResourceManager.getString("LEGO.COMMON.NULL.ERROR", ResourceManager.getString("vsm.extend.eLog.local.ip")));
            return false;
        }
        String hightOrLowCfg = ContextUtil.getStrValueFromCtx("collector.install.config.high.or.low");
        if (StringUtils.isEmpty((CharSequence)hightOrLowCfg)) {
            CollectorHelper.parseClStoreConfig();
        }
        if (StringUtils.isEmpty((CharSequence)(performanceConf = ContextUtil.getStrValueFromCtx("performance.conf")))) {
            CollectorHelper.parsePerformanceConf();
        }
        return true;
    }

    @Override
    protected WizardDialog.Card getNextCard() {
        DoCostTimeWorkDlg dlg = new DoCostTimeWorkDlg(Extend4eLogCard.getInstance(), ResourceManager.getString("InputPara.hint"), ResourceManager.getString("InputPara.InitBeforeInstall"), "checkingThread");
        dlg.display();
        if (!dlg.isResult()) {
            return null;
        }
        return this.getNextCardBase();
    }

    @Override
    public boolean doCostTimeWork() {
        LOGGER.debug("this.installConext.getEnvirments().isSystemInstalled(): {}", (Object)this.installConext.getEnvirments().isSystemInstalled());
        this.storeCurrentProps();
        if (!this.checkValid()) {
            return false;
        }
        return super.doCostTimeWork();
    }

    private void storeCurrentProps() {
        ContextUtil.saveSearalizeValue2Ctx("lego.base.installIpAddress", Extend4eLogCard.getCmbeLogIp().getSelectedItem().toString());
    }

    @Override
    protected boolean isValid(WizardDialog.Navigation navigation) {
        return false;
    }

    @Override
    protected void process(WizardDialog.Navigation navigation) {
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        String lineWrap = CommonUtil.WRAP_CHAR;
        sb.append(lineWrap);
        sb.append("[" + ResourceManager.getString("vsm.extend.elog.local.ip.title") + "]" + lineWrap);
        Locale locale = ResourceManager.getLocale();
        String econdSpacePrelineEn = null;
        econdSpacePrelineEn = locale.equals(Locale.CHINESE) ? "   " : "";
        sb.append(ResourceManager.getString("vsm.extend.elog.local.ipextrafirst"));
        sb.append(econdSpacePrelineEn + ResourceManager.getString("vsm.extend.elog.local.ipextralast") + "  " + Extend4eLogCard.getCmbeLogIp().getSelectedItem().toString());
        return sb.toString();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }
}

