/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ui.card.install;

import com.huawei.elog.base.BaseStyle;
import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.constant.ConstManager;
import com.huawei.elog.base.constant.DefaultValueManager;
import com.huawei.elog.base.model.DataBaseInfo;
import com.huawei.elog.base.model.WizardDialog;
import com.huawei.elog.base.sdk.IInstallContext;
import com.huawei.elog.ui.DoCostTimeWorkDlg;
import com.huawei.elog.ui.LimitedDocument;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.ui.card.install.DataBaseExceptionString;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.DBConnectionFactory;
import com.huawei.elog.util.IDBConnection;
import com.huawei.elog.util.OSUtil;
import com.huawei.elog.util.PortCheckUtil;
import com.huawei.elog.util.PropertyManager;
import com.huawei.elog.util.ResourceManager;
import com.huawei.elog.util.ServiceUtil;
import com.huawei.elog.util.UIUtil;
import com.huawei.elog.util.ValidateUtil;
import com.huawei.elog.util.db.DBUtil;
import com.huawei.elog.util.sdp.EncryptData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.util.List;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InputDBCard
extends WizardDialog.Card {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(InputDBCard.class);
    private static final String MYSQL_PWD_DEFAULT = CommonUtil.decrypt(PropertyManager.getProValue("lego.install.db.mysql.host.pswd"));
    private static final String MYSQL_SUPPWD_DEFAULT = CommonUtil.decrypt(PropertyManager.getProValue("lego.install.db.mysql.host.fusepswd"));
    private static IInstallContext ctx = InstallContext.getInstance();
    private static EncryptData encryptData = EncryptData.getInstanse();
    private static StringBuffer summaryMsg = new StringBuffer();
    private static InputDBCard instance = null;
    private static final String TESTMODE = "TEST";
    private final String reuseHistoryDataOrNot = ContextUtil.getStrValueFromCtx("is.history.data.reused");
    private String dbType = null;
    private String systemAdministrator = "";
    private char[] adminPwd;
    private String nmsUser = "";
    private char[] nmsPwd;
    private char[] nmsPwdConfirm;
    private String port = "";
    private String dataPath = "";
    private JLabel ipLabel;
    private JComboBox ipBox;
    private JLabel adminUserLabel;
    private JTextField dbipInput;
    private JLabel dbipInputLabel;
    private JTextField adminUserInput;
    private JLabel adminPwdLabel;
    private JPasswordField adminPwdInput;
    private JLabel userLabel;
    private JTextField userInput;
    private JLabel pwdLabel;
    private JPasswordField pwdInput;
    private JLabel pwd2Label;
    private JPasswordField pwd2Input;
    private JLabel sidLabel;
    private JTextField sidBox;
    private JLabel portLabel;
    private JTextField portInput;
    private JLabel dataPathLabel;
    private JTextField dataPathInput;
    private JButton selectPathButton;
    private JButton btnConn;
    private JLabel tipOfDBLabel;
    private ActionListener selectActionListener;
    private JComboBox dbtypeCmb;
    private JLabel dbtypeLabel;
    private String dbtypeLowercase;
    private Box sidLine;
    private final Box tryLine = Box.createHorizontalBox();
    private final Box tipLine = Box.createHorizontalBox();
    private String strDBType = "Unknown";
    private JLabel pageTitle;
    private String testPassWordMode = "SAVE";
    private Box mainBox = null;
    private Box btnConnLine = null;
    private Box testPassWordBtnLine = null;
    private String strValueFromCtx = ContextUtil.getStrValueFromCtx("lego.base.fuseWithEsight");
    private String[] resourceParm = new String[2];

    private InputDBCard() {
        super(null, new WizardDialog.Navigation[0]);
        this.resourceParm[1] = ContextUtil.getStrValueFromCtx("software.install.name");
        this.initComps();
        this.setNavigationButtonsStatus(true, WizardDialog.Navigation.Previous, WizardDialog.Navigation.Next, WizardDialog.Navigation.Cancel);
        this.initCompsStatus();
    }

    public static InputDBCard getInstance() {
        if (null == instance) {
            instance = new InputDBCard();
        }
        return instance;
    }

    private void initComps() {
        this.pageTitle = new JLabel(ResourceManager.getString("InputDBPara.Title"));
        this.pageTitle.setBounds(20, 15, 300, 20);
        this.pageTitle.setFont(BaseStyle.PAGE_TITLE_FONT);
        this.add(this.pageTitle);
        this.dbipInputLabel = new JLabel(ResourceManager.getString("LEGO.DB.SET.DB.DBSERVER"));
        this.dbipInput = new JTextField();
        this.ipLabel = new JLabel(ResourceManager.getString("InputDBPara.IP"));
        this.adminPwdLabel = new JLabel(ResourceManager.getString("InputDBPara.adminPwd"));
        this.adminPwdInput = new JPasswordField("");
        this.pwdLabel = new JLabel(ResourceManager.getString("InputDBPara.NmsPwd"));
        this.pwdInput = new JPasswordField("");
        this.pwd2Label = new JLabel(ResourceManager.getString("InputDBPara.NmsPwdConfirm"));
        this.pwd2Input = new JPasswordField("");
        LimitedDocument limitDocumentPwd = new LimitedDocument(CommonUtil.MAXPWDLEN);
        this.adminPwdInput.setDocument(limitDocumentPwd);
        LimitedDocument pwdDoc = new LimitedDocument(CommonUtil.MAXPWDLEN);
        this.pwdInput.setDocument(pwdDoc);
        LimitedDocument pwdDoc2 = new LimitedDocument(CommonUtil.MAXPWDLEN);
        this.pwd2Input.setDocument(pwdDoc2);
        this.ipBox = new JComboBox();
        List<String> ipSets = OSUtil.getLocalAllIps();
        this.ipBox.setEditable(false);
        for (String ipAddr : ipSets) {
            String normalizeIpAddr = Normalizer.normalize(ipAddr, Normalizer.Form.NFKC);
            if (normalizeIpAddr.contains("127.0.0")) continue;
            this.ipBox.addItem(normalizeIpAddr);
        }
        this.adminUserLabel = new JLabel(ResourceManager.getString("InputDBPara.SystemAdministrator"));
        this.adminUserInput = new JTextField();
        this.userLabel = new JLabel(ResourceManager.getString("InputDBPara.NmsUser"));
        this.userInput = new JTextField();
        this.sidLabel = new JLabel(ResourceManager.getString("InputDBPara.SID"));
        this.sidBox = new JTextField();
        if (OSUtil.isWindows()) {
            this.sidBox.setText("MSSQLSERVER");
        }
        this.dbtypeLabel = new JLabel(ResourceManager.getString("InputDBPara.DBType"));
        this.dbtypeCmb = new JComboBox();
        this.dbtypeCmb.setBackground(Color.white);
        this.dbtypeCmb.addItem("MySQL");
        if ("NORMAL".equals(ContextUtil.getStrValueFromCtx("vsm.install.mode.ha")) && OSUtil.isWindows()) {
            this.dbtypeCmb.addItem("Microsoft SQL Server");
        }
        this.dbtypeCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InputDBCard.this.dbTypeActionPerformed(e);
            }
        });
        this.dbtypeCmb.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.dataPathLabel = new JLabel(ResourceManager.getString("InputDBPara.SetDir"));
        this.dataPathInput = new JTextField();
        this.portLabel = new JLabel(ResourceManager.getString("InputDBPara.Port"));
        this.portInput = new JTextField();
        LimitedDocument limitDocumentPort = new LimitedDocument(CommonUtil.MAXPORTLEN);
        this.portInput.setDocument(limitDocumentPort);
        this.selectPathButton = new JButton();
        this.selectPathButton.setText("...");
        this.selectPathButton.setFont(BaseStyle.DEFAULT_FONT);
        this.dataPathInput.setEnabled(false);
        this.selectPathButton.setEnabled(false);
        this.tipOfDBLabel = new JLabel();
        this.btnConn = new JButton();
        UIUtil.setSize(this.btnConn, new Dimension(92, 21));
        this.btnConn.setText(ResourceManager.getString("InputDBPara.checkPara"));
        this.btnConn.setFont(OSUtil.isChineseLocale() ? BaseStyle.DEFAULT_FONT : BaseStyle.DEFAULT_FONT_EN);
        this.btnConn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InputDBCard.this.connTestActionListener(e, false, false);
            }
        });
        UIUtil.setSize(this.dbipInputLabel, ConstManager.DIMENSION_TEXTFIELD_MIN);
        UIUtil.setSize(this.dbipInput, ConstManager.DIMENSION_TEXTFIELD);
        UIUtil.setSize(this.dbtypeLabel, ConstManager.DIMENSION_TEXTFIELD_MIN);
        UIUtil.setSize(this.dbtypeCmb, ConstManager.DIMENSION_TEXTFIELD);
        UIUtil.setSize(this.adminPwdLabel, ConstManager.DIMENSION_TEXTFIELD_MIN);
        UIUtil.setSize(this.adminUserLabel, ConstManager.DIMENSION_TEXTFIELD_MIN);
        UIUtil.setSize(this.pwdLabel, ConstManager.DIMENSION_TEXTFIELD_MIN);
        UIUtil.setSize(this.pwd2Label, ConstManager.DIMENSION_TEXTFIELD_MIN);
        UIUtil.setSize(this.userLabel, ConstManager.DIMENSION_TEXTFIELD_MIN);
        UIUtil.setSize(this.ipLabel, ConstManager.DIMENSION_TEXTFIELD_MIN);
        UIUtil.setSize(this.adminPwdInput, ConstManager.DIMENSION_TEXTFIELD);
        UIUtil.setSize(this.adminUserInput, ConstManager.DIMENSION_TEXTFIELD);
        UIUtil.setSize(this.pwdInput, ConstManager.DIMENSION_TEXTFIELD);
        UIUtil.setSize(this.pwd2Input, ConstManager.DIMENSION_TEXTFIELD);
        UIUtil.setSize(this.userInput, ConstManager.DIMENSION_TEXTFIELD);
        UIUtil.setSize(this.sidLabel, ConstManager.DIMENSION_TEXTFIELD_MIN);
        UIUtil.setSize(this.sidBox, new Dimension(110, 20));
        UIUtil.setSize(this.ipBox, ConstManager.DIMENSION_TEXTFIELD);
        UIUtil.setSize(this.dataPathLabel, ConstManager.DIMENSION_TEXTFIELD_MIN);
        UIUtil.setSize(this.dataPathInput, ConstManager.DIMENSION_TEXTFIELD);
        UIUtil.setSize(this.portLabel, ConstManager.DIMENSION_TEXTFIELD_MIN);
        UIUtil.setSize(this.portInput, ConstManager.DIMENSION_TEXTFIELD);
        UIUtil.setSize(this.selectPathButton, ConstManager.DIMENSION_BUTTON_MIN);
        UIUtil.setSize(this.tipOfDBLabel, new Dimension(400, 21));
        this.mainBox = Box.createVerticalBox();
        this.mainBox.setBorder(new EmptyBorder(20, 0, 10, 20));
        this.mainBox.add(Box.createVerticalStrut(5));
        Box line = Box.createHorizontalBox();
        if ("Independent Scene".equals(CommonUtil.getInstallScene())) {
            this.tipLine.add(this.tipOfDBLabel);
            this.tipOfDBLabel.setVisible(true);
            this.tipOfDBLabel.setBorder(new EmptyBorder(5, 0, 0, 0));
            LOGGER.info("Install new Db.", (Object)"initComps");
        } else {
            this.tipOfDBLabel.setVisible(false);
        }
        this.mainBox.add(Box.createVerticalStrut(5));
        this.mainBox.add(this.tipLine);
        line = Box.createHorizontalBox();
        line.add(this.dbtypeLabel);
        line.add(this.dbtypeCmb);
        JLabel cmbSpace = new JLabel();
        UIUtil.setSize(cmbSpace, ConstManager.DIMENSION_BUTTON_MIN);
        line.add(cmbSpace);
        this.mainBox.add(Box.createVerticalStrut(5));
        this.mainBox.add(line);
        if ("Microsoft SQL Server".equalsIgnoreCase(this.dbType)) {
            line = Box.createHorizontalBox();
            line.add(this.dbipInputLabel);
            line.add(this.dbipInput);
            JLabel tempLabel = new JLabel();
            UIUtil.setSize(tempLabel, ConstManager.DIMENSION_BUTTON_MIN);
            line.add(tempLabel);
            this.mainBox.add(Box.createVerticalStrut(5));
            this.mainBox.add(line);
            this.dbipInput.setText(PropertyManager.getProValue("lego.install.db.host.ip"));
        }
        line = Box.createHorizontalBox();
        line.add(this.adminUserLabel);
        line.add(this.adminUserInput);
        JLabel adminUserSpace = new JLabel();
        UIUtil.setSize(adminUserSpace, ConstManager.DIMENSION_BUTTON_MIN);
        line.add(adminUserSpace);
        this.mainBox.add(Box.createVerticalStrut(5));
        this.mainBox.add(line);
        line = Box.createHorizontalBox();
        line.add(this.adminPwdLabel);
        line.add(this.adminPwdInput);
        JLabel adminPwdSpace = new JLabel();
        UIUtil.setSize(adminPwdSpace, ConstManager.DIMENSION_BUTTON_MIN);
        line.add(adminPwdSpace);
        this.mainBox.add(Box.createVerticalStrut(5));
        this.mainBox.add(line);
        line = Box.createHorizontalBox();
        line.add(this.userLabel);
        line.add(this.userInput);
        JLabel userSpace = new JLabel();
        UIUtil.setSize(userSpace, ConstManager.DIMENSION_BUTTON_MIN);
        line.add(userSpace);
        this.mainBox.add(Box.createVerticalStrut(5));
        this.mainBox.add(line);
        line = Box.createHorizontalBox();
        line.add(this.pwdLabel);
        line.add(this.pwdInput);
        JLabel pwdSpace = new JLabel();
        UIUtil.setSize(pwdSpace, ConstManager.DIMENSION_BUTTON_MIN);
        line.add(pwdSpace);
        this.mainBox.add(Box.createVerticalStrut(5));
        this.mainBox.add(line);
        line = Box.createHorizontalBox();
        line.add(this.pwd2Label);
        line.add(this.pwd2Input);
        JLabel pwd2Space = new JLabel();
        UIUtil.setSize(pwd2Space, ConstManager.DIMENSION_BUTTON_MIN);
        line.add(pwd2Space);
        this.mainBox.add(Box.createVerticalStrut(5));
        this.mainBox.add(line);
        this.userInput.setText(ContextUtil.getStrValueFromCtx("lego.db.username"));
        this.userInput.setToolTipText(ResourceManager.getString("InputDBPara.TipOfNmsUser"));
        this.pwdInput.setToolTipText(ResourceManager.getString("InputDBPara.TipOfNMSPWD"));
        this.pwd2Input.setToolTipText(ResourceManager.getString("InputDBPara.TipOfNMSPWD"));
        line = Box.createHorizontalBox();
        line.add(this.portLabel);
        line.add(this.portInput);
        JLabel portSpace = new JLabel();
        UIUtil.setSize(portSpace, ConstManager.DIMENSION_BUTTON_MIN);
        line.add(portSpace);
        this.mainBox.add(Box.createVerticalStrut(5));
        this.mainBox.add(line);
        this.dataPathInput.setText(this.dataPath);
        this.sidLine = Box.createHorizontalBox();
        this.sidLine.add(this.sidLabel);
        this.sidLine.add(this.sidBox);
        this.sidLine.add(this.btnConn);
        JLabel sidSpace = new JLabel();
        UIUtil.setSize(sidSpace, ConstManager.DIMENSION_BUTTON_MIN);
        this.sidLine.add(sidSpace);
        this.mainBox.add(Box.createVerticalStrut(5));
        this.mainBox.add(this.sidLine);
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainBox, "Center");
        this.setBorder(ConstManager.EMPTY_BORDER);
        this.selectPathButton.addActionListener(this.selectActionListener);
        this.selectPathButton.setMnemonic('B');
        this.portInput.setToolTipText(ResourceManager.getString("InputDBPara.PortError"));
        String strpwdTip = ResourceManager.getString("InputDBPara.TipOfPWD");
        Object[] token = new Object[]{this.systemAdministrator};
        strpwdTip = MessageFormat.format(strpwdTip, token);
        this.adminPwdInput.setToolTipText(strpwdTip);
        this.pwdInput.setToolTipText(ResourceManager.getString("InputDBPara.TipOfNMSPWD"));
        this.pwd2Input.setToolTipText(ResourceManager.getString("InputDBPara.TipOfNMSPWD"));
        this.adminUserInput.setToolTipText(ResourceManager.getString("InputDBPara.TipOfUser"));
        this.dbtypeCmb.setSelectedItem("MySQL");
        this.dbtypeCmb.setEditable(false);
        this.dbtypeCmb.setEnabled(false);
    }

    private void initCompsStatus() {
        if ("true".equalsIgnoreCase(this.reuseHistoryDataOrNot)) {
            if ("MySQL".equals(ContextUtil.getStrValueFromCtx("lego.db.type"))) {
                UIUtil.setComboBoxSelected(this.dbtypeCmb, "MySQL");
            } else {
                UIUtil.setComboBoxSelected(this.dbtypeCmb, "Microsoft SQL Server");
            }
            this.dbtypeCmb.setEnabled(false);
        }
        this.dbTypeActionPerformed(null);
    }

    private void dbTypeActionPerformed(ActionEvent e) {
        this.dbType = String.valueOf(this.dbtypeCmb.getSelectedItem());
        if ("MySQL".equalsIgnoreCase(this.dbType)) {
            LOGGER.debug("current db type is: MySQL", (Object)"dbTypeActionPerformed");
            this.strDBType = "MySQL";
            if (null != this.sidLine) {
                this.sidLine.setVisible(false);
            }
            this.tryLine.setVisible(false);
            this.portInput.setEditable(false);
            this.dataPathInput.setEditable(false);
            this.selectPathButton.setEnabled(false);
            this.systemAdministrator = "fuseWithEsight".equals(this.strValueFromCtx) ? ContextUtil.getStrValueFromCtx("lego.db.username") : PropertyManager.getProValue("lego.install.db.mysql.host.user");
            this.pwdInput.setText(MYSQL_PWD_DEFAULT);
            this.pwd2Input.setText(MYSQL_PWD_DEFAULT);
            this.adminPwdInput.setText(MYSQL_SUPPWD_DEFAULT);
            this.adminPwdInput.setEditable(false);
            this.pwdInput.setEditable(false);
            this.pwd2Input.setEditable(false);
            if ("true".equalsIgnoreCase(this.reuseHistoryDataOrNot)) {
                this.adminPwdInput.setText(ContextUtil.getStrValueFromCtx("lego.db.password"));
                this.port = ContextUtil.getStrValueFromCtx("lego.db.port");
                this.pwdInput.setText(ContextUtil.getStrValueFromCtx("esight.db.nmsdbpassword"));
                this.pwd2Input.setText(ContextUtil.getStrValueFromCtx("esight.db.nmsdbpassword"));
                this.portInput.setEditable(false);
                this.adminUserInput.setEditable(false);
                this.adminPwdInput.setEditable(false);
                this.pwdInput.setEditable(false);
                this.pwd2Input.setEditable(false);
            } else {
                this.adminPwdInput.setText(MYSQL_SUPPWD_DEFAULT);
                this.port = PropertyManager.getProValue("lego.install.db.mysql.host.port");
            }
            this.portInput.setEditable(false);
            this.adminUserInput.setEditable(false);
            this.port = PropertyManager.getProValue("lego.install.db.mysql.host.port");
            if (null == this.testPassWordBtnLine) {
                JButton testPassWordBtn = null;
                testPassWordBtn = "fuseWithEsight".equals(this.strValueFromCtx) ? new JButton(ResourceManager.getString("VSM.CHANGE.DB.TEST.CONNECTION")) : new JButton(ResourceManager.getString("VSM.CHECK.DB.PASSWORD"));
                testPassWordBtn.setFont(OSUtil.isChineseLocale() ? BaseStyle.DEFAULT_FONT : BaseStyle.DEFAULT_FONT_EN);
                UIUtil.setSize(testPassWordBtn, new Dimension(120, 21));
                JLabel l1 = new JLabel();
                UIUtil.setSize(l1, new Dimension(230, 21));
                this.testPassWordBtnLine = Box.createHorizontalBox();
                this.testPassWordBtnLine.add(new JLabel(" "));
                this.testPassWordBtnLine.add(l1);
                this.testPassWordBtnLine.add(testPassWordBtn);
                this.mainBox.add(Box.createVerticalStrut(5));
                testPassWordBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        InputDBCard.this.testPassWordActionListener(e);
                    }
                });
            }
            if (null != this.testPassWordBtnLine) {
                UIUtil.boxAddComponents(this.mainBox, this.testPassWordBtnLine);
            }
            if (null != this.btnConnLine) {
                this.mainBox.remove(this.btnConnLine);
                this.mainBox.updateUI();
                this.repaint();
            }
        } else {
            LOGGER.error("unkown db type: " + this.dbType, (Object)"dbTypeActionPerformed");
        }
        this.userInput.setText(PropertyManager.getProValue("lego.install.db.mysql.host.nmsuser"));
        this.adminUserInput.setText(this.systemAdministrator);
        this.adminUserInput.setEnabled(false);
        this.portInput.setText(this.port);
        this.userInput.setEnabled(false);
        if ("fuseWithEsight".equals(this.strValueFromCtx)) {
            this.adminUserInput.setEnabled(true);
            this.adminUserInput.setEditable(true);
        }
        if (!"true".equalsIgnoreCase(this.reuseHistoryDataOrNot) && "Microsoft SQL Server".equalsIgnoreCase(this.dbType)) {
            this.adminPwdInput.setText("");
            this.adminPwdInput.setEditable(true);
            this.adminPwdInput.setEnabled(true);
            this.adminPwdInput.requestFocus();
        }
        this.tipOfDBLabel.setText(ResourceManager.getString("InputDBPara.TipOf" + this.strDBType));
        String strpwdTip = ResourceManager.getString("InputDBPara.TipOfPWD");
        Object[] token = new Object[]{this.systemAdministrator};
        strpwdTip = MessageFormat.format(strpwdTip, token);
        this.adminPwdInput.setToolTipText(strpwdTip);
        this.mainBox.updateUI();
        this.repaint();
    }

    private boolean testPassWordActionListener(ActionEvent e) {
        this.testPassWordMode = null != e ? TESTMODE : "";
        if ("Microsoft SQL Server".equalsIgnoreCase(this.dbType)) {
            return this.testPW4SQLSever();
        }
        if ("MySQL".equalsIgnoreCase(this.dbType)) {
            return this.testPW4MySQL();
        }
        return true;
    }

    private boolean testPW4MySQL() {
        DataBaseInfo dbInfo = this.getBaseInfo();
        IDBConnection dbConnection = DBConnectionFactory.getInstance(dbInfo);
        if (null == dbConnection) {
            LOGGER.error("Falied to conncet to mysql.");
            return false;
        }
        if ("MySQL".equalsIgnoreCase(this.dbType)) {
            if ("legoPlat".equals(InstallContext.getInstance().getInstallType()) && !ValidateUtil.getInstance().checkLegal(dbInfo)) {
                LOGGER.error("Falied to check mysql port.");
                return false;
            }
            if ("fuseWithEsight".equals(this.strValueFromCtx)) {
                if (!this.checkDbValid(dbInfo, true)) {
                    OptionPane.showInfoDialog(ResourceManager.getString("LEGO.DB.SET.PORTANDIPADDRESS.ERROR"));
                    return false;
                }
                if (!this.checkDbValid(dbInfo, false)) {
                    OptionPane.showInfoDialog(ResourceManager.getString("LEGO.DB.SET.PORTANDIPADDRESS.ERROR"));
                    return false;
                }
            }
            boolean isRunning = false;
            if (OSUtil.isWindows()) {
                isRunning = ServiceUtil.isServiceRunning("mysqlservice");
            }
            if (isRunning) {
                if (!this.checkDbValid(dbInfo, true)) {
                    OptionPane.showInfoDialog(ResourceManager.getString("LEGO.DB.SET.PORTANDIPADDRESS.ERROR"));
                    return false;
                }
                if (!dbConnection.isExistDB(dbInfo)) {
                    OptionPane.showInfoDialog(ResourceManager.getString("VSM.NO.REUSE.DATABASE"));
                    return false;
                }
            } else if (!this.installConext.getEnvirments().isSystemInstalled()) {
                if (this.dbType.equalsIgnoreCase("mysql")) {
                    if ("fuseWithEsight".equals(this.strValueFromCtx)) {
                        if (!this.checkDbValid(dbInfo, true)) {
                            OptionPane.showInfoDialog(ResourceManager.getString("LEGO.DB.SET.PORTANDIPADDRESS.ERROR"));
                            return false;
                        }
                    } else if (InputDBCard.checkPortUsed(Integer.parseInt(this.port))) {
                        OptionPane.showInfoDialog(ResourceManager.getString("VSM.CHECK.USE.HTTP.HTTPS", this.port));
                        return false;
                    }
                } else {
                    boolean portVacant = PortCheckUtil.checkPortUsed(Integer.parseInt(this.portInput.getText().trim()));
                    if (!portVacant) {
                        String msg = ResourceManager.getString("VSM.CHECK.USE.HTTP.HTTPS", this.portInput.getText().trim());
                        OptionPane.showInfoDialog(msg);
                        return false;
                    }
                }
            }
            if (!CommonUtil.isNotUsePort(InstallContext.getInstance().getEnvirments().getBasePath() + File.separator + "etc/config/conf/vsm_port.txt", this.portInput.getText().trim())) {
                this.resourceParm[0] = this.portInput.getText().trim();
                OptionPane.showInfoDialog(ResourceManager.getString("VSM.CHECK.HTTS.HTTPS.PORT", this.resourceParm));
                return false;
            }
            if (!dbInfo.getDbNmsPassword().equals(dbInfo.getDbNmsPassword2())) {
                OptionPane.showErrorDialog(ResourceManager.getString("VSM.CHECK.PASSWORD.NOTMATCH"));
                return false;
            }
            if (CommonUtil.passwordContainSpecialCharacter(String.valueOf(dbInfo.getDbNmsPassword()))) {
                OptionPane.showErrorDialog(ResourceManager.getString("InputDBPara.ErrNmsPwdSupportCharacter"));
                return false;
            }
            if (!ValidateUtil.getInstance().checkPassComplexity(dbInfo.getDbUserName(), dbInfo.getDbPassword())) {
                OptionPane.showErrorDialog(ResourceManager.getString("VSM.CHECK.PASSWORD.COMPLELITY"));
                return false;
            }
            if (!ValidateUtil.getInstance().checkPassComplexity(dbInfo.getDbNmsUserName(), dbInfo.getDbNmsPassword())) {
                OptionPane.showErrorDialog(ResourceManager.getString("VSM.CHECK.PASSWORD.COMPLELITY"));
                return false;
            }
            if (TESTMODE.equals(this.testPassWordMode)) {
                if ("fuseWithEsight".equals(this.strValueFromCtx)) {
                    OptionPane.showInfoDialog(ResourceManager.getString("VSM.CHANGE.DB.TEST.CONNECTION.SUCCESS"));
                } else {
                    OptionPane.showInfoDialog(ResourceManager.getString("VSM.CHECK.PASS.COMPLELITY.SUCC"));
                }
            }
            return true;
        }
        return true;
    }

    private boolean testPW4SQLSever() {
        DataBaseInfo dbInfo = this.getBaseInfo();
        if ("Microsoft SQL Server".equalsIgnoreCase(this.dbType)) {
            if (!ValidateUtil.getInstance().checkLegal(dbInfo)) {
                return false;
            }
            if (!CommonUtil.isNotUsePort(InstallContext.getInstance().getEnvirments().getBasePath() + File.separator + "etc/config/conf/vsm_port.txt", this.portInput.getText().trim())) {
                this.resourceParm[0] = this.portInput.getText().trim();
                OptionPane.showInfoDialog(ResourceManager.getString("VSM.CHECK.HTTS.HTTPS.PORT", this.resourceParm));
                return false;
            }
            if (!dbInfo.getDbNmsPassword().equals(dbInfo.getDbNmsPassword2())) {
                OptionPane.showErrorDialog(ResourceManager.getString("VSM.CHECK.PASSWORD.NOTMATCH"));
                return false;
            }
            if (!ValidateUtil.getInstance().checkPassComplexity(dbInfo.getDbUserName(), dbInfo.getDbPassword())) {
                OptionPane.showErrorDialog(ResourceManager.getString("VSM.CHECK.PASSWORD.COMPLELITY"));
                return false;
            }
            boolean checkResult = this.checkDbValid(dbInfo, false);
            if (checkResult) {
                if (TESTMODE.equals(this.testPassWordMode)) {
                    OptionPane.showInfoDialog(ResourceManager.getString("LEGO.DB.CONNECTION.SUCC"));
                }
                return true;
            }
            if (new DataBaseExceptionString().getResult() == 1) {
                OptionPane.showInfoDialog(ResourceManager.getString("LEGO.DB.SET.USERNAMEANDPASSWORD.ERROR"));
            } else if (new DataBaseExceptionString().getResult() == 2) {
                OptionPane.showInfoDialog(ResourceManager.getString("LEGO.DB.SET.HOST.PORT.ERROR"));
            } else if (new DataBaseExceptionString().getResult() == 0) {
                OptionPane.showInfoDialog(ResourceManager.getString("LEGO.DB.SET.PORTANDIPADDRESS.ERROR"));
            }
            return false;
        }
        return true;
    }

    private boolean connDatabaseAndCheckBizDataBase(boolean isNms) {
        DataBaseInfo dbInfo = this.getBaseInfo();
        if ("Microsoft SQL Server".equalsIgnoreCase(this.dbType)) {
            IDBConnection dbConnection = DBConnectionFactory.getInstance(dbInfo);
            if (null == dbConnection) {
                return false;
            }
            Connection dbConn = dbConnection.connection(dbInfo, isNms);
            if (null == dbConn) {
                OptionPane.showInfoDialog(ResourceManager.getString("LEGO.DB.SET.USERNAMEANDPASSWORD.ERROR"));
                LOGGER.debug("dbConn is null...", (Object)"connDatabaseNameListener");
            }
            boolean isDbExist = dbConnection.isExistBizDatabase(dbConn);
            if (null != dbConn) {
                try {
                    dbConn.close();
                }
                catch (SQLException e) {
                    LOGGER.error("connDatabaseAndCheckBizDataBase error: " + e, (Object)"connDatabaseNameListener");
                }
            }
            if (isDbExist) {
                int res = OptionPane.showWarnConfirmDialog(this.getContainer(), ResourceManager.getString("VSM.DATABASENAME.ERROR"));
                return 0 == res;
            }
        }
        return true;
    }

    private boolean connDatabaseUserListener(ActionEvent e, Boolean isNext) {
        DataBaseInfo dbInfo = this.getBaseInfo();
        if ("Microsoft SQL Server".equalsIgnoreCase(this.dbType)) {
            IDBConnection dbConnection = DBConnectionFactory.getInstance(dbInfo);
            if (null == dbConnection) {
                return false;
            }
            boolean bUser = dbConnection.isExistCommonuser(dbInfo);
            if (bUser) {
                int res = OptionPane.showWarnConfirmDialog(this.getContainer(), ResourceManager.getString("VSM.DATABASEUSER.ERROR"));
                if (0 == res) {
                    ContextUtil.saveSearalizeValue2Ctx("is.modify.db.pwd", "true");
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    private boolean connTestActionListener(ActionEvent e, Boolean isNext, Boolean isNms) {
        DataBaseInfo dbInfo = this.getBaseInfo();
        if ("Microsoft SQL Server".equalsIgnoreCase(this.dbType)) {
            if (!ValidateUtil.getInstance().checkLegal(dbInfo)) {
                return false;
            }
            if (!CommonUtil.isNotUsePort(InstallContext.getInstance().getEnvirments().getBasePath() + File.separator + "etc/config/conf/vsm_port.txt", this.portInput.getText().trim())) {
                this.resourceParm[0] = this.portInput.getText().trim();
                OptionPane.showInfoDialog(ResourceManager.getString("VSM.CHECK.HTTS.HTTPS.PORT", this.resourceParm));
                return false;
            }
            boolean checkResult = this.checkDbValid(dbInfo, false);
            if (checkResult) {
                if (TESTMODE.equals(this.testPassWordMode) || "Microsoft SQL Server".equals(this.dbType) && !isNext.booleanValue()) {
                    OptionPane.showInfoDialog(ResourceManager.getString("LEGO.DB.CONNECTION.SUCC"));
                }
            } else {
                if (new DataBaseExceptionString().getResult() == 1) {
                    if (isNms.booleanValue()) {
                        OptionPane.showInfoDialog(ResourceManager.getString("LEGO.DB.SET.NMSUSERNAMEANDPASSWORD.ERROR"));
                    } else {
                        OptionPane.showInfoDialog(ResourceManager.getString("LEGO.DB.SET.USERNAMEANDPASSWORD.ERROR"));
                    }
                } else if (new DataBaseExceptionString().getResult() == 2) {
                    OptionPane.showInfoDialog(ResourceManager.getString("LEGO.DB.SET.HOST.PORT.ERROR"));
                } else if (new DataBaseExceptionString().getResult() == 0) {
                    OptionPane.showInfoDialog(ResourceManager.getString("LEGO.DB.SET.PORTANDIPADDRESS.ERROR"));
                }
                return false;
            }
        }
        return true;
    }

    private boolean checkDbValid(DataBaseInfo dbInfo, Boolean isNms) {
        boolean isValid = false;
        if (null == dbInfo) {
            return false;
        }
        LOGGER.debug("dbInfo.dbtype: " + dbInfo.getDbType() + ", isNms: " + isNms, (Object)"checkDbValid");
        IDBConnection dbConnection = DBConnectionFactory.getInstance(dbInfo);
        if (null == dbConnection) {
            return false;
        }
        isValid = dbConnection.isConnected(dbInfo, isNms);
        return isValid;
    }

    public DataBaseInfo getBaseInfo() {
        DataBaseInfo dbInfo = new DataBaseInfo();
        dbInfo.setDbType(this.dbType);
        if (this.dbType.equalsIgnoreCase("mysql")) {
            dbInfo.setDbHost("127.0.0.1");
        } else {
            dbInfo.setDbHost(ctx.getPropertyMap().getProp("lego.base.installIpAddress").getValue().toString());
        }
        dbInfo.setDbPort(this.portInput.getText().trim());
        dbInfo.setDbUserName(this.adminUserInput.getText().trim());
        dbInfo.setDbPassword(String.valueOf(this.adminPwdInput.getPassword()));
        dbInfo.setDbNmsUserName(this.userInput.getText().trim());
        dbInfo.setDbNmsPassword(String.valueOf(this.pwdInput.getPassword()));
        dbInfo.setDbNmsPassword2(String.valueOf(this.pwd2Input.getPassword()));
        if ("Microsoft SQL Server".equalsIgnoreCase(this.dbType)) {
            dbInfo.setSid(this.sidBox.getText());
        }
        return dbInfo;
    }

    private boolean checkInput() {
        this.systemAdministrator = this.adminUserInput.getText();
        this.adminPwd = this.adminPwdInput.getPassword();
        this.nmsUser = this.userInput.getText();
        this.nmsPwd = this.pwdInput.getPassword();
        this.nmsPwdConfirm = this.pwd2Input.getPassword();
        this.port = this.portInput.getText();
        boolean isCfgOK = false;
        boolean bl = isCfgOK = this.systemAdministrator.length() > 0 && this.adminPwd.length > 0 && this.port.length() > 0 && this.nmsUser.length() > 0 && this.nmsPwd.length > 0 && this.nmsPwdConfirm.length > 0;
        if (!PortCheckUtil.isInvalid4PortInput(this.port)) {
            String msg = ResourceManager.getString("LEGO.SET.PORT.ERRORFORMAT", this.port);
            OptionPane.showInfoDialog(msg);
            return false;
        }
        this.dataPath = this.dataPathInput.getText();
        if (OSUtil.isWindows()) {
            this.dataPath = this.dataPath.replace('/', '\\');
            this.dataPathInput.setText(this.dataPath);
        }
        String message = "";
        if (!isCfgOK) {
            message = this.dbType.equalsIgnoreCase("mysql") ? ResourceManager.getString("InputDBPara.ErrExistEmptyPara") : ResourceManager.getString("InputDBPara.OracleErrExistEmptyPara");
            Object[] token = new Object[]{this.dataPath};
            message = MessageFormat.format(message, token);
            OptionPane.showErrorDialog(message);
            return false;
        }
        if ("mysql".equals(this.strDBType.toLowerCase(Locale.ENGLISH)) && CommonUtil.passwordContainSpecialCharacter(String.valueOf(this.adminPwd))) {
            LOGGER.error("SystemAdministrator database password contain special character.", (Object)"checkInput");
            message = ResourceManager.getString("VSM.CHECK.PASSWORD.COMPLELITY");
            OptionPane.showErrorDialog(message);
            return false;
        }
        if ("sqlserver".equals(this.strDBType.toLowerCase(Locale.ENGLISH)) && CommonUtil.passwordContainSpecialCharacterForSqlServer(String.valueOf(this.adminPwd))) {
            LOGGER.error("SystemAdministrator database password contain special character.", (Object)"checkInput");
            message = ResourceManager.getString("VSM.CHECK.PASSWORD.COMPLELITY");
            OptionPane.showErrorDialog(message);
            return false;
        }
        String checkNmsPwd = String.valueOf(this.nmsPwd);
        if (CommonUtil.ENUM_DBTYPE.SQLSERVER == CommonUtil.getDefaultDbType() && CommonUtil.passwordContainSpecialCharacterForSqlServer(checkNmsPwd)) {
            LOGGER.error("the password of common user contain specil character .", (Object)"checkInput");
            message = ResourceManager.getString("InputDBPara.ErrNmsPwdSupportCharacterForServer");
            OptionPane.showErrorDialog(message);
            return false;
        }
        if (CommonUtil.ENUM_DBTYPE.MYSQL == CommonUtil.getDefaultDbType() && CommonUtil.passwordContainSpecialCharacter(checkNmsPwd)) {
            LOGGER.error("the password of common user contain specil character .", (Object)"checkInput");
            message = ResourceManager.getString("InputDBPara.ErrNmsPwdSupportCharacter");
            OptionPane.showErrorDialog(message);
            return false;
        }
        return this.checkNmsPassword();
    }

    private boolean checkNmsPassword() {
        return true;
    }

    @Override
    protected WizardDialog.Card getNextCard() {
        DoCostTimeWorkDlg dlg = new DoCostTimeWorkDlg(InputDBCard.getInstance(), ResourceManager.getString("InputDBPara.hint"), ResourceManager.getString("InputDBPara.InitBeforeInstall"), "checkingThread");
        dlg.display();
        if (!dlg.isResult()) {
            return null;
        }
        return super.getNextCardBase();
    }

    @Override
    public boolean doCostTimeWork() {
        boolean result = this.checkInput();
        if (!result) {
            return false;
        }
        result = this.testPassWordActionListener(null);
        LOGGER.debug("testPassWordActionListener result: " + result, (Object)"testPassWordActionListener");
        if (!result) {
            return false;
        }
        result = this.connTestActionListener(null, true, false);
        LOGGER.debug("connTestActionListener result: " + result, (Object)"connTestActionListener");
        if (!result) {
            return false;
        }
        ContextUtil.saveSearalizeValue2Ctx("is.modify.db.pwd", "false");
        if ("false".equalsIgnoreCase(this.reuseHistoryDataOrNot)) {
            result = this.connDatabaseUserListener(null, true);
            LOGGER.debug("connDatabaseUserListener result: " + result, (Object)"connTestActionListener");
            if (!result) {
                return false;
            }
            result = this.connDatabaseAndCheckBizDataBase(false);
            LOGGER.debug("connDatabaseAndCheckBizDataBaseresult: " + result, (Object)"connTestActionListener");
            if (!result) {
                return false;
            }
        }
        this.saveDBParameters();
        return true;
    }

    @Override
    protected boolean isValid(WizardDialog.Navigation navigation) {
        return false;
    }

    @Override
    protected void process(WizardDialog.Navigation navigation) {
    }

    private void saveDBParameters() {
        String normalizeNmsPassword;
        String normalizeadminPassword;
        this.systemAdministrator = this.adminUserInput.getText();
        this.adminPwd = this.adminPwdInput.getPassword();
        this.nmsUser = this.userInput.getText();
        this.nmsPwd = this.pwdInput.getPassword();
        this.dbtypeLowercase = this.dbtypeCmb.getSelectedItem().toString();
        this.port = this.portInput.getText();
        this.dataPath = this.dataPathInput.getText();
        ContextUtil.saveSearalizeValue2Ctx("lego.db.type", this.dbtypeLowercase);
        ContextUtil.saveSearalizeValue2Ctx("lego.db.port", this.port);
        if (null == this.dataPath || "".equals(this.dataPath)) {
            this.dataPath = ContextUtil.getStrValueFromCtx("lego.base.installpath") + "/DBFile";
        }
        ContextUtil.saveSearalizeValue2Ctx("lego.db.data.path", this.dataPath);
        ContextUtil.saveSearalizeValue2Ctx("lego.db.username", this.systemAdministrator);
        String adminPassword = String.valueOf(this.adminPwd);
        String adminPasswordcmd = normalizeadminPassword = Normalizer.normalize(adminPassword, Normalizer.Form.NFKC);
        String adminPasswordcmdbat2 = normalizeadminPassword;
        if (normalizeadminPassword.contains("^")) {
            adminPasswordcmd = adminPasswordcmd.replace("^", "^^^^");
            adminPasswordcmdbat2 = adminPasswordcmdbat2.replace("^", "^^^^^^^^");
        }
        if (normalizeadminPassword.contains("|")) {
            adminPasswordcmd = adminPasswordcmd.replace("|", "^^^|");
            adminPasswordcmdbat2 = adminPasswordcmdbat2.replace("|", "^^^^^^^|");
        }
        ContextUtil.saveSearalizeValue2Ctx("lego.db.password", normalizeadminPassword);
        ContextUtil.saveAntValue2Ctx("lego.db.password.cmd", adminPasswordcmd);
        ContextUtil.saveAntValue2Ctx("lego.db.password.cmd2", adminPasswordcmdbat2);
        ContextUtil.saveSearalizeValue2Ctx("esight.db.nmsdbuser", this.nmsUser);
        String nmsPassword = String.valueOf(this.nmsPwd);
        String nmsPasswordcmd = normalizeNmsPassword = Normalizer.normalize(nmsPassword, Normalizer.Form.NFKC);
        String nmsPasswordcmdbat2 = normalizeNmsPassword;
        if (normalizeNmsPassword.contains("^")) {
            nmsPasswordcmd = nmsPasswordcmd.replace("^", "^^^^");
            nmsPasswordcmdbat2 = nmsPasswordcmdbat2.replace("^", "^^^^^^^^");
        }
        if (normalizeNmsPassword.contains("|")) {
            nmsPasswordcmd = nmsPasswordcmd.replace("|", "^^^|");
            nmsPasswordcmdbat2 = nmsPasswordcmdbat2.replace("|", "^^^^^^^|");
        }
        ContextUtil.saveAntValue2Ctx("esight.db.nmsdbpassword.cmd", nmsPasswordcmd);
        ContextUtil.saveAntValue2Ctx("esight.db.nmsdbpassword.cmd2", nmsPasswordcmdbat2);
        ContextUtil.saveSearalizeValue2Ctx("esight.db.nmsdbpassword", normalizeNmsPassword);
        ContextUtil.saveSearalizeValue2Ctx("esight.db.nmsdbpassword.encrypt", encryptData.encrypt(String.valueOf(this.nmsPwd)));
        ContextUtil.saveSearalizeValue2Ctx("lego.db.ipaddress", "127.0.0.1");
        if ("mysql".equalsIgnoreCase(this.strDBType)) {
            if ("fuseWithEsight".equals(this.strValueFromCtx)) {
                String esightPath = ContextUtil.getStrValueFromCtx("lego.base.eSightPath");
                ContextUtil.saveSearalizeValue2Ctx("mysql.home.path", esightPath + "/MySQL");
            } else {
                String intallPath = ContextUtil.getStrValueFromCtx("lego.base.installpath");
                ContextUtil.saveSearalizeValue2Ctx("mysql.home.path", intallPath + "/MySQL");
            }
        } else {
            ContextUtil.saveSearalizeValue2Ctx("lego.db.ipaddress", "127.0.0.1");
        }
        ContextUtil.saveSearalizeValue2Ctx("is.exist.reused.db", false);
        ContextUtil.saveSearalizeValue2Ctx("lego.base.isdbreinstall", true);
        ContextUtil.saveSearalizeValue2Ctx("lego.db.password.encrypt", encryptData.encrypt(String.valueOf(this.adminPwd)));
        ContextUtil.saveSearalizeValue2Ctx("lego.base.remote.install", false);
        String url = "";
        String driver = "";
        String dbTypePath = null;
        String host = "127.0.0.1";
        if ("mysql".equalsIgnoreCase(this.dbtypeLowercase)) {
            url = "jdbc:mysql://" + host + ":" + this.port + "?useSSL=false&serverTimezone=" + DBUtil.curTimeZone();
            driver = "com.mysql.jdbc.Driver";
            dbTypePath = "mysql";
        }
        if ("Microsoft SQL Server".equalsIgnoreCase(this.dbType)) {
            url = "jdbc:sqlserver://" + ctx.getPropertyMap().getProp("lego.base.installIpAddress").getValue() + ":" + this.port;
            driver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
            dbTypePath = "sqlserver";
        }
        ContextUtil.saveSearalizeValue2Ctx("lego.db.type.path", dbTypePath);
        ContextUtil.saveSearalizeValue2Ctx("lego.db.url", url);
        ContextUtil.saveSearalizeValue2Ctx("lego.db.driver", driver);
    }

    @Override
    public String getSummary() {
        String lineWrap = CommonUtil.WRAP_CHAR;
        summaryMsg.delete(0, summaryMsg.length());
        summaryMsg.append(lineWrap);
        summaryMsg.append("[" + this.pageTitle.getText() + "]" + lineWrap);
        summaryMsg.append(ResourceManager.getString("InputDBPara.DBType") + this.strDBType + lineWrap);
        summaryMsg.append(ResourceManager.getString("InputDBPara.NmsUser") + this.nmsUser + lineWrap);
        summaryMsg.append(ResourceManager.getString("InputDBPara.Port") + this.port + lineWrap);
        if ("Integrated Scene".equals(CommonUtil.getInstallScene())) {
            String tempstr = this.dataPath;
            if (OSUtil.isWindows()) {
                tempstr = tempstr.replaceAll("\\\\\\\\", "\\\\");
            }
            summaryMsg.append(ResourceManager.getString("InputDBPara.SetDir") + tempstr + lineWrap);
            int minSpace = Integer.parseInt(DefaultValueManager.getInstance().getDefaultValue("MinDBSpace"));
            summaryMsg.append(ResourceManager.getString("InputDBPara.NeedSpace") + minSpace + " MB" + lineWrap);
        }
        return summaryMsg.toString();
    }

    public static boolean checkPortUsed(int port) {
        try {
            ServerSocket ss = new ServerSocket(port);
            ss.close();
        }
        catch (IOException e) {
            return true;
        }
        return false;
    }
}

