/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ui.card.install;

import com.huawei.elog.base.BaseStyle;
import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.constant.ConstManager;
import com.huawei.elog.base.constant.DefaultValueManager;
import com.huawei.elog.base.context.ContextLoader;
import com.huawei.elog.base.model.Program;
import com.huawei.elog.base.model.Version;
import com.huawei.elog.base.model.WizardDialog;
import com.huawei.elog.base.sdk.IConstant;
import com.huawei.elog.common.StreamProcUtil;
import com.huawei.elog.ui.DoCostTimeWorkDlg;
import com.huawei.elog.ui.LimitedDocument;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.DiskUtil;
import com.huawei.elog.util.EnvCheckUtil;
import com.huawei.elog.util.EsightEnvMgr;
import com.huawei.elog.util.FileUtil;
import com.huawei.elog.util.HalfFullCheckUtil;
import com.huawei.elog.util.OSUtil;
import com.huawei.elog.util.PortCheckUtil;
import com.huawei.elog.util.ProgramUtil;
import com.huawei.elog.util.PropertyManager;
import com.huawei.elog.util.ResourceManager;
import com.huawei.elog.util.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InputParaCard
extends WizardDialog.Card
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static InputParaCard instance = null;
    private static final String INSTALL_FILES_BASE_PATH = ContextUtil.getStrValueFromCtx("lego.base.path");
    private static final Integer INTEGER_VERTICALSTRUT = 4;
    private static final String VERSION_PREFIX = "Version:";
    private static final String VERSION_BRAND_PREFIX = "Remark:";
    private static final String VERSION_TIME_PREFIX = "Release Time:";
    private static final String CURRENT_VERSION_PATH = "/Runtime/vsm_conf/elog/etc/version.txt";
    private static final String ELOGINSTALLEDXMLFILE = "legoPlatInstalled.xml";
    private static final Logger LOGGER = LoggerFactory.getLogger(InputParaCard.class);
    private static final int DISKSIZE_INSTALL = Integer.parseInt(PropertyManager.getProValue("elog_install.size"));
    private JComboBox collectorIPBox;
    private JComboBox serverIPBox;
    private JTextField portInput;
    private JComboBox langTypeBox;
    private String strPort = "";
    private Box mainBox;
    private JTextField pathInput;
    private JButton selectPathButton;
    private JLabel showServerIpMessage;
    private String strPath = null;
    private transient InstallContext ctx = InstallContext.getInstance();
    private String defaultLinuxPath = PropertyManager.getProValue("linux.default.install.path");
    private String defaultWindowpath = PropertyManager.getProValue("window.default.install.path");
    private final String scene = CommonUtil.getInstallScene();
    private JLabel serverIPLabel;
    private JLabel collectorIPLabel;
    private JLabel portLabel;
    private JLabel httpsPortLabel;
    private JTextField httpsPortTextField;
    private JLabel langtypeLabel;
    private JLabel installDirLabel;
    private JFileChooser chooser;
    private JLabel pageTitle;
    private String esightPath;

    private InputParaCard() {
        super(null, WizardDialog.Navigation.Previous, WizardDialog.Navigation.Next, WizardDialog.Navigation.Cancel);
        this.initComps();
        this.setNavigationButtonsStatus(true, WizardDialog.Navigation.Previous, WizardDialog.Navigation.Next, WizardDialog.Navigation.Cancel);
    }

    public static InputParaCard getInstance() {
        if (null == instance) {
            instance = new InputParaCard();
        }
        return instance;
    }

    @Override
    protected WizardDialog.Card getNextCard() {
        DoCostTimeWorkDlg dlg = new DoCostTimeWorkDlg(InputParaCard.getInstance(), ResourceManager.getString("InputPara.hint"), ResourceManager.getString("InputPara.InitBeforeInstall"), "checkingThread");
        dlg.display();
        if (!dlg.isResult()) {
            return null;
        }
        return this.getNextCardBase();
    }

    @Override
    public boolean doCostTimeWork() {
        boolean checkPath;
        boolean checkResult = this.resetCheckPortSate();
        if (!checkResult) {
            return false;
        }
        if (OSUtil.isWindows() && !(checkPath = FileUtil.testPathValid(this.pathInput.getText(), this.installDirLabel.getText(), this.getWizardDialog(), false))) {
            return false;
        }
        if (null == DiskUtil.gatherDiskInfo4OS(this.pathInput.getText())) {
            OptionPane.showInfoDialog(this.pathInput.getText() + ResourceManager.getString("LEGO.COMMON.NULL.ERROR"));
            return false;
        }
        double installfree = (double)DiskUtil.gatherDiskInfo4OS(this.pathInput.getText()).getFree() / 1.073741824E9;
        if (installfree < (double)DISKSIZE_INSTALL) {
            OptionPane.showInfoDialog(ResourceManager.getString("COLLECTOR.SYSTEM.SIZE.CHECK.FAIL.MESSAGE", String.valueOf(DISKSIZE_INSTALL)));
            return false;
        }
        return this.saveParameters();
    }

    private void initComps() {
        this.pageTitle = new JLabel(ResourceManager.getString("InputPara.ServerPara"));
        this.pageTitle.setBounds(20, 15, 300, 20);
        this.pageTitle.setFont(BaseStyle.PAGE_TITLE_FONT);
        this.add(this.pageTitle);
        this.getInfoFiles();
        this.serverIPLabel = new JLabel(ResourceManager.getString("InputPara.ServerIP"));
        this.collectorIPLabel = new JLabel(ResourceManager.getString("InputPara.collectorIP"));
        this.langtypeLabel = new JLabel(ResourceManager.getString("InputPara.LangType"));
        this.langTypeBox = new JComboBox();
        this.langTypeBox.addItem(ResourceManager.getString("InputPara.Lang_Zh"));
        this.langTypeBox.addItem(ResourceManager.getString("InputPara.Lang_En"));
        if ("en".equalsIgnoreCase(ResourceManager.getLocale().toString())) {
            this.langTypeBox.setSelectedIndex(1);
        }
        this.serverIPBox = new JComboBox();
        this.serverIPBox.setEditable(false);
        this.collectorIPBox = new JComboBox();
        this.collectorIPBox.setEditable(false);
        List<String> ipSets = OSUtil.getLocalAllIps();
        for (String ipAddr : ipSets) {
            this.collectorIPBox.addItem(ipAddr);
            this.serverIPBox.addItem(ipAddr);
        }
        if (this.collectorIPBox.getItemCount() <= 0) {
            this.serverIPBox.addItem("");
            this.collectorIPBox.addItem("");
        }
        this.serverIPBox.setSelectedIndex(0);
        this.collectorIPBox.setSelectedIndex(0);
        this.installDirLabel = new JLabel(ResourceManager.getString("InputPara.INSTALLDIR"));
        this.pathInput = new JTextField();
        this.strPath = "";
        this.pathInput.setEditable(false);
        this.portLabel = new JLabel(ResourceManager.getString("InputPara.portInfo"));
        this.portInput = new JTextField();
        this.httpsPortLabel = new JLabel(ResourceManager.getString("InputPara.httpsport"));
        this.httpsPortTextField = new JTextField();
        this.httpsPortLabel.setVisible(false);
        this.httpsPortTextField.setVisible(false);
        LimitedDocument limitDocumentPort = new LimitedDocument(60);
        this.portInput.setDocument(limitDocumentPort);
        this.showServerIpMessage = new JLabel(ResourceManager.getString("InputPara.ServerIPInfoMsg", ContextUtil.getStrValueFromCtx("software.install.name")));
        this.selectPathButton = new JButton();
        this.selectPathButton.setText("...");
        this.selectPathButton.setFont(BaseStyle.DEFAULT_FONT);
        this.selectPathButton.setBackground(BaseStyle.BACKGROUND_COLOR);
        this.selectPathButton.setMnemonic('B');
        this.selectPathButton.addActionListener(this);
        UIUtil.setSize(this.langtypeLabel, ConstManager.DIMENSION_TEXTFIELD_MIN);
        UIUtil.setSize(this.serverIPLabel, ConstManager.DIMENSION_TEXTFIELD_MIN);
        UIUtil.setSize(this.collectorIPLabel, ConstManager.DIMENSION_TEXTFIELD_MIN);
        UIUtil.setSize(this.portLabel, ConstManager.DIMENSION_TEXTFIELD_MIN);
        UIUtil.setSize(this.langTypeBox, ConstManager.DIMENSION_TEXTFIELD);
        UIUtil.setSize(this.collectorIPBox, ConstManager.DIMENSION_TEXTFIELD);
        UIUtil.setSize(this.serverIPBox, ConstManager.DIMENSION_TEXTFIELD);
        UIUtil.setSize(this.installDirLabel, ConstManager.DIMENSION_TEXTFIELD_MIN);
        UIUtil.setSize(this.pathInput, ConstManager.DIMENSION_TEXTFIELD);
        UIUtil.setSize(this.portLabel, ConstManager.DIMENSION_TEXTFIELD_MIN);
        UIUtil.setSize(this.portInput, ConstManager.DIMENSION_TEXTFIELD);
        UIUtil.setSize(this.showServerIpMessage, ConstManager.DIMENSION_LABEL_MAXS);
        UIUtil.setSize(this.selectPathButton, ConstManager.DIMENSION_BUTTON_MIN);
        this.mainBox = Box.createVerticalBox();
        this.mainBox.setBorder(new EmptyBorder(15, 0, 10, 20));
        this.mainBox.add(Box.createVerticalStrut(INTEGER_VERTICALSTRUT));
        Box line = Box.createHorizontalBox();
        line.add(new JLabel(" "));
        this.mainBox.add(Box.createVerticalStrut(INTEGER_VERTICALSTRUT));
        this.mainBox.add(line);
        line = Box.createHorizontalBox();
        line.add(this.showServerIpMessage);
        this.mainBox.add(Box.createVerticalStrut(INTEGER_VERTICALSTRUT));
        this.mainBox.add(line);
        line = Box.createHorizontalBox();
        this.mainBox.add(Box.createVerticalStrut(INTEGER_VERTICALSTRUT));
        this.mainBox.add(line);
        line = Box.createHorizontalBox();
        this.mainBox.add(Box.createVerticalStrut(INTEGER_VERTICALSTRUT));
        line.add(this.serverIPLabel);
        line.add(this.serverIPBox);
        JLabel serverIPSpace = new JLabel();
        UIUtil.setSize(serverIPSpace, ConstManager.DIMENSION_BUTTON_MIN);
        line.add(serverIPSpace);
        this.mainBox.add(Box.createVerticalStrut(INTEGER_VERTICALSTRUT));
        this.mainBox.add(line);
        line = Box.createHorizontalBox();
        this.mainBox.add(Box.createVerticalStrut(INTEGER_VERTICALSTRUT));
        line.add(this.collectorIPLabel);
        line.add(this.collectorIPBox);
        JLabel collectorIPSpace = new JLabel();
        UIUtil.setSize(collectorIPSpace, ConstManager.DIMENSION_BUTTON_MIN);
        line.add(collectorIPSpace);
        this.mainBox.add(Box.createVerticalStrut(INTEGER_VERTICALSTRUT));
        this.mainBox.add(line);
        line = Box.createHorizontalBox();
        line.add(this.langtypeLabel);
        line.add(this.langTypeBox);
        JLabel langtypeSpace = new JLabel();
        UIUtil.setSize(langtypeSpace, ConstManager.DIMENSION_BUTTON_MIN);
        line.add(langtypeSpace);
        this.mainBox.add(Box.createVerticalStrut(INTEGER_VERTICALSTRUT));
        line = Box.createHorizontalBox();
        line.add(this.portLabel);
        line.add(this.portInput);
        JLabel portSpace = new JLabel();
        portSpace.setVisible(true);
        UIUtil.setSize(portSpace, ConstManager.DIMENSION_BUTTON_MIN);
        line.add(portSpace);
        this.mainBox.add(Box.createVerticalStrut(INTEGER_VERTICALSTRUT));
        this.mainBox.add(line);
        if (null == this.scene || "Independent Scene".equals(this.scene)) {
            line = Box.createHorizontalBox();
            line.add(this.httpsPortLabel);
            line.add(this.httpsPortTextField);
            portSpace = new JLabel();
            portSpace.setVisible(true);
            UIUtil.setSize(portSpace, ConstManager.DIMENSION_BUTTON_MIN);
            line.add(portSpace);
            UIUtil.setSize(this.httpsPortLabel, ConstManager.DIMENSION_TEXTFIELD_MIN);
            UIUtil.setSize(this.httpsPortTextField, ConstManager.DIMENSION_TEXTFIELD);
            this.mainBox.add(Box.createVerticalStrut(INTEGER_VERTICALSTRUT));
            this.mainBox.add(line);
            this.httpsPortLabel.setVisible(true);
            this.httpsPortTextField.setVisible(true);
            this.portLabel.setText(ResourceManager.getString("InputPara.httpport"));
            this.portInput.setToolTipText(ResourceManager.getString("InputPara.TipPortHttp"));
            this.httpsPortTextField.setToolTipText(ResourceManager.getString("InputPara.TipPortHttps"));
        } else {
            this.portLabel.setText(ResourceManager.getString("InputPara.portInfo"));
            this.portInput.setToolTipText(ResourceManager.getString("InputPara.TipPort"));
        }
        this.pathInput.setToolTipText(ResourceManager.getString("InputPara.TipDir") + ResourceManager.getString("InputPara.DirectoryMustBeCharAndNum"));
        this.collectorIPBox.setToolTipText(ResourceManager.getString("InputPara.TipCollectorIP"));
        this.serverIPBox.setToolTipText(ResourceManager.getString("InputPara.TipIP"));
        this.langTypeBox.setToolTipText(ResourceManager.getString("InputPara.TipLang"));
        line = Box.createHorizontalBox();
        this.mainBox.add(Box.createVerticalStrut(INTEGER_VERTICALSTRUT));
        this.mainBox.add(line);
        line = Box.createHorizontalBox();
        line.add(this.installDirLabel);
        line.add(this.pathInput);
        line.add(this.selectPathButton);
        this.mainBox.add(Box.createVerticalStrut(INTEGER_VERTICALSTRUT));
        this.mainBox.add(line);
        this.pathInput.setText(this.strPath);
        this.portInput.setText(this.strPort);
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainBox, "Center");
        if (null != this.scene) {
            if ("Integrated Scene".equals(this.scene)) {
                String strCurrIP;
                this.collectorIPBox.setEditable(false);
                this.serverIPBox.setEditable(false);
                String esightIp = EsightEnvMgr.getInstance().getValue("@{ENT_HOSTIP}");
                String sesightPath = System.getProperty("ENT_ROOT");
                if ((null == sesightPath || sesightPath.trim().isEmpty() || !new File(sesightPath).exists()) && null != (sesightPath = ContextUtil.getStrValueFromCtx("esight.install.rootpath"))) {
                    sesightPath = sesightPath.replace("/", "\\");
                }
                if (new File(strCurrIP = sesightPath + "/AppBase/etc/ipchange/ipchange.cfg").exists()) {
                    Properties pCurrIP = FileUtil.pass2PropertiesByPath(strCurrIP);
                    esightIp = pCurrIP.getProperty("current_ip").trim();
                }
                this.strPath = sesightPath + File.separator + ContextUtil.getStrValueFromCtx("software.install.name");
                this.pathInput.setText(this.strPath);
                this.portInput.setText(EsightEnvMgr.getInstance().getValue("@{ENT_PORT}"));
                boolean enabledFlag = false;
                this.pathInput.setEnabled(enabledFlag);
                this.selectPathButton.setEnabled(enabledFlag);
                this.portInput.setEnabled(enabledFlag);
                boolean isSelect = this.setIPBoxSelected(esightIp, enabledFlag);
                if (!isSelect) {
                    String msg = ResourceManager.getString("LEGO.IP.MODIFY");
                    OptionPane.showErrorDialog(msg);
                    this.closeWizardDialog();
                }
            } else if ("Independent Scene".equals(this.scene)) {
                String str = ContextUtil.getStrValueFromCtx("lego.base.fuseWithEsight");
                if (OSUtil.isWindows()) {
                    if (null != str && str.equals("fuseWithEsight")) {
                        String sPath = ContextUtil.getStrValueFromCtx("lego.base.eSightPath") + File.separator + "LogCenter";
                        this.pathInput.setText(sPath);
                        ContextUtil.saveSearalizeValue2Ctx("lego.base.logcenter.root", sPath);
                    } else {
                        this.pathInput.setText(this.defaultWindowpath);
                    }
                    this.strPath = this.defaultWindowpath;
                }
                this.serverIPBox.setEnabled(true);
                this.collectorIPBox.setEnabled(true);
                this.portInput.setText(String.valueOf(IConstant.INDEPENDENT_HTTP_PORT));
                this.httpsPortTextField.setText(String.valueOf(IConstant.INDEPENDENT_HTTPS_PORT));
            } else {
                OptionPane.showErrorDialog("Unknow install scene.");
            }
        }
        if ("update".equals(this.ctx.getInstallMode())) {
            this.serverIPBox.setEnabled(false);
            this.collectorIPBox.setEnabled(false);
            this.portInput.setEnabled(false);
            this.httpsPortTextField.setEnabled(false);
            this.pathInput.setEnabled(false);
            this.selectPathButton.setEnabled(false);
        }
    }

    private boolean resetCheckPortSate() {
        boolean result = true;
        ArrayList<JTextField> textFields = new ArrayList<JTextField>();
        ArrayList<JLabel> labels = new ArrayList<JLabel>();
        textFields.add(this.portInput);
        labels.add(this.portLabel);
        String httpPortStr = this.portInput.getText().trim();
        if (HalfFullCheckUtil.isnInvalid4PortFullChar(httpPortStr)) {
            String msg = ResourceManager.getString("LEGO.SET.PORT.ERRORFORMAT", httpPortStr);
            OptionPane.showInfoDialog(msg);
            return false;
        }
        if (!PortCheckUtil.isInvalid4PortInput(httpPortStr)) {
            String msg = ResourceManager.getString("LEGO.SET.PORT.ERRORFORMAT", httpPortStr);
            OptionPane.showInfoDialog(msg);
            return false;
        }
        if (!PortCheckUtil.isInvalid4PortRang(httpPortStr)) {
            String msg = ResourceManager.getString("LEGO.SET.PORT.ERRORHTTP");
            OptionPane.showInfoDialog(msg);
            return false;
        }
        textFields.add(this.httpsPortTextField);
        labels.add(this.httpsPortLabel);
        String httpsPortStr = this.httpsPortTextField.getText().trim();
        if (!PortCheckUtil.isInvalid4PortInput(httpsPortStr)) {
            String msg = ResourceManager.getString("LEGO.SET.PORT.ERRORFORMAT", httpsPortStr);
            OptionPane.showInfoDialog(msg);
            return false;
        }
        if (!PortCheckUtil.isInvalid4PortRang(httpsPortStr)) {
            String msg = ResourceManager.getString("LEGO.SET.PORT.ERRORHTTPS");
            OptionPane.showInfoDialog(msg);
            return false;
        }
        for (int i = 0; i < textFields.size(); ++i) {
            JTextField filed = (JTextField)textFields.get(i);
            String str = ContextUtil.getStrValueFromCtx("lego.base.fuseWithEsight");
            if (null != str && !str.isEmpty() || InputParaCard.isNotUsePort(INSTALL_FILES_BASE_PATH + "etc/config/conf/vsm_port.txt", filed.getText())) continue;
            ((JLabel)labels.get(i)).setForeground(Color.RED);
            String[] regMgrParm = new String[]{filed.getText(), ContextUtil.getStrValueFromCtx("software.install.name")};
            OptionPane.showInfoDialog(ResourceManager.getString("VSM.CHECK.HTTS.HTTPS.PORT", regMgrParm));
            return false;
        }
        String[] ports = new String[]{this.portInput.getText(), this.httpsPortTextField.getText()};
        boolean portRepeat = PortCheckUtil.checkPortRepeat(ports);
        if (portRepeat) {
            String msg = ResourceManager.getString("LEGO.PORT.REPEAT");
            OptionPane.showInfoDialog(msg);
            return false;
        }
        if (OSUtil.isWindows()) {
            List<Program> lPro = null;
            if ("Integrated Scene".equals(this.scene)) {
                lPro = ProgramUtil.getProgramListTakePortIllegally("integrate", false);
            } else {
                if (!this.checkHttpHttpsPort().booleanValue()) {
                    return false;
                }
                lPro = ProgramUtil.getProgramListTakePortIllegally("server", false);
            }
            if (!lPro.isEmpty()) {
                Iterator<Program> it = lPro.iterator();
                StringBuffer pList = new StringBuffer();
                if (it.hasNext()) {
                    Program pIt = it.next();
                    List<Integer> iPort = pIt.getPorts();
                    pList.append(iPort.get(0));
                    pList.append(',');
                }
                String msg = ResourceManager.getString("LEGO.PORT.USED", pList.substring(0, pList.length() - 1));
                OptionPane.showInfoDialog(msg);
                return false;
            }
        }
        return result;
    }

    private Boolean checkHttpHttpsPort() {
        Program pHttp = ProgramUtil.getProgramByPort(Integer.parseInt(this.portInput.getText()));
        StringBuffer portHttp = new StringBuffer();
        if (null != pHttp) {
            List<Integer> iPort = pHttp.getPorts();
            portHttp.append(iPort.get(0));
            portHttp.append(',');
            String msg = ResourceManager.getString("LEGO.PORT.USED", portHttp.substring(0, portHttp.length() - 1));
            OptionPane.showInfoDialog(msg);
            return false;
        }
        Program pHttps = ProgramUtil.getProgramByPort(Integer.parseInt(this.httpsPortTextField.getText()));
        StringBuffer portHttps = new StringBuffer();
        if (null != pHttps) {
            List<Integer> iPort = pHttps.getPorts();
            portHttps.append(iPort.get(0));
            portHttps.append(',');
            String msg = ResourceManager.getString("LEGO.PORT.USED", portHttps.substring(0, portHttps.length() - 1));
            OptionPane.showInfoDialog(msg);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isNotUsePort(String portFile, String http) {
        FileInputStream fileStreamIn;
        InputStreamReader fileReader;
        BufferedReader br;
        block10: {
            boolean bl;
            block9: {
                boolean bl2;
                block8: {
                    String reader = "";
                    String port = "";
                    br = null;
                    fileReader = null;
                    fileStreamIn = null;
                    try {
                        fileStreamIn = new FileInputStream(new File(portFile));
                        fileReader = new InputStreamReader((InputStream)fileStreamIn, "utf-8");
                        br = new BufferedReader(fileReader);
                        while ((reader = br.readLine()) != null) {
                            port = reader.substring(reader.indexOf("=") + 1);
                            if (port.equals(http) && !"".equals(http)) {
                                bl2 = false;
                                StreamProcUtil.close(br);
                                break block8;
                            }
                            if (!port.equals(http) || "".equals(http)) continue;
                            bl = false;
                            StreamProcUtil.close(br);
                            break block9;
                        }
                        StreamProcUtil.close(br);
                        break block10;
                    }
                    catch (IOException e) {
                        LOGGER.error("isNotUsePort occurs error.", (Throwable)e);
                        return true;
                    }
                }
                StreamProcUtil.close(fileReader);
                StreamProcUtil.close(fileStreamIn);
                return bl2;
            }
            StreamProcUtil.close(fileReader);
            StreamProcUtil.close(fileStreamIn);
            return bl;
        }
        StreamProcUtil.close(fileReader);
        StreamProcUtil.close(fileStreamIn);
        return true;
        finally {
            StreamProcUtil.close(br);
            StreamProcUtil.close(fileReader);
            StreamProcUtil.close(fileStreamIn);
        }
    }

    public static boolean checkPortUsed(int port) {
        try {
            ServerSocket ss = new ServerSocket(port);
            ss.close();
        }
        catch (IOException e) {
            return true;
        }
        return false;
    }

    private boolean setIPBoxSelected(String ip, boolean enabled) {
        boolean isSelect = false;
        if (null == ip || ip.isEmpty()) {
            return true;
        }
        int size = this.collectorIPBox.getItemCount();
        Object obj = null;
        for (int i = 0; i < size; ++i) {
            obj = this.collectorIPBox.getItemAt(i);
            if (!ip.equals(String.valueOf(obj))) continue;
            this.collectorIPBox.setSelectedIndex(i);
            isSelect = true;
            break;
        }
        if (!enabled) {
            this.collectorIPBox.setEnabled(false);
        }
        if (!isSelect) {
            this.collectorIPBox.setEnabled(true);
        }
        return isSelect;
    }

    private void getInfoFiles() {
        if (!EnvCheckUtil.checkIfFirstInstall(this.strPath)) {
            File file = new File(".");
            String installPath = null;
            try {
                installPath = file.getCanonicalPath();
            }
            catch (IOException e) {
                LOGGER.error("get path error");
            }
            String fromFile = this.strPath + "\\uninstall\\engineering\\conf\\nodeMgrInfo.cfg";
            String toFile = installPath + "\\engineering\\conf\\nodeMgrInfo.cfg";
            FileUtil.copyFile(fromFile, toFile);
            fromFile = this.strPath + "\\uninstall\\engineering\\conf\\config\\DefaultValues.properties";
            toFile = installPath + "\\engineering\\conf\\config\\DefaultValues.properties";
            FileUtil.copyFile(fromFile, toFile);
            fromFile = this.strPath + "\\uninstall\\engineering\\conf\\datamodelDB\\datamodel.data";
            toFile = System.getProperty("SystemDrive") + "\\engineering_framework\\engineering\\conf\\datamodelDB\\datamodel.data";
            FileUtil.copyFile(fromFile, toFile);
        }
    }

    @Override
    protected boolean isValid(WizardDialog.Navigation navigation) {
        return false;
    }

    @Override
    protected void process(WizardDialog.Navigation navigation) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LOGGER.debug("choice database and connection");
        JButton btnSrc = (JButton)e.getSource();
        if (btnSrc == this.selectPathButton) {
            if (null == this.chooser) {
                this.chooser = new JFileChooser(new File(this.strPath));
            }
            this.chooser.setCurrentDirectory(new File(this.strPath));
            this.chooser.setFileSelectionMode(1);
            int retValue1 = this.chooser.showOpenDialog(this);
            String tepstr = "";
            String osName = System.getProperty("os.name");
            osName = Normalizer.normalize(osName, Normalizer.Form.NFKC);
            tepstr = osName.contains("Windows") ? this.defaultWindowpath.substring(this.defaultWindowpath.lastIndexOf("\\"), this.defaultWindowpath.length()) : this.defaultLinuxPath.substring(this.defaultLinuxPath.lastIndexOf("/"), this.defaultLinuxPath.length());
            if (retValue1 == 0) {
                String path = this.chooser.getSelectedFile().getPath();
                if (56 < path.length()) {
                    String msg = ResourceManager.getString("InputPara.DirectoryMustBeCharAndNum");
                    OptionPane.showErrorDialog(msg);
                } else {
                    if (path.endsWith("\\") || path.endsWith("/")) {
                        path = path.substring(0, path.length() - 1);
                    }
                    this.pathInput.setText(path + tepstr);
                }
            }
        }
    }

    @Override
    public String getSummary() {
        String lineWrap = CommonUtil.WRAP_CHAR;
        String summary = "[" + ResourceManager.getString("InputPara.Title") + "]" + lineWrap;
        summary = summary + ResourceManager.getString("InputPara.ServerIP") + this.serverIPBox.getSelectedItem() + lineWrap;
        summary = summary + ResourceManager.getString("InputPara.collectorIP") + this.collectorIPBox.getSelectedItem() + lineWrap;
        summary = summary + ResourceManager.getString("InputPara.httpport") + this.portInput.getText() + lineWrap;
        if ("Independent Scene".equals(this.scene)) {
            String httpsPort = this.httpsPortTextField.getText();
            if (httpsPort == null || httpsPort.trim().isEmpty()) {
                httpsPort = IConstant.INDEPENDENT_HTTPS_PORT.toString();
            }
            summary = summary + ResourceManager.getString("InputPara.httpsport") + httpsPort + lineWrap;
        }
        String tempstr = new File(this.pathInput.getText()).getPath();
        summary = summary + ResourceManager.getString("InputPara.INSTALLDIR") + tempstr + lineWrap;
        if ("Integrated Scene".equals(this.scene)) {
            int minSpace = Integer.parseInt(DefaultValueManager.getInstance().getDefaultValue("MinFileSpace"));
            summary = summary + ResourceManager.getString("InputPara.NeedSpace") + minSpace + " MB" + lineWrap;
        }
        return summary;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean saveParameters() {
        try {
            String eLogInstalledFlagFilePath;
            File eLogInstalledFile;
            String basePath = FileUtil.parseCapitalDisk(this.pathInput.getText());
            String collectorIP = this.collectorIPBox.getSelectedItem().toString();
            String serverIP = this.serverIPBox.getSelectedItem().toString();
            String httpPort = this.portInput.getText();
            String httpsPort = this.httpsPortTextField.getText();
            if (httpsPort == null || httpsPort.trim().isEmpty()) {
                httpsPort = String.valueOf(IConstant.INDEPENDENT_HTTPS_PORT);
            }
            if ("Integrated Scene".equals(this.scene)) {
                httpPort = IConstant.INTEGRATED_HTTP_PORT.toString();
                httpsPort = IConstant.INTEGRATED_HTTPS_PORT.toString();
                ContextUtil.saveSearalizeValue2Ctx("esight.install.rootpath", this.esightPath);
            }
            ContextUtil.saveSearalizeValue2Ctx("vsm.install.system.info.env", "x64");
            ContextUtil.saveSearalizeValue2Ctx("vsm.install.index.static.id", String.valueOf(UUID.randomUUID()));
            List<String> ipSets = OSUtil.getLocalAllIps();
            StringBuffer namingIps = new StringBuffer();
            for (String oneIp : ipSets) {
                namingIps.append("<IP TYPE=\"server\">");
                namingIps.append(oneIp);
                namingIps.append("</IP>");
                namingIps.append("\r\t");
            }
            namingIps.append("<IP TYPE=\"collector\">");
            namingIps.append(collectorIP);
            namingIps.append("</IP>");
            ContextUtil.saveAntValue2Ctx("lego.base.allIpAddress", String.valueOf(namingIps));
            ContextUtil.saveSearalizeValue2Ctx("lego.base.installIpAddress", collectorIP);
            ContextUtil.saveSearalizeValue2Ctx("lego.base.serverIpAddress", serverIP);
            LOGGER.info("Save server IP: {}", (Object)serverIP);
            LOGGER.info("Save collector IP: {}", (Object)collectorIP);
            ContextUtil.saveSearalizeValue2Ctx("lego.port.http", httpPort);
            ContextUtil.saveSearalizeValue2Ctx("lego.port.https", httpsPort);
            ContextUtil.saveSearalizeValue2Ctx("lego.base.installpath", basePath);
            ContextUtil.saveSearalizeValue2Ctx("lego.base.installpath_linux", basePath.replace("\\", "/"));
            ContextUtil.saveSearalizeValue2Ctx("is.history.data.reused", false);
            String haOrNot = ContextUtil.getStrValueFromCtx("vsm.install.mode.ha");
            LOGGER.info("haOrNot:" + haOrNot);
            boolean isReuseHistoryDataScene = false;
            if ("HA".equalsIgnoreCase(haOrNot) && !(eLogInstalledFile = new File(eLogInstalledFlagFilePath = basePath + File.separator + ELOGINSTALLEDXMLFILE)).exists()) {
                isReuseHistoryDataScene = true;
            }
            if (null == haOrNot || "NORMAL".equalsIgnoreCase(haOrNot)) {
                isReuseHistoryDataScene = true;
            }
            if (!isReuseHistoryDataScene) {
                ContextUtil.saveSearalizeValue2Ctx("is.history.data.reused", false);
                return true;
            }
            File f = new File(basePath.replace("\\", "/"));
            File[] files = f.listFiles();
            if (files == null) return true;
            if (0 == files.length) return true;
            this.jdugeVersionAndBrandIsEqual();
            String msg = ResourceManager.getString("InputPara.Use.HistoryData");
            int result = OptionPane.showWarnConfirmDialog(this.getWizardDialog(), msg);
            if (0 == result) {
                ContextLoader.loadPreviousVersionConetext();
                LOGGER.debug("The history data will be reused");
                ContextUtil.saveSearalizeValue2Ctx("is.history.data.reused", true);
                return true;
            }
            ContextUtil.saveSearalizeValue2Ctx("is.history.data.reused", false);
            String msgDirNotEmpty = ResourceManager.getString("InputPara.Dirty");
            OptionPane.showErrorDialog(msgDirNotEmpty);
            return false;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("saveParameters occurs error.", (Throwable)e);
            return false;
        }
    }

    private boolean jdugeVersionAndBrandIsEqual() {
        String previousBrand;
        Version currentVersion = this.parseCurrentVersion();
        Version previousVersion = this.parsePreviousVersion();
        String currentBrand = null == currentVersion ? null : currentVersion.getVersionBrand();
        String string = previousBrand = null == previousVersion ? null : previousVersion.getVersionBrand();
        if (null != currentBrand && null != previousBrand && currentBrand.equalsIgnoreCase(previousBrand)) {
            String subPreviousVersion;
            String currentVersionNum = currentVersion.getVersionNum();
            String previousVersionNum = previousVersion.getVersionNum();
            String subCurrentVersion = currentVersionNum.substring(0, currentVersionNum.length() - 2);
            if (subCurrentVersion.equalsIgnoreCase(subPreviousVersion = previousVersionNum.substring(0, previousVersionNum.length() - 2))) {
                return true;
            }
        }
        return false;
    }

    private Version parsePreviousVersion() {
        String previousVersionPath = System.getProperty("user.home");
        previousVersionPath = previousVersionPath + File.separator + "logcenter/version.txt";
        File versionFile = null;
        versionFile = new File(previousVersionPath);
        if (!versionFile.exists()) {
            LOGGER.warn("version file does not exist.");
            return null;
        }
        Version version = this.getVersionFromFile(versionFile);
        return version;
    }

    private Version parseCurrentVersion() {
        String installBasePath = ContextUtil.getStrValueFromCtx("lego.base.path");
        String currentVersionPath = installBasePath + CURRENT_VERSION_PATH;
        File versionFile = null;
        versionFile = new File(currentVersionPath);
        if (!versionFile.exists()) {
            LOGGER.warn("version file does not exist.");
            return null;
        }
        Version version = this.getVersionFromFile(versionFile);
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Version getVersionFromFile(File f) {
        Version version = new Version();
        if (!f.exists()) {
            return null;
        }
        BufferedReader in = null;
        InputStreamReader isr = null;
        FileInputStream fis = null;
        String line = null;
        String tmp = null;
        try {
            fis = new FileInputStream(f);
            isr = new InputStreamReader((InputStream)fis, "UTF-8");
            in = new BufferedReader(isr);
            while ((line = in.readLine()) != null) {
                if (line.indexOf(VERSION_PREFIX) > -1) {
                    tmp = line.substring(line.indexOf(VERSION_PREFIX) + VERSION_PREFIX.length());
                    version.setVersionNum(tmp);
                    continue;
                }
                if (line.indexOf(VERSION_BRAND_PREFIX) > -1) {
                    tmp = line.substring(line.indexOf(VERSION_BRAND_PREFIX) + VERSION_BRAND_PREFIX.length());
                    if (StringUtils.isNotEmpty((CharSequence)tmp)) {
                        tmp = tmp.trim();
                        tmp = tmp.split("[ ]")[0];
                    }
                    version.setVersionBrand(tmp);
                    continue;
                }
                if (line.indexOf(VERSION_TIME_PREFIX) <= -1) continue;
                tmp = line.substring(line.indexOf(VERSION_TIME_PREFIX) + VERSION_TIME_PREFIX.length());
                version.setReleaseTime(tmp);
            }
            StreamProcUtil.close(in);
        }
        catch (RuntimeException e) {
            throw e;
            catch (Exception e2) {
                LOGGER.error("parse version file occurs error: ", (Throwable)e2);
                return version;
            }
        }
        StreamProcUtil.close(isr);
        StreamProcUtil.close(fis);
        return version;
        finally {
            StreamProcUtil.close(in);
            StreamProcUtil.close(isr);
            StreamProcUtil.close(fis);
        }
    }
}

