/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ui.card.install;

import com.huawei.elog.base.BaseStyle;
import com.huawei.elog.base.model.WizardDialog;
import com.huawei.elog.check.EnvCheckerContainer;
import com.huawei.elog.ui.DoCostTimeWorkDlg;
import com.huawei.elog.ui.panel.ConclusionInfoPanel;
import com.huawei.elog.ui.panel.StyleTable;
import com.huawei.elog.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IntroductionCard
extends WizardDialog.Card {
    private static final long serialVersionUID = 4508830599610349619L;
    private static IntroductionCard instance = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(IntroductionCard.class);
    private final Box box = Box.createVerticalBox();
    private final Box topline = Box.createHorizontalBox();
    private final JScrollPane scrollPane = new JScrollPane();
    private StyleTable resultTable = null;
    private JScrollPane scrollPane1 = null;
    private ConclusionInfoPanel conclusionInfo = null;
    private JLabel infoLabel = null;

    private IntroductionCard() {
        super(null, WizardDialog.Navigation.Next, WizardDialog.Navigation.Cancel);
        this.initComps();
        this.setNextButtonEnable(false);
        this.setNavigationButtonsStatus(true, WizardDialog.Navigation.Cancel);
    }

    public static IntroductionCard getInstance() {
        if (null == instance) {
            instance = new IntroductionCard();
        }
        return instance;
    }

    @Override
    public boolean doCostTimeWork() {
        return this.saveParameters();
    }

    private boolean saveParameters() {
        return true;
    }

    @Override
    protected WizardDialog.Card getNextCard() {
        DoCostTimeWorkDlg dlg = new DoCostTimeWorkDlg(IntroductionCard.getInstance(), ResourceManager.getString("InputPara.hint"), ResourceManager.getString("InputPara.InitBeforeInstall"), "checkingThread");
        dlg.display();
        if (!dlg.isResult()) {
            return null;
        }
        return this.getNextCardBase();
    }

    private void initComps() {
        LOGGER.debug("IntroductionCard init comps start.");
        JLabel pageTitle = new JLabel(ResourceManager.getString("COMMON.TXT.MENUE_INTRODUCTION"));
        pageTitle.setBounds(20, 15, 300, 20);
        pageTitle.setFont(BaseStyle.PAGE_TITLE_FONT);
        pageTitle.setFocusable(false);
        this.add(pageTitle);
        JPanel centerPanel = new JPanel();
        centerPanel.setBounds(20, 55, 535, 180);
        this.add(centerPanel);
        centerPanel.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.infoLabel = new JLabel();
        this.infoLabel.setVisible(false);
        centerPanel.add((Component)this.infoLabel, "South");
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        centerPanel.add(this.scrollPane);
        this.showEnvCheck();
        this.conclusionInfo.updateTable();
        LOGGER.debug("IntroductionCard init comps end.");
    }

    private void showEnvCheck() {
        EnvCheckerContainer ecc = EnvCheckerContainer.getInstance();
        ecc.init();
        String[] headNames = new String[]{ResourceManager.getString("EnvCheck.CheckItem"), ResourceManager.getString("EnvCheck.CheckResult"), ResourceManager.getString("EnvCheck.Affect"), ResourceManager.getString("EnvCheck.Want")};
        ecc.setColumnNames(headNames);
        this.resultTable = new StyleTable((TableModel)ecc, ecc);
        this.resultTable.setAutoResizeMode(1);
        this.resultTable.setRowSelectionAllowed(false);
        this.resultTable.setColumnSelectionAllowed(false);
        this.resultTable.setPreferredScrollableViewportSize(new Dimension(200, 120));
        this.resultTable.setRowHeight(30);
        this.resultTable.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                Point point = e.getPoint();
                int x = IntroductionCard.this.resultTable.rowAtPoint(point);
                int y = IntroductionCard.this.resultTable.columnAtPoint(point);
                Object tip = IntroductionCard.this.resultTable.getValueAt(x, y);
                if (tip != null) {
                    IntroductionCard.this.resultTable.setToolTipText(tip.toString());
                }
            }
        });
        StyleTable.adjustColumnPreferredWidths(this.resultTable);
        StyleTable.adjustHeader(this.resultTable);
        StyleTable.adjustRowPreferredWidths(this.resultTable);
        this.scrollPane1 = new JScrollPane(this.resultTable);
        this.scrollPane1.getViewport().setBackground(Color.WHITE);
        this.conclusionInfo = new ConclusionInfoPanel(ecc, this.resultTable, this.box, this);
        this.topline.add(this.conclusionInfo);
        this.topline.add(new JLabel("  "));
        this.scrollPane1.setVisible(true);
        this.box.add(this.topline);
        this.box.add(this.scrollPane1);
        this.scrollPane.getViewport().add(this.box);
    }

    public void setUpgardeInfoStatus(boolean show) {
        this.infoLabel.setVisible(show);
    }

    private void setNextButtonEnable(boolean enable) {
        JButton button = this.getNavigationButtons().get((Object)WizardDialog.Navigation.Next);
        button.setEnabled(enable);
    }

    @Override
    protected boolean isValid(WizardDialog.Navigation navigation) {
        return false;
    }

    @Override
    protected void process(WizardDialog.Navigation navigation) {
    }

    @Override
    public String getSummary() {
        return null;
    }
}

