/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ui.card.install;

import com.huawei.elog.CollectorHelper;
import com.huawei.elog.base.BaseStyle;
import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.model.WizardDialog;
import com.huawei.elog.ui.DoCostTimeWorkDlg;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.OSUtil;
import com.huawei.elog.util.PropertyManager;
import com.huawei.elog.util.ResourceManager;
import com.huawei.elog.util.ServiceUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogParaCard
extends WizardDialog.Card
implements ActionListener {
    private static final long serialVersionUID = 4752168476638799752L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LogParaCard.class);
    private static LogParaCard instance = null;
    private static boolean jcBoxstatus = true;
    private static JCheckBox jcbElog;
    private transient InstallContext installConext = InstallContext.getInstance();
    private String reuseHistoryDataOrNot = ContextUtil.getStrValueFromCtx("is.history.data.reused");
    private StringBuffer checkPathStr = new StringBuffer();
    private JButton conButton;
    private JFileChooser chooser;

    private LogParaCard() {
        super(null, new WizardDialog.Navigation[0]);
        this.initComps();
        this.setNavigationButtonsStatus(true, WizardDialog.Navigation.Previous, WizardDialog.Navigation.Next, WizardDialog.Navigation.Cancel);
    }

    public static boolean isJcBoxstatus() {
        return jcBoxstatus;
    }

    public void setJcBoxstatus(boolean jcBoxstatus) {
        LogParaCard.setJcBoxstatusValue(jcBoxstatus);
    }

    public static void setJcBoxstatusValue(boolean jcaBoxstatus) {
        jcBoxstatus = jcaBoxstatus;
    }

    public static LogParaCard getInstance() {
        if (null == instance) {
            instance = new LogParaCard();
        }
        return instance;
    }

    @Override
    protected WizardDialog.Card getNextCard() {
        DoCostTimeWorkDlg dlg = new DoCostTimeWorkDlg(LogParaCard.getInstance(), ResourceManager.getString("InputPara.hint"), ResourceManager.getString("LogPara.InitBeforeInstall"), "checkingThread");
        dlg.display();
        LOGGER.info("dlg.isResult():" + dlg.isResult());
        if (!dlg.isResult()) {
            return null;
        }
        return this.getNextCardBase();
    }

    @Override
    public boolean doCostTimeWork() {
        try {
            String isCollectorSelected = "true";
            LOGGER.info("collector.install.is.or.not:" + isCollectorSelected);
            isCollectorSelected = jcbElog.isSelected() ? "true" : "false";
            if (isCollectorSelected.endsWith("true") && !this.installConext.getEnvirments().isSystemInstalled()) {
                if (!this.checkValid()) {
                    return false;
                }
                CollectorHelper.parseClStoreConfig();
            }
            if (OSUtil.isWindows() && !this.installConext.getEnvirments().isSystemInstalled() && this.isServerExist()) {
                int res = OptionPane.showWarnConfirmDialog(this.getContainer(), ResourceManager.getString("VSM.COLLECTOR.REINSTALL.COMFIRM", ResourceManager.getString("vsm.elog.collector.name")));
                if (0 == res) {
                    jcbElog.setSelected(true);
                    isCollectorSelected = "true";
                } else {
                    jcbElog.setSelected(false);
                    isCollectorSelected = "false";
                }
            }
            CollectorHelper.parsePerformanceConf();
            LOGGER.info("collector.install.is.or.not:" + isCollectorSelected);
            ContextUtil.saveSearalizeValue2Ctx("collector.install.is.or.not", isCollectorSelected);
        }
        catch (Exception e) {
            LOGGER.error("check input occurs error.", (Throwable)e);
            return false;
        }
        return super.doCostTimeWork();
    }

    public boolean isServerExist() {
        String serverName = PropertyManager.getProValue("COLLECTOR.ELOG.ELOGSERVER.SERVICENAME");
        if (serverName != null) {
            return ServiceUtil.isServiceExist(serverName);
        }
        return false;
    }

    public boolean checkValid() {
        if (!OSUtil.isWindows() && !this.checkPathStr.toString().isEmpty()) {
            String[] st = this.checkPathStr.toString().split("\n");
            if (st.length == 1 && st[0].endsWith("DumpedData")) {
                int optionPaneValue = OptionPane.showInfoConfirmDialog(ResourceManager.getString("Dump.Samedisk.err"));
                if (optionPaneValue != 0) {
                    this.checkPathStr.setLength(0);
                    return false;
                }
            } else if (st.length == 2) {
                int optionPaneValue = OptionPane.showInfoConfirmDialog(ResourceManager.getString("Onlie.Samedisk.err"));
                int optionPaneValues = OptionPane.showInfoConfirmDialog(ResourceManager.getString("Dump.Samedisk.err"));
                if (optionPaneValue != 0 || optionPaneValues != 0) {
                    this.checkPathStr.setLength(0);
                    return false;
                }
            } else {
                int optionPaneValue = OptionPane.showInfoConfirmDialog(ResourceManager.getString("Onlie.Samedisk.err"));
                if (optionPaneValue != 0) {
                    this.checkPathStr.setLength(0);
                    return false;
                }
            }
            this.checkPathStr.setLength(0);
        }
        return true;
    }

    private void initComps() {
        String haMode;
        LOGGER.debug("init comps start...");
        this.setLayout(null);
        JLabel jl0 = new JLabel(ResourceManager.getString("vsm.extend.elog.local.ip.title"));
        jl0.setBounds(20, 15, 300, 20);
        jl0.setFont(BaseStyle.PAGE_TITLE_FONT);
        this.add(jl0);
        String eLogStr = ResourceManager.getString("vsm.install.eLog.collector");
        this.setJcbElog(new JCheckBox(eLogStr));
        jcbElog.setSelected(true);
        jcbElog.setBounds(20, 125, 300, 20);
        jcbElog.addActionListener(this);
        String installCollector = ContextUtil.getStrValueFromCtx("collector.install.is.or.not");
        if (this.installConext.getEnvirments().isSystemInstalled() && installCollector.equalsIgnoreCase("true")) {
            jcbElog.setSelected(true);
            jcbElog.setEnabled(false);
        }
        if ("true".equalsIgnoreCase(this.reuseHistoryDataOrNot)) {
            if (installCollector.equalsIgnoreCase("true")) {
                jcbElog.setSelected(true);
                jcbElog.setEnabled(false);
            } else {
                jcbElog.setSelected(false);
                jcbElog.setEnabled(false);
            }
        }
        if (this.installConext.getEnvirments().isSystemInstalled() && installCollector.equalsIgnoreCase("false")) {
            jcbElog.setSelected(false);
            jcbElog.setEnabled(false);
        }
        if (this.installConext.getEnvirments().isSystemInstalled() && installCollector.isEmpty()) {
            LOGGER.debug("installCollector = " + installCollector + "is empty.", (Object)"assembleCard");
            LOGGER.debug("Software ends, please check.", (Object)"assembleCard");
        }
        if ("true".equalsIgnoreCase(this.reuseHistoryDataOrNot) && installCollector.isEmpty()) {
            LOGGER.debug("installCollector = " + installCollector + "is empty.", (Object)"assembleCard");
            LOGGER.debug("Software ends, please check.", (Object)"assembleCard");
        }
        if (null != (haMode = ContextUtil.getStrValueFromCtx("vsm.install.mode.ha")) && "HA".equals(haMode)) {
            this.setJcBoxstatus(false);
            jcbElog.setSelected(false);
            jcbElog.setEnabled(false);
        }
        this.add(jcbElog);
        LOGGER.debug("init comps end...");
    }

    @Override
    protected boolean isValid(WizardDialog.Navigation navigation) {
        return false;
    }

    @Override
    protected void process(WizardDialog.Navigation navigation) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.conButton) {
            String path;
            this.chooser.setFileSelectionMode(1);
            int retValue1 = this.chooser.showOpenDialog(this);
            if (retValue1 == 0 && (path = this.chooser.getSelectedFile().getPath()).endsWith("\\")) {
                path = path.substring(0, path.length() - 1);
                LOGGER.info("Path: ", (Object)path.substring(path.lastIndexOf("\\")));
            }
        }
    }

    @Override
    public String getSummary() {
        return null;
    }

    public void setJcbElog(JCheckBox jcbElog) {
        LogParaCard.setJcbElogValue(jcbElog);
    }

    public static void setJcbElogValue(JCheckBox jcbElogTemp) {
        jcbElog = jcbElogTemp;
    }
}

