/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ui.card.install;

import com.huawei.elog.base.BaseStyle;
import com.huawei.elog.base.model.WizardDialog;
import com.huawei.elog.common.StreamProcUtil;
import com.huawei.elog.ui.DoCostTimeWorkDlg;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.PropertyManager;
import com.huawei.elog.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReadCard
extends WizardDialog.Card {
    private static final long serialVersionUID = 4508830599610349619L;
    private static ReadCard instance = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadCard.class);
    private JRadioButton radioBtnAgree = new JRadioButton();
    private JRadioButton radioBtnDisagree = new JRadioButton();

    private ReadCard() {
        super(null, WizardDialog.Navigation.Next, WizardDialog.Navigation.Cancel);
        this.initComps();
        this.setNextButtonEnable(false);
        this.setNavigationButtonsStatus(true, WizardDialog.Navigation.Cancel);
    }

    public static ReadCard getInstance() {
        if (null == instance) {
            instance = new ReadCard();
        }
        return instance;
    }

    @Override
    protected WizardDialog.Card getNextCard() {
        DoCostTimeWorkDlg dlg = new DoCostTimeWorkDlg(ReadCard.getInstance(), ResourceManager.getString("InputPara.hint"), ResourceManager.getString("InputPara.InitBeforeInstall"), "checkingThread");
        dlg.display();
        if (!dlg.isResult()) {
            return null;
        }
        return this.getNextCardBase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String readcCopyright() {
        File aFile = null;
        Locale locale = ResourceManager.getLocale();
        LOGGER.debug("resource locale: " + locale + " , and is equal Locale.CHINESE: " + locale.equals(Locale.CHINESE), (Object)"readcCopyright");
        String basePath = this.installConext.getEnvirments().getBasePath();
        String licenseFilePath = null;
        licenseFilePath = locale.equals(Locale.CHINESE) ? PropertyManager.getProValue("cn.lincense.file.path") : PropertyManager.getProValue("en.lincense.file.path");
        aFile = new File(basePath + licenseFilePath);
        BufferedReader bReader = null;
        FileInputStream inFile = null;
        InputStreamReader inReaderTemp = null;
        String lineTxt = null;
        StringBuilder sb = new StringBuilder();
        try {
            inFile = new FileInputStream(aFile);
            inReaderTemp = new InputStreamReader((InputStream)inFile, "UTF-8");
            bReader = new BufferedReader(inReaderTemp);
            while ((lineTxt = bReader.readLine()) != null) {
                sb.append(lineTxt + "\n");
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("read copyright not found file error. ", (Throwable)e);
            StreamProcUtil.close(bReader);
            StreamProcUtil.close(inReaderTemp);
            StreamProcUtil.close((InputStream)inFile);
        }
        catch (IOException e2) {
            LOGGER.error("read copyright not found file error. ", (Throwable)e2);
            {
                catch (Throwable throwable) {
                    StreamProcUtil.close(bReader);
                    StreamProcUtil.close(inReaderTemp);
                    StreamProcUtil.close((InputStream)inFile);
                    throw throwable;
                }
            }
            StreamProcUtil.close(bReader);
            StreamProcUtil.close(inReaderTemp);
            StreamProcUtil.close((InputStream)inFile);
        }
        StreamProcUtil.close(bReader);
        StreamProcUtil.close(inReaderTemp);
        StreamProcUtil.close((InputStream)inFile);
        return sb.toString();
    }

    private void initComps() {
        String copyRightTxt = this.readcCopyright();
        if (!"ATIC".equals(ContextUtil.getStrValueFromCtx("software.install.name"))) {
            copyRightTxt = copyRightTxt.replaceAll("ATIC", "LogCenter");
        }
        JTextArea jta = new JTextArea(copyRightTxt);
        jta.setEditable(false);
        jta.setLineWrap(true);
        jta.setWrapStyleWord(true);
        jta.setBorder(BorderFactory.createLineBorder(Color.gray, 0));
        JScrollPane scroll = new JScrollPane(jta);
        JLabel pageTitle = new JLabel(ResourceManager.getString("COMMON.TXT.COPYRIGHT"));
        pageTitle.setBounds(20, 15, 300, 20);
        pageTitle.setFont(BaseStyle.PAGE_TITLE_FONT);
        pageTitle.setFocusable(false);
        this.add(pageTitle);
        scroll.setBounds(20, 40, 530, 220);
        this.add(scroll);
        StringBuffer agreeStr = new StringBuffer();
        agreeStr.append(ResourceManager.getString("CopyRight.agree"));
        StringBuffer disagreeStr = new StringBuffer();
        disagreeStr.append(ResourceManager.getString("CopyRight.disagree"));
        if (!"en".equalsIgnoreCase(ResourceManager.getLocale().toString())) {
            agreeStr.append("(A)");
            disagreeStr.append("(D)");
        }
        this.radioBtnAgree.setText(agreeStr.toString());
        this.radioBtnDisagree.setText(disagreeStr.toString());
        this.radioBtnDisagree.setSelected(true);
        Font buttonFont = new Font("Default", 0, 12);
        this.radioBtnAgree.setFont(buttonFont);
        this.radioBtnDisagree.setFont(buttonFont);
        this.radioBtnAgree.setMnemonic('A');
        this.radioBtnDisagree.setMnemonic('D');
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.radioBtnAgree);
        buttonGroup1.add(this.radioBtnDisagree);
        this.radioBtnAgree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JRadioButton agreeBtn = (JRadioButton)e.getSource();
                if (agreeBtn.isSelected()) {
                    ReadCard.this.setNextButtonEnable(true);
                }
            }
        });
        this.radioBtnDisagree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JRadioButton agreeBtn = (JRadioButton)e.getSource();
                if (agreeBtn.isSelected()) {
                    ReadCard.this.setNextButtonEnable(false);
                }
            }
        });
        JPanel southPanel = new JPanel();
        southPanel.setBorder(new EmptyBorder(0, 0, 10, 20));
        southPanel.setLayout(new BorderLayout());
        southPanel.setBackground(BaseStyle.BACKGROUND_COLOR);
        JPanel radioPanel = new JPanel();
        radioPanel.setBackground(BaseStyle.BACKGROUND_COLOR);
        radioPanel.add(this.radioBtnAgree);
        radioPanel.add(this.radioBtnDisagree);
        southPanel.add((Component)radioPanel, "East");
        this.setLayout(new BorderLayout());
        this.add((Component)southPanel, "South");
    }

    private void setNextButtonEnable(boolean enable) {
        JButton button = this.getNavigationButtons().get((Object)WizardDialog.Navigation.Next);
        button.setEnabled(enable);
    }

    @Override
    public boolean doCostTimeWork() {
        return true;
    }

    @Override
    protected boolean isValid(WizardDialog.Navigation navigation) {
        return false;
    }

    @Override
    protected void process(WizardDialog.Navigation navigation) {
    }

    @Override
    public String getSummary() {
        return null;
    }
}

