/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ui.card.install;

import com.huawei.elog.base.BaseStyle;
import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.model.ContextPropVal;
import com.huawei.elog.base.model.Step;
import com.huawei.elog.base.model.WizardDialog;
import com.huawei.elog.base.sdk.IInstallContext;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.EnvCheckUtil;
import com.huawei.elog.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SummaryCard
extends WizardDialog.Card {
    private static final long serialVersionUID = 2615437183047460605L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SummaryCard.class);
    private static final String COLLECT_PATH = "collector/bin";
    private static final String VSM_PATH = "Runtime/LegoRuntime/plugins";
    private static SummaryCard instance = null;
    private JScrollPane jScrollPaneSummary = new JScrollPane();
    private JTextArea txtSummary = new JTextArea();
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private transient IInstallContext context = InstallContext.getInstance();

    private SummaryCard() {
        super(null, new WizardDialog.Navigation[0]);
        this.initComps();
        this.setNavigationButtonsStatus(true, WizardDialog.Navigation.Previous, WizardDialog.Navigation.Next, WizardDialog.Navigation.Cancel);
    }

    public static SummaryCard getInstance() {
        if (null == instance) {
            instance = new SummaryCard();
        }
        instance.setSummaryTxt();
        return instance;
    }

    @Override
    protected WizardDialog.Card getNextCard() {
        this.haInitExec();
        return this.getNextCardBase();
    }

    private void haInitExec() {
        String haMode = ContextUtil.getStrValueFromCtx("vsm.install.mode.ha");
        if (haMode != null && haMode.equals("HA")) {
            String installPath = ContextUtil.getStrValueFromCtx("lego.base.installpath");
            if (installPath == null) {
                LOGGER.error("install path is null");
            }
            if (this.context.getInstallType().equals("legoPlat")) {
                if (!this.isInstallVSM(installPath)) {
                    ContextUtil.removePorp4Context("vsm.install.mode.ha");
                    ContextUtil.saveSearalizeValue2Ctx("vsm.install.mode.ha", "NORMAL");
                }
            } else if (this.context.getInstallType().equals("Collector")) {
                if (!this.isInstallCollector(installPath)) {
                    ContextUtil.removePorp4Context("vsm.install.mode.ha");
                    ContextUtil.saveSearalizeValue2Ctx("vsm.install.mode.ha", "NORMAL");
                }
            } else {
                LOGGER.info("Install mode is error!");
            }
        }
    }

    private void initComps() {
        LOGGER.info("Loading Summary Page", (Object)"initComps");
        JLabel pageTitle = new JLabel(ResourceManager.getString("Summary.Title"));
        pageTitle.setBounds(20, 15, 300, 20);
        pageTitle.setFont(BaseStyle.PAGE_TITLE_FONT);
        this.add(pageTitle);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(new EmptyBorder(40, 10, 10, 10));
        mainPanel.setLayout(this.gridBagLayout);
        mainPanel.setBackground(BaseStyle.BACKGROUND_COLOR);
        this.jScrollPaneSummary.setBackground(BaseStyle.BACKGROUND_COLOR);
        this.setLayout(new BorderLayout());
        this.add((Component)mainPanel, "Center");
        mainPanel.add((Component)this.jScrollPaneSummary, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 12, 12, 12), 0, 0));
        this.txtSummary.setMargin(new Insets(20, 10, 10, 10));
        this.jScrollPaneSummary.getViewport().add((Component)this.txtSummary, null);
        this.jScrollPaneSummary.setFocusable(true);
        this.txtSummary.setLineWrap(true);
        this.txtSummary.setFocusable(false);
        this.txtSummary.setEditable(false);
        this.setSummaryTxt();
    }

    private void setSummaryTxt() {
        StringBuffer summary = new StringBuffer();
        if ("legoPlat".equals(this.context.getInstallType())) {
            summary.append(ResourceManager.getString("Summary.BaseInfomatin"));
            summary.append(System.getProperty("line.separator"));
            summary.append(ResourceManager.getString("Summary.ActualMemorySize"));
            summary.append(EnvCheckUtil.getMemory() / 1024L + " MB");
            summary.append(System.getProperty("line.separator"));
            summary.append(ResourceManager.getString("Summary.OSType") + EnvCheckUtil.getOSType());
            summary.append(System.getProperty("line.separator"));
            summary.append(ResourceManager.getString("Summary.OSVersion") + EnvCheckUtil.getOSVersion());
        }
        summary.append(System.getProperty("line.separator"));
        summary.append(System.getProperty("line.separator"));
        summary.append(this.getPageSummary());
        summary.append(System.getProperty("line.separator"));
        this.txtSummary.setText(summary.toString().trim());
    }

    private String getPageSummary() {
        StringBuilder summary = new StringBuilder(1024);
        ContextPropVal propVal = this.installConext.getPropertyMap().getProp("lego.base.cardStepOrder");
        LinkedList cardList = (LinkedList)propVal.getValue();
        Iterator it = cardList.iterator();
        try {
            while (it.hasNext()) {
                Step step = (Step)it.next();
                WizardDialog.Card card = step.getCardClazz();
                if (null == card) continue;
                if (null != card.getSummary()) {
                    summary.append(card.getSummary());
                }
                if (!this.getClass().getName().equals(step.getCardClassName())) continue;
                break;
            }
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        return summary.toString().replace("/", "\\");
    }

    @Override
    protected boolean isValid(WizardDialog.Navigation navigation) {
        return false;
    }

    @Override
    protected void process(WizardDialog.Navigation navigation) {
    }

    @Override
    public String getSummary() {
        return null;
    }

    public boolean isInstallVSM(String path) {
        String[] files;
        File file;
        if (path == null) {
            return false;
        }
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        return (file = new File(path = path + VSM_PATH)).isDirectory() && file.exists() && (files = file.list(new VSMFilenameFilter())) != null && files.length > 0;
    }

    public boolean isInstallCollector(String path) {
        String[] files;
        File file;
        if (path == null) {
            return false;
        }
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        return (file = new File(path = path + COLLECT_PATH)).isDirectory() && file.exists() && (files = file.list(new CollectorFilenameFilter())) != null && files.length > 0;
    }

    private static class CollectorFilenameFilter
    implements FilenameFilter {
        private CollectorFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".dll") || name.endsWith(".so");
        }
    }

    private static class VSMFilenameFilter
    implements FilenameFilter {
        private VSMFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    }
}

