/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ui.card.uninstall;

import com.huawei.elog.base.BaseStyle;
import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.model.Bundles;
import com.huawei.elog.base.model.ContextPropVal;
import com.huawei.elog.base.model.DataBaseInfo;
import com.huawei.elog.base.model.WizardDialog;
import com.huawei.elog.ui.DoCostTimeWorkDlg;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.ui.table.CheckHeaderCellRenderer;
import com.huawei.elog.ui.table.CheckTableModle;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.DBConnectionFactory;
import com.huawei.elog.util.IDBConnection;
import com.huawei.elog.util.ResourceManager;
import com.huawei.elog.util.UIUtil;
import com.huawei.elog.util.db.DBUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UninstallBundleCard
extends WizardDialog.Card {
    private static final long serialVersionUID = -4662704868256818251L;
    private static final Logger LOGGER = LoggerFactory.getLogger(UninstallBundleCard.class);
    private static UninstallBundleCard instance = null;
    private DefaultTableModel tableModel = null;
    private JTable table = new JTable();
    private Map<String, Bundles> platformInstalledBundleMap = new LinkedHashMap<String, Bundles>();
    private Map<String, Bundles> productInstalledBundlesMap = new LinkedHashMap<String, Bundles>();

    private UninstallBundleCard() {
        super(null, WizardDialog.Navigation.Next, WizardDialog.Navigation.Cancel);
        this.addItem();
        this.setNavigationButtonsStatus(true, WizardDialog.Navigation.Previous, WizardDialog.Navigation.Previous, WizardDialog.Navigation.Cancel);
    }

    public static UninstallBundleCard getInstance() {
        if (null == instance) {
            instance = new UninstallBundleCard();
        }
        return instance;
    }

    public Map<String, Bundles> getPlatformInstalledBundleMap() {
        return this.platformInstalledBundleMap;
    }

    public Map<String, Bundles> getProductInstalledBundlesMap() {
        return this.productInstalledBundlesMap;
    }

    public void setPlatformInstalledBundleMap(Map<String, Bundles> map) {
        this.platformInstalledBundleMap = map;
    }

    public void setProductInstalledBundlesMap(Map<String, Bundles> map) {
        this.productInstalledBundlesMap = map;
    }

    protected void addItem() {
        LOGGER.info("install bundle...addItem start...", (Object)"addItem");
        ContextPropVal platformValInstalled = this.installConext.getEnvirments().getPropertyMap().getProp("lego.base.components.plat");
        ContextPropVal productValInstalled = this.installConext.getEnvirments().getPropertyMap().getProp("lego.base.components.product");
        this.setPlatformInstalledBundleMap((Map)platformValInstalled.getValue());
        this.setProductInstalledBundlesMap((Map)productValInstalled.getValue());
        Vector<String> headerNames = new Vector<String>();
        headerNames.add("");
        headerNames.add(ResourceManager.getString("LEGO.SELECT.BUNDLE.NAME"));
        headerNames.add(ResourceManager.getString("LEGO.SELECT.BUNDLE.DESCRIPTION"));
        headerNames.add(ResourceManager.getString("LEGO.SELECT.BUNDLE.SIZE"));
        headerNames.add(ResourceManager.getString("LEGO.SELECT.BUNDLE.VERSION"));
        headerNames.add("ID");
        Vector<Vector<Object>> data = this.getCompsInfo();
        this.tableModel = new CheckTable((Vector<?>)data, (Vector<?>)headerNames);
        this.table.setModel(this.tableModel);
        this.table.getTableHeader().setDefaultRenderer(new CheckHeaderCellRenderer(this.table));
        this.table.setEnabled(false);
        this.table.setRowHeight(20);
        this.table.setRowSorter(null);
        this.table.setAutoResizeMode(4);
        this.table.setSelectionMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().setResizingAllowed(false);
        TableColumn column = null;
        for (int i = 0; i < 5; ++i) {
            column = this.table.getColumnModel().getColumn(i);
            if (i == 0) {
                column.setPreferredWidth(10);
                continue;
            }
            if (i == 2) {
                column.setPreferredWidth(100);
                continue;
            }
            column.setPreferredWidth(30);
        }
        UIUtil.hideColumn(this.table, 5);
        this.setLayout(null);
        JLabel label1 = new JLabel(ResourceManager.getString("LEGO.UNISTALL.SELECT.BUNDLE"));
        label1.setBounds(20, 15, 300, 20);
        label1.setFont(BaseStyle.PAGE_TITLE_FONT);
        this.add(label1);
        JScrollPane pane1 = new JScrollPane(this.table);
        pane1.setVerticalScrollBarPolicy(20);
        pane1.setBounds(20, 40, 530, 260);
        this.add(pane1);
        LOGGER.info("install bundle...addItem end...", (Object)"addItem");
    }

    private Vector<Vector<Object>> getCompsInfo() {
        Vector<Vector<Object>> vectors = new Vector<Vector<Object>>();
        Collection<Bundles> ptcollection = this.getPlatformInstalledBundleMap().values();
        for (Bundles platformBundle : ptcollection) {
            Vector<Object> v = new Vector<Object>();
            if (platformBundle.isNeeded()) {
                v.add(true);
            } else {
                v.add(false);
            }
            v.add(ResourceManager.getString(platformBundle.getName()));
            v.add(ResourceManager.getString(platformBundle.getDescription()));
            v.add(platformBundle.getSize());
            v.add(platformBundle.getVersion());
            v.add(platformBundle.getId());
            vectors.add(v);
        }
        Collection<Bundles> pdcollection = this.getProductInstalledBundlesMap().values();
        for (Bundles productBundle : pdcollection) {
            LOGGER.info("Product bundle Name" + productBundle.getName(), (Object)"assembProdModel");
            Vector<Object> v = new Vector<Object>();
            if (productBundle.isNeeded()) {
                v.add(true);
            } else {
                v.add(false);
            }
            v.add(ResourceManager.getString(productBundle.getName()));
            v.add(ResourceManager.getString(productBundle.getDescription()));
            v.add(productBundle.getSize());
            v.add(productBundle.getVersion());
            v.add(productBundle.getId());
            vectors.add(v);
        }
        return vectors;
    }

    @Override
    protected WizardDialog.Card getNextCard() {
        DoCostTimeWorkDlg dlg = new DoCostTimeWorkDlg(UninstallBundleCard.getInstance(), ResourceManager.getString("InputPara.hint"), ResourceManager.getString("SelectPackage.InitBeforeInstall"), "checkingThread");
        dlg.display();
        if (!dlg.isResult()) {
            return null;
        }
        return this.getNextCardBase();
    }

    @Override
    protected boolean isValid(WizardDialog.Navigation navigation) {
        return true;
    }

    @Override
    protected void process(WizardDialog.Navigation navigation) {
    }

    @Override
    public boolean doCostTimeWork() {
        boolean reuslt = this.goNext();
        LOGGER.debug("this.goNext(): " + reuslt, (Object)"doCostTimeWork");
        return reuslt;
    }

    private boolean goNext() {
        if (!this.checkDbValid()) {
            int result = OptionPane.showWarnConfirmDialog(this.getWizardDialog(), ResourceManager.getString("VSM.DB.ERROR.CONTINUE.COMFIRM"));
            if (0 == result) {
                CommonUtil.shutDownJvm(0);
            } else {
                return false;
            }
        }
        this.setDbPathByType();
        try {
            ContextUtil.saveAntValue2Ctx("lego.base.is.uninstall.all", String.valueOf(true));
            ContextUtil.saveSearalizeValue2Ctx("lego.base.isdbdel", String.valueOf(false));
        }
        catch (Exception e2) {
            LOGGER.info("Deal Error When Closing", (Object)"goNext");
        }
        return true;
    }

    private void setDbPathByType() {
        String dbType = ContextUtil.getStrValueFromCtx("lego.db.type");
        if ("MySQL".equalsIgnoreCase(dbType)) {
            ContextUtil.saveAntValue2Ctx("mysql", "lego.db.type.path");
        } else if ("Microsoft SQL Server".equalsIgnoreCase(dbType)) {
            ContextUtil.saveAntValue2Ctx("sqlserver", "lego.db.type.path");
        } else if ("Oracle".equalsIgnoreCase(dbType)) {
            ContextUtil.saveAntValue2Ctx("oracle", "lego.db.type.path");
        }
    }

    private boolean checkDbValid() {
        DataBaseInfo dbInfor;
        IDBConnection dbConnection;
        if (InstallContext.getInstance().getInstallType().contains("Collector")) {
            return true;
        }
        if (InstallContext.getInstance().getInstallType().contains("legoPlat") && null != (dbConnection = DBConnectionFactory.getInstance(dbInfor = DBUtil.getBaseInfo()))) {
            return dbConnection.isConnected(dbInfor, true);
        }
        return false;
    }

    @Override
    public String getSummary() {
        return null;
    }

    public DefaultTableModel getInstallTableModel() {
        return this.tableModel;
    }

    private static class CheckTable
    extends CheckTableModle {
        private static final long serialVersionUID = -6959148379280355383L;

        public CheckTable(Vector<?> data, Vector<?> columnNames) {
            super(data, columnNames);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

