/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ui.card.uninstall;

import com.huawei.elog.base.BaseStyle;
import com.huawei.elog.base.model.WizardDialog;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.EnvUtil;
import com.huawei.elog.util.OSUtil;
import com.huawei.elog.util.ResourceManager;
import com.huawei.elog.util.ServiceUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.io.File;
import java.text.MessageFormat;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UninstallFinishedCard
extends WizardDialog.Card {
    private static final long serialVersionUID = -3962921283431771503L;
    private static UninstallFinishedCard instance = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(UninstallFinishedCard.class);

    private UninstallFinishedCard() {
        super(null, WizardDialog.Navigation.Previous, WizardDialog.Navigation.Complete, WizardDialog.Navigation.Cancel);
        Properties props = System.getProperties();
        if (!props.getProperty("os.name").equalsIgnoreCase("linux")) {
            this.deleteRegServices();
        }
        this.initComps();
        this.setNavigationButtonsStatus(true, WizardDialog.Navigation.Complete);
        this.setNavigationButtonsStatus(false, WizardDialog.Navigation.Previous, WizardDialog.Navigation.Cancel);
    }

    public static UninstallFinishedCard getInstance() {
        if (null == instance) {
            instance = new UninstallFinishedCard();
        }
        return instance;
    }

    @Override
    protected WizardDialog.Card getNextCard() {
        return this.getNextCardBase();
    }

    private void deleteRegServices() {
        ServiceUtil.deleteService("DDOSCOLLECTORSVC");
        ServiceUtil.deleteService("ATICCOLLECTORGUARDSERVICE");
    }

    private void initComps() {
        JLabel pageTitle = new JLabel(ResourceManager.getString("Uninstaller.uninstall"));
        pageTitle.setBounds(20, 15, 300, 20);
        pageTitle.setFont(BaseStyle.PAGE_TITLE_FONT);
        this.add(pageTitle);
        JTextArea textArea = new JTextArea();
        textArea.setMargin(new Insets(45, 20, 0, 10));
        Box mainBox = Box.createVerticalBox();
        mainBox.add(Box.createVerticalStrut(4));
        Box line = Box.createHorizontalBox();
        textArea.setBackground(this.getBackground());
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        String infoText = "";
        infoText = ResourceManager.getString("Uninstaller.Note");
        infoText = MessageFormat.format(infoText, ContextUtil.getStrValueFromCtx("software.install.name"));
        textArea.setText(infoText);
        textArea.setFocusable(true);
        textArea.setEditable(false);
        line.add(textArea);
        mainBox.add(line);
        JPanel southPanel = new JPanel();
        southPanel.setBackground(this.getBackground());
        this.setLayout(new BorderLayout());
        this.add((Component)mainBox, "Center");
        this.add((Component)southPanel, "South");
        this.setBorder(BorderFactory.createEmptyBorder(0, 10, 120, 12));
        LOGGER.info("Loading Exit Page", (Object)"exec");
    }

    @Override
    protected boolean isValid(WizardDialog.Navigation navigation) {
        return false;
    }

    @Override
    protected void process(WizardDialog.Navigation navigation) {
        this.hideWizardDialog();
        if (OSUtil.isWindows()) {
            String file = EnvUtil.getReg("logCenterUninstall");
            if (null != file) {
                File f = new File(file);
                if (f.exists()) {
                    boolean deleteResult = f.delete();
                    LOGGER.debug("delete result:" + deleteResult);
                }
                EnvUtil.removeReg("logCenterUninstall");
            }
            CommonUtil.shutDownJvm(0);
        }
    }

    @Override
    public String getSummary() {
        return null;
    }
}

