/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ui.collector;

import com.huawei.elog.base.BaseStyle;
import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.context.ContextLoader;
import com.huawei.elog.base.model.ContextPropVal;
import com.huawei.elog.base.model.Custparm;
import com.huawei.elog.base.model.Version;
import com.huawei.elog.base.model.WizardDialog;
import com.huawei.elog.base.sdk.IInstallContext;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.util.ArraysClone;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.DiskUtil;
import com.huawei.elog.util.FileUtil;
import com.huawei.elog.util.OSUtil;
import com.huawei.elog.util.PropertyManager;
import com.huawei.elog.util.ResourceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataBaseCard
extends WizardDialog.Card
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataBaseCard.class);
    private static final String VERSION_PREFIX = "Version:";
    private static final String VERSION_BRAND_PREFIX = "Remark:";
    private static final String VERSION_TIME_PREFIX = "Release Time:";
    private static final String CURRENT_VERSION_PATH = "/collector/dist/etc/conf/version.txt";
    private static final String ELOGCOLLECTORINSTALLEDXMLFILE = "CollectorInstalled.xml";
    private static DataBaseCard instance = null;
    private static JLabel jl1Msg;
    private static JLabel jl2Msg;
    private static Map<String, JTextField> sParamPersMap;
    private static final long serialVersionUID = 6298623342665483174L;
    private static String[] sParamId;
    private static String sSavePath;
    private static IInstallContext context;
    private static JTextField[] sValueField;
    private Map<String, File> bundleXmlFile = new LinkedHashMap<String, File>();
    private JFileChooser chooser;
    private List<Custparm> custParamList = new ArrayList<Custparm>();
    private String defaultLinuxPath = PropertyManager.getProValue("linux.default.install.path");
    private String defaultWindowpath = PropertyManager.getProValue("window.default.install.path");
    private int i = 0;
    private JButton jb;
    private JTextField jtf;
    private JLabel[] nameLabel;
    private JLabel[] sNameLabel;

    private DataBaseCard() {
        super(null, new WizardDialog.Navigation[0]);
        this.initSavePath();
        this.addItem();
        this.setNavigationButtonsStatus(true, WizardDialog.Navigation.Previous, WizardDialog.Navigation.Next, WizardDialog.Navigation.Cancel);
    }

    public static DataBaseCard getInstance() {
        if (null == instance) {
            instance = new DataBaseCard();
        }
        return instance;
    }

    public static JLabel getJl1Msg() {
        return jl1Msg;
    }

    public static String[] getSParamId() {
        String[] tempArray = new String[sParamId.length];
        System.arraycopy(sParamId, 0, tempArray, 0, sParamId.length);
        return tempArray;
    }

    public static String getsSavePath() {
        sSavePath = DataBaseCard.checkPathEnd(sSavePath);
        return sSavePath;
    }

    public void setsSavePath(String savePath) {
        DataBaseCard.setsSavePathValue(savePath);
    }

    public static void setsSavePathValue(String savePath) {
        sSavePath = savePath;
    }

    public static JTextField[] getSValueField() {
        JTextField[] tempArray = new JTextField[sValueField.length];
        System.arraycopy(sValueField, 0, tempArray, 0, sValueField.length);
        return tempArray;
    }

    public void setJl1Msg(JLabel jl1MsgParam) {
        DataBaseCard.setJl1MsgValue(jl1MsgParam);
    }

    public static void setJl1MsgValue(JLabel jl1MsgParam) {
        jl1Msg = jl1MsgParam;
    }

    public void setJl2Msg(JLabel jl2MsgParam) {
        DataBaseCard.setJl2MsgValue(jl2MsgParam);
    }

    public static void setJl2MsgValue(JLabel jl2MsgParam) {
        jl2Msg = jl2MsgParam;
    }

    public static void setSParamId(String[] paramId) {
        sParamId = new String[paramId.length];
        System.arraycopy(paramId, 0, sParamId, 0, paramId.length);
    }

    public static void setSValueField(JTextField[] valueField) {
        sValueField = new JTextField[valueField.length];
        System.arraycopy(valueField, 0, sValueField, 0, valueField.length);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LOGGER.debug("choice database and connection");
        JButton jbSource = (JButton)e.getSource();
        if (jbSource == this.jb) {
            if (null == this.chooser) {
                this.chooser = new JFileChooser(new File(sSavePath));
            }
            this.chooser.setCurrentDirectory(new File(sSavePath));
            this.chooser.setFileSelectionMode(1);
            int retValue1 = this.chooser.showOpenDialog(this);
            String tepstr = "";
            if (OSUtil.isWindows()) {
                tepstr = this.defaultWindowpath.substring(this.defaultWindowpath.lastIndexOf("\\"), this.defaultWindowpath.length());
            }
            if (retValue1 == 0) {
                String path = this.chooser.getSelectedFile().getPath();
                if (path.endsWith("\\")) {
                    path = path.substring(0, path.length() - 1);
                }
                this.jtf.setText(path + tepstr);
                this.setsSavePath(this.jtf.getText());
            }
            jl1Msg.setText(this.getDiskCheckString());
            jl2Msg.setText(this.getDiskFreeString());
        }
    }

    @Override
    public WizardDialog.Card getPreviousCard() {
        sParamPersMap.clear();
        for (int k = 0; k < sParamId.length; ++k) {
            sParamPersMap.put(sParamId[k], sValueField[k]);
        }
        this.setsSavePath(this.jtf.getText());
        WizardDialog.Card card = super.getPreviousCard();
        return card;
    }

    private void addItem() {
        JPanel folderPanel = this.getFolderChoice();
        JScrollPane southPane = this.getSouthPanel();
        this.setLayout(null);
        JLabel jl1 = new JLabel(ResourceManager.getString("LEGO.PLATFORM.SETUP.CATALOG"));
        jl1.setBounds(20, 15, 300, 20);
        jl1.setFont(BaseStyle.PAGE_TITLE_FONT);
        this.add(jl1);
        this.add(folderPanel);
        folderPanel.setBounds(20, 40, 520, 90);
        JLabel jl12 = new JLabel(ResourceManager.getString("LEGO.SYSTEM.PARM.INFO"));
        jl12.setBounds(5, 260, 300, 15);
        this.add(jl12);
        southPane.setBounds(5, 280, 515, 60);
        this.add(southPane);
        if (this.custParamList.isEmpty()) {
            jl12.setVisible(false);
            southPane.setVisible(false);
        }
    }

    private boolean checkPathChar() {
        String path = this.jtf.getText();
        if (null == path || path.trim().length() < 1) {
            return false;
        }
        String[] folderNames = null;
        if (OSUtil.isWindows()) {
            String unRootPath = path.substring(path.indexOf(":\\") + 2);
            unRootPath = unRootPath.replace("\\", "/");
            folderNames = unRootPath.split("/");
        } else {
            folderNames = path.split("/");
        }
        for (String folder : folderNames) {
            if (folder.length() == 0) continue;
            String normalizeFolder = Normalizer.normalize(folder, Normalizer.Form.NFKC);
            Pattern pattern = Pattern.compile("^[0-9a-zA-Z_-]{1}[\\w-]*$");
            Matcher matcher = pattern.matcher(normalizeFolder);
            boolean flag = matcher.matches();
            if (flag) continue;
            return false;
        }
        return true;
    }

    private boolean checkPathValid() {
        String basePath = context.getEnvirments().getBasePath();
        String targetPath = this.jtf.getText();
        String normalizeTargetPath = Normalizer.normalize(targetPath = targetPath.replace("\\", "/"), Normalizer.Form.NFKC);
        if (!normalizeTargetPath.endsWith("/")) {
            normalizeTargetPath = normalizeTargetPath + "/";
        }
        return !normalizeTargetPath.equals(basePath) && !normalizeTargetPath.contains(basePath);
    }

    private boolean checkParmNull() {
        this.i = 0;
        while (this.i < sValueField.length) {
            if (sValueField[this.i].getText().trim().length() == 0) {
                return false;
            }
            ++this.i;
        }
        return true;
    }

    public Map<String, File> getBundleXmlFile() {
        return this.bundleXmlFile;
    }

    public String getDefaultLinuxPath() {
        return this.defaultLinuxPath;
    }

    public String getDefaultWindowpath() {
        return this.defaultWindowpath;
    }

    private JPanel getFolderChoice() {
        JPanel jp3 = new JPanel();
        jp3.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
        jp3.setLayout(null);
        jp3.setBounds(5, 280, 1, 80);
        JLabel jl = new JLabel(ResourceManager.getString("LEGO.SYSTEM.POSTION.FOLDER"));
        jl.setBounds(15, 5, 85, 20);
        jp3.add(jl);
        this.jtf = new JTextField(sSavePath);
        this.jtf.setBounds(100, 5, 235, 20);
        this.jtf.setEditable(false);
        jp3.add(this.jtf);
        this.jb = new JButton(ResourceManager.getString("LEGO.SYSTEM.POSTION.BROWSE"));
        this.jb.setBounds(340, 5, 80, 20);
        this.jb.addActionListener(this);
        jp3.add(this.jb);
        this.setJl1Msg(new JLabel(this.getDiskCheckString()));
        jl1Msg.setBounds(15, 30, 270, 20);
        jp3.add(jl1Msg);
        this.setJl2Msg(new JLabel(this.getDiskFreeString()));
        jl2Msg.setBounds(15, 55, 270, 20);
        jp3.add(jl2Msg);
        if (context.getEnvirments().isSystemInstalled()) {
            String installPath = (String)context.getEnvirments().getPropertyMap().getProp("lego.base.installpath").getValue();
            this.setsSavePath(installPath);
            this.jtf.setText(installPath);
            this.jtf.setEnabled(false);
            this.jb.setEnabled(false);
        }
        return jp3;
    }

    private String getDiskCheckString() {
        DecimalFormat dft = new DecimalFormat("####.00");
        double need = this.getNeedSpace();
        StringBuilder sb = new StringBuilder();
        sb.append(ResourceManager.getString("LEGO.SYSTEM.FOLDER.SPACE"));
        sb.append(" " + dft.format(need) + " GB");
        return sb.toString();
    }

    private String getDiskFreeString() {
        DecimalFormat dft = new DecimalFormat("####.00");
        this.setsSavePath(this.jtf.getText());
        if (null == DiskUtil.gatherDiskInfo4OS(sSavePath)) {
            OptionPane.showInfoDialog(sSavePath + ResourceManager.getString("LEGO.COMMON.NULL.ERROR"));
            return "";
        }
        double free = (double)DiskUtil.gatherDiskInfo4OS(sSavePath).getFree() / 1.073741824E9;
        StringBuilder sb = new StringBuilder();
        sb.append(System.getProperty("line.separator"));
        sb.append(ResourceManager.getString("LEGO.SYSTEM.DO.SPACE"));
        sb.append(" " + dft.format(free) + " GB");
        sb.append(System.getProperty("line.separator"));
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void storeCurrentProps() {
        String eLogCollectorInstalledFlagPath;
        File eLogInstalledFile;
        File installFile = new File(this.jtf.getText());
        String haOrNot = ContextUtil.getStrValueFromCtx("vsm.install.mode.ha");
        LOGGER.info("HaOrNot:" + haOrNot);
        boolean isReuseHistoryDataScene = false;
        if ("HA".equalsIgnoreCase(haOrNot) && !(eLogInstalledFile = new File(eLogCollectorInstalledFlagPath = this.jtf.getText() + File.separator + ELOGCOLLECTORINSTALLEDXMLFILE)).exists()) {
            isReuseHistoryDataScene = true;
        }
        if (null == haOrNot || "NORMAL".equalsIgnoreCase(haOrNot)) {
            isReuseHistoryDataScene = true;
        }
        if (isReuseHistoryDataScene) {
            File[] files = installFile.listFiles();
            if (null != files && 0 != files.length) {
                this.jdugeVersionAndBrandIsEqual();
                String msg = ResourceManager.getString("InputPara.Use.HistoryData");
                int result = OptionPane.showWarnConfirmDialog(this.getWizardDialog(), msg);
                if (0 != result) {
                    ContextUtil.saveSearalizeValue2Ctx("is.history.data.reused", false);
                    String msgDirNotEmpty = ResourceManager.getString("InputPara.Dirty");
                    OptionPane.showErrorDialog(msgDirNotEmpty);
                    return;
                }
                ContextLoader.loadPreviousVersionConetext();
                LOGGER.debug("The history data will be reused");
                ContextUtil.saveSearalizeValue2Ctx("is.history.data.reused", true);
            } else {
                ContextUtil.saveSearalizeValue2Ctx("is.history.data.reused", false);
            }
        }
        ContextUtil.saveSearalizeValue2Ctx("lego.base.installpath", installFile.getPath());
    }

    private int getNeedSpace() {
        int runTimeSize;
        int needSpace = runTimeSize = Integer.parseInt(PropertyManager.getProValue("elog_install.size"));
        return needSpace;
    }

    public JLabel[] getNameLabel() {
        return (JLabel[])ArraysClone.deepClone(this.nameLabel);
    }

    @Override
    protected WizardDialog.Card getNextCard() {
        if (!this.goNext()) {
            return null;
        }
        this.storeCurrentProps();
        return this.getNextCardBase();
    }

    private JScrollPane getSouthPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        this.sNameLabel = new JLabel[this.custParamList.size()];
        DataBaseCard.setSValueField(new JTextField[this.custParamList.size()]);
        DataBaseCard.setSParamId(new String[this.custParamList.size()]);
        for (int k = 0; k < this.custParamList.size(); ++k) {
            Custparm param = this.custParamList.get(k);
            this.sNameLabel[k] = new JLabel(ResourceManager.getString(param.getName()) + ResourceManager.getString("LEGO.COMMON.COLON"));
            DataBaseCard.sValueField[k] = new JTextField(param.getDefaultvalue());
            sValueField[k].setText(String.valueOf(param.getDefaultvalue()));
            DataBaseCard.sParamId[k] = param.getId();
            this.sNameLabel[k].setBounds(15 + 210 * (k % 2), 5 + 25 * (k / 2), 100, 20);
            sValueField[k].setBounds(90 + 210 * (k % 2), 5 + 25 * (k / 2), 100, 20);
            panel.add(this.sNameLabel[k]);
            panel.add(sValueField[k]);
            if (!sParamPersMap.containsKey(sParamId[k])) continue;
            sValueField[k].setText(sParamPersMap.get(sParamId[k]).getText());
        }
        JScrollPane jsp = new JScrollPane(panel, 20, 31);
        jsp.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
        jsp.getViewport().setView(panel);
        jsp.addComponentListener(new CAdapter(jsp, panel));
        return jsp;
    }

    private void initSavePath() {
        if (null == sSavePath) {
            if (OSUtil.isWindows()) {
                this.setsSavePath(this.defaultWindowpath);
            } else {
                this.setsSavePath(this.defaultLinuxPath);
            }
            if (null != System.getProperty("ENT_ROOT")) {
                this.setsSavePath(ContextUtil.getStrValueFromCtx("esight.install.rootpath"));
                if (null == sSavePath) {
                    if (OSUtil.isWindows()) {
                        this.setsSavePath(PropertyManager.getProValue("elogcollector.window.default.install.path"));
                    } else {
                        this.setsSavePath(PropertyManager.getProValue("elogcollector.linux.default.install.path"));
                    }
                    this.setsSavePath(sSavePath.concat("ATIC\\ATIC"));
                } else {
                    this.setsSavePath(sSavePath.concat("\\ATIC\\ATIC"));
                }
                this.setsSavePath(sSavePath.replace("/", "\\"));
            }
        }
    }

    @Override
    protected boolean isValid(WizardDialog.Navigation navigation) {
        return false;
    }

    @Override
    protected void process(WizardDialog.Navigation navigation) {
    }

    public boolean goNext() {
        if (!OSUtil.isWindows() ? !FileUtil.testPathValid(this.jtf.getText(), ResourceManager.getString("VSM.EXTEND.ELOG.ONLINE.PATH"), this.getWizardDialog(), true) : !FileUtil.testPathValid(this.jtf.getText(), ResourceManager.getString("LEGO.SYSTEM.POSTION.FOLDER"), this.getWizardDialog(), false)) {
            return false;
        }
        if (!this.checkPathChar()) {
            OptionPane.showInfoDialog(ResourceManager.getString("LEGO.PATH.SET.ERROR.CHAR"));
            return false;
        }
        if (!this.checkPathValid()) {
            OptionPane.showInfoDialog(ResourceManager.getString("LEGO.PATH.SET.ERROR.VALID"));
            OptionPane.showInfoDialog(ResourceManager.getString("LEGO.PATH.SET.ERROR.VALID"));
            return false;
        }
        if (!this.checkParmNull()) {
            OptionPane.showInfoDialog(this.sNameLabel[this.i].getText() + ResourceManager.getString("LEGO.DB.SET.PRODUCT.ERROR"));
            return false;
        }
        if (null == DiskUtil.gatherDiskInfo4OS(sSavePath)) {
            OptionPane.showInfoDialog(sSavePath + ResourceManager.getString("LEGO.COMMON.NULL.ERROR"));
            return false;
        }
        this.setsSavePath(this.jtf.getText());
        double need = this.getNeedSpace();
        double free = (double)DiskUtil.gatherDiskInfo4OS(sSavePath).getFree() / 1.073741824E9;
        LOGGER.debug("free:{}G, need:{}G", (Object)free, (Object)need);
        if (free < need) {
            OptionPane.showInfoDialog(ResourceManager.getString("COLLECTOR.SYSTEM.SIZE.CHECK.FAIL.MESSAGE", String.valueOf(need)));
            return false;
        }
        ContextUtil.saveSearalizeValue2Ctx("vsm.install.system.info.env", "x64");
        ContextUtil.saveSearalizeValue2Ctx("vsm.install.index.static.id", String.valueOf(UUID.randomUUID()));
        return true;
    }

    private static String checkPathEnd(String savepath) {
        while (savepath.endsWith("/") || savepath.endsWith("\\")) {
            savepath = savepath.substring(0, savepath.length() - 1);
        }
        return savepath;
    }

    public void setBundleXmlFile(Map<String, File> bundleXmlFile) {
        this.bundleXmlFile = bundleXmlFile;
    }

    public void setDefaultLinuxPath(String defaultLinuxPath) {
        this.defaultLinuxPath = defaultLinuxPath;
    }

    public void setDefaultWindowpath(String defaultWindowpath) {
        this.defaultWindowpath = defaultWindowpath;
    }

    public void setNameLabel(JLabel[] nameLabel) {
        this.nameLabel = (JLabel[])ArraysClone.deepClone(nameLabel);
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        String lineWrap = CommonUtil.WRAP_CHAR;
        sb.append("[" + ResourceManager.getString("LEGO.PLATFORM.SETUP.CATALOG") + "]" + lineWrap);
        ContextPropVal installPathVal = this.installConext.getPropertyMap().getProp("lego.base.installpath");
        sb.append(ResourceManager.getString("LEGO.SYSTEM.POSTION.FOLDER") + installPathVal.getValue());
        sb.append(lineWrap);
        return sb.toString();
    }

    private boolean jdugeVersionAndBrandIsEqual() {
        String previousBrand;
        Version currentVersion = this.parseCurrentVersion();
        Version previousVersion = this.parsePreviousVersion();
        String currentBrand = null == currentVersion ? null : currentVersion.getVersionBrand();
        String string = previousBrand = null == previousVersion ? null : previousVersion.getVersionBrand();
        if (null != currentBrand && null != previousBrand && currentBrand.equalsIgnoreCase(previousBrand)) {
            String subPreviousVersion;
            String currentVersionNum = currentVersion.getVersionNum();
            String previousVersionNum = previousVersion.getVersionNum();
            String subCurrentVersion = currentVersionNum.substring(0, currentVersionNum.length() - 2);
            if (subCurrentVersion.equalsIgnoreCase(subPreviousVersion = previousVersionNum.substring(0, previousVersionNum.length() - 2))) {
                return true;
            }
        }
        return false;
    }

    private Version parsePreviousVersion() {
        String previousVersionPath = System.getProperty("user.home");
        previousVersionPath = previousVersionPath + File.separator + "logcenter/version.txt";
        File versionFile = null;
        versionFile = new File(previousVersionPath);
        if (!versionFile.exists()) {
            LOGGER.warn("version file does not exist.");
            return null;
        }
        Version version = this.getVersionFromFile(versionFile);
        return version;
    }

    private Version parseCurrentVersion() {
        String installBasePath = ContextUtil.getStrValueFromCtx("lego.base.path");
        String currentVersionPath = installBasePath + CURRENT_VERSION_PATH;
        File versionFile = null;
        versionFile = new File(currentVersionPath);
        if (!versionFile.exists()) {
            LOGGER.warn("version file does not exist.");
            return null;
        }
        Version version = this.getVersionFromFile(versionFile);
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Version getVersionFromFile(File f) {
        Version version = new Version();
        if (!f.exists()) {
            return null;
        }
        BufferedReader in = null;
        String line = null;
        String tmp = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "utf-8"));
            while ((line = in.readLine()) != null) {
                if (line.indexOf(VERSION_PREFIX) > -1) {
                    tmp = line.substring(line.indexOf(VERSION_PREFIX) + VERSION_PREFIX.length());
                    version.setVersionNum(tmp);
                    continue;
                }
                if (line.indexOf(VERSION_BRAND_PREFIX) > -1) {
                    tmp = line.substring(line.indexOf(VERSION_BRAND_PREFIX) + VERSION_BRAND_PREFIX.length());
                    if (StringUtils.isNotEmpty((CharSequence)tmp)) {
                        tmp = tmp.trim();
                        tmp = tmp.split("[ ]")[0];
                    }
                    version.setVersionBrand(tmp);
                    continue;
                }
                if (line.indexOf(VERSION_TIME_PREFIX) <= -1) continue;
                tmp = line.substring(line.indexOf(VERSION_TIME_PREFIX) + VERSION_TIME_PREFIX.length());
                version.setReleaseTime(tmp);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("parse version file occurs error: ", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.error("CLOSE ", (Throwable)e);
                }
            }
        }
        return version;
    }

    static {
        sParamPersMap = new HashMap<String, JTextField>();
        context = InstallContext.getInstance();
    }

    private static class CAdapter
    extends ComponentAdapter {
        private JScrollPane jsp;
        private JPanel panel;

        public CAdapter(JScrollPane jsp, JPanel panel) {
            this.jsp = jsp;
            this.panel = panel;
        }

        @Override
        public void componentResized(ComponentEvent e) {
            Dimension size = this.jsp.getViewport().getSize();
            size.height = 1;
            this.panel.setPreferredSize(size);
            this.panel.validate();
            int realHeight = 1;
            for (Component ccc : this.panel.getComponents()) {
                if (ccc.getY() + ccc.getHeight() <= realHeight) continue;
                realHeight = ccc.getY() + ccc.getHeight();
            }
            size.height = realHeight;
            this.panel.setPreferredSize(size);
        }
    }
}

