/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ui.dialog;

import com.huawei.elog.base.BaseStyle;
import com.huawei.elog.ui.OptionPaneUI;
import com.huawei.elog.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowDetailDialog
extends JDialog {
    public static final Icon ICON_ERROR = ResourceManager.getIcon("Error");
    public static final Icon ICON_WARN = ResourceManager.getIcon("Warn");
    public static final Icon ICON_INFO = ResourceManager.getIcon("Inform");
    public static final Icon ICON_QUESTION = ResourceManager.getIcon("Question");
    private static final Logger LOGGER = LoggerFactory.getLogger(ShowDetailDialog.class);
    private static final long serialVersionUID = 1L;
    private static final String LANG = ResourceManager.getLocale().toString();
    private static final double D2 = 2.0;
    private static String dialogInfo;
    private static String detailMessage;
    private static Icon dialogIcon;
    private int selectedOption = 1;
    private transient WindowAdapter windowAdapter = null;
    private JButton btnContinue = new JButton();
    private JTextArea txtInfo = new JTextArea();
    private JButton btnCancel = new JButton();
    private JButton btnShowDetail = new JButton();
    private JScrollPane jspDetail;
    private JPanel pnlContent;
    private JPanel pnlTop;
    private JPanel pnlDetail;
    private JTextArea txtDetail;
    private String btnCancelText;
    private String btnContinueText;
    private Border border1;
    private JLabel lblImage;
    private StringBuffer showDetail;
    private transient ActionListener btnCancelActionListener;
    private transient ActionListener btnContinueActionListener;
    private transient ActionListener btnShowDetailOrNotActionListener;
    private boolean isShowingDetail;
    private boolean showContinue;
    private char[] mneKeys;

    public ShowDetailDialog(Frame frame, String title, String message, String msgDetail, Icon icon, boolean modal, boolean isShowContinue) {
        this(frame, title, message, msgDetail, icon, modal, isShowContinue, null, null, null);
    }

    public ShowDetailDialog(Dialog dialog, String title, String message, String msgDetail, Icon icon, boolean modal, boolean isShowContinue) {
        this(dialog, title, message, msgDetail, icon, modal, isShowContinue, null, null, null);
    }

    public ShowDetailDialog(Frame frame, String title, String message, String msgDetail, Icon icon, boolean modal, boolean isShowContinue, String btnCancelText, String btnContinueText, char[] keys) {
        super(frame, title, modal);
        this.btnShowDetail.setVisible(false);
        this.btnShowDetail.setEnabled(false);
        this.jspDetail = new JScrollPane();
        this.pnlContent = new JPanel();
        this.pnlTop = new JPanel();
        this.pnlDetail = new JPanel();
        this.txtDetail = new JTextArea();
        this.btnCancelText = ResourceManager.getString("WizardFrame.Exit");
        this.btnContinueText = ResourceManager.getString("WizardFrame.Continue");
        this.lblImage = null;
        this.showDetail = null;
        this.btnCancelActionListener = null;
        this.btnContinueActionListener = null;
        this.btnShowDetailOrNotActionListener = null;
        this.isShowingDetail = false;
        this.showContinue = false;
        this.mneKeys = null;
        frame.setExtendedState(0);
        this.initDialog(title, message, msgDetail, icon, isShowContinue, btnCancelText, btnContinueText, keys);
    }

    public ShowDetailDialog(Dialog dialog, String title, String message, String msgDetail, Icon icon, boolean modal, boolean isShowContinue, String btnCancelText, String btnContinueText, char[] keys) {
        super(dialog, title, modal);
        this.btnShowDetail.setVisible(false);
        this.btnShowDetail.setEnabled(false);
        this.jspDetail = new JScrollPane();
        this.pnlContent = new JPanel();
        this.pnlTop = new JPanel();
        this.pnlDetail = new JPanel();
        this.txtDetail = new JTextArea();
        this.btnCancelText = ResourceManager.getString("WizardFrame.Exit");
        this.btnContinueText = ResourceManager.getString("WizardFrame.Continue");
        this.lblImage = null;
        this.showDetail = null;
        this.btnCancelActionListener = null;
        this.btnContinueActionListener = null;
        this.btnShowDetailOrNotActionListener = null;
        this.isShowingDetail = false;
        this.showContinue = false;
        this.mneKeys = null;
        this.initDialog(title, message, msgDetail, icon, isShowContinue, btnCancelText, btnContinueText, keys);
    }

    public ShowDetailDialog(Frame frame, String title, String message, String msgDetail, int messageType, boolean modal, boolean isShowTwoBtn, String btnOneText, String btnTwoText, char[] keys) {
        super(frame, title, modal);
        this.btnShowDetail.setVisible(false);
        this.btnShowDetail.setEnabled(false);
        this.jspDetail = new JScrollPane();
        this.pnlContent = new JPanel();
        this.pnlTop = new JPanel();
        this.pnlDetail = new JPanel();
        this.txtDetail = new JTextArea();
        this.btnCancelText = ResourceManager.getString("WizardFrame.Exit");
        this.btnContinueText = ResourceManager.getString("WizardFrame.Continue");
        this.lblImage = null;
        this.showDetail = null;
        this.btnCancelActionListener = null;
        this.btnContinueActionListener = null;
        this.btnShowDetailOrNotActionListener = null;
        this.isShowingDetail = false;
        this.showContinue = false;
        this.mneKeys = null;
        frame.setExtendedState(0);
        this.initDialog(title, message, msgDetail, messageType, isShowTwoBtn, btnOneText, btnTwoText, keys);
    }

    public ShowDetailDialog(Dialog dialog, String title, String message, String msgDetail, int messageType, boolean modal, boolean isShowTwoBtn, String btnOneText, String btnTwoText, char[] keys) {
        super(dialog, title, modal);
        this.btnShowDetail.setVisible(false);
        this.btnShowDetail.setEnabled(false);
        this.jspDetail = new JScrollPane();
        this.pnlContent = new JPanel();
        this.pnlTop = new JPanel();
        this.pnlDetail = new JPanel();
        this.txtDetail = new JTextArea();
        this.btnCancelText = ResourceManager.getString("WizardFrame.Exit");
        this.btnContinueText = ResourceManager.getString("WizardFrame.Continue");
        this.lblImage = null;
        this.showDetail = null;
        this.btnCancelActionListener = null;
        this.btnContinueActionListener = null;
        this.btnShowDetailOrNotActionListener = null;
        this.isShowingDetail = false;
        this.showContinue = false;
        this.mneKeys = null;
        this.initDialog(title, message, msgDetail, messageType, isShowTwoBtn, btnOneText, btnTwoText, keys);
    }

    private void initDialog(String title, String message, String msgDetail, Icon icon, boolean isShowContinue, String btnCancelText1, String btnContinueText1, char[] keys) {
        this.setTitle(title);
        this.setDialogInfo(message);
        this.setDetailMessage(msgDetail);
        this.setDialogIcon(icon);
        this.showContinue = isShowContinue;
        if (btnCancelText1 != null) {
            this.btnCancelText = btnCancelText1;
        }
        if (btnContinueText1 != null) {
            this.btnContinueText = btnContinueText1;
        }
        this.mneKeys = keys;
        this.setKeys();
        try {
            this.jbInit();
            this.initListener();
        }
        catch (Exception e) {
            LOGGER.error("init ui occurs error.", (Throwable)e);
        }
    }

    private void initDialog(String title, String message, String msgDetail, int messageType, boolean isShowTwoBtn, String btnOneText, String btnTwoText, char[] keys) {
        this.setTitle(title);
        this.setDialogInfo(message);
        this.setDetailMessage(msgDetail);
        switch (messageType) {
            case 3: {
                this.setDialogIcon(ICON_QUESTION);
                break;
            }
            case 2: {
                this.setDialogIcon(ICON_WARN);
                break;
            }
            case 0: {
                this.setDialogIcon(ICON_ERROR);
                break;
            }
            default: {
                this.setDialogIcon(ICON_INFO);
            }
        }
        this.showContinue = isShowTwoBtn;
        if (btnOneText != null) {
            this.btnCancelText = btnOneText;
        }
        if (btnTwoText != null) {
            this.btnContinueText = btnTwoText;
        }
        this.mneKeys = keys;
        this.setKeys();
        try {
            this.jbInit();
            this.initListener();
        }
        catch (Exception e) {
            LOGGER.error("init dialog occurs error.", (Throwable)e);
        }
    }

    private void setKeys() {
        if (this.mneKeys != null) {
            if (!(this.btnCancelText.equalsIgnoreCase(ResourceManager.getString("WizardFrame.cancel")) || this.btnCancelText.equalsIgnoreCase(ResourceManager.getString("WizardFrame.confirm")) || this.btnContinueText.equalsIgnoreCase(ResourceManager.getString("WizardFrame.cancel")) || this.btnContinueText.equalsIgnoreCase(ResourceManager.getString("WizardFrame.confirm")))) {
                this.btnCancel.setMnemonic(this.mneKeys[0]);
                if (this.mneKeys.length > 1) {
                    this.btnContinue.setMnemonic(this.mneKeys[1]);
                }
                if ("zh".equalsIgnoreCase(LANG)) {
                    ShowDetailDialog dlg = this;
                    dlg.btnCancelText = dlg.btnCancelText + "(" + this.mneKeys[0] + ')';
                    if (this.mneKeys.length > 1) {
                        ShowDetailDialog sdlg = this;
                        sdlg.btnContinueText = sdlg.btnContinueText + "(" + this.mneKeys[1] + ')';
                    }
                }
            }
        } else if (!(this.btnCancelText.equalsIgnoreCase(ResourceManager.getString("WizardFrame.cancel")) || this.btnCancelText.equalsIgnoreCase(ResourceManager.getString("WizardFrame.confirm")) || this.btnContinueText.equalsIgnoreCase(ResourceManager.getString("WizardFrame.cancel")) || this.btnContinueText.equalsIgnoreCase(ResourceManager.getString("WizardFrame.confirm")))) {
            this.btnCancel.setMnemonic('N');
            this.btnContinue.setMnemonic('E');
            if ("zh".equalsIgnoreCase(LANG)) {
                this.btnCancelText = this.btnCancelText + "(N)";
                this.btnContinueText = this.btnContinueText + "(E)";
            }
        }
        this.btnShowDetail.setMnemonic('D');
    }

    private void jbInit() {
        this.pnlContent.setLayout(new GridBagLayout());
        this.pnlTop.setLayout(new GridBagLayout());
        this.pnlContent.setBackground(Color.getColor("f0f0f0"));
        this.pnlTop.setBackground(Color.getColor("f0f0f0"));
        this.lblImage = new JLabel();
        if (dialogIcon != null) {
            this.lblImage.setIcon(dialogIcon);
        }
        this.lblImage.setBackground(Color.getColor("f0f0f0"));
        this.txtInfo.setAutoscrolls(true);
        this.txtInfo.setText(dialogInfo);
        this.txtInfo.setEditable(false);
        this.txtInfo.setFocusable(false);
        this.txtInfo.setForeground(Color.black);
        this.btnCancel.setText(this.btnCancelText);
        this.btnContinue.setText(this.btnContinueText);
        this.showDetail = new StringBuffer(ResourceManager.getString("WizardFrame.Detail"));
        if ("zh".equalsIgnoreCase(ResourceManager.getLocale().toString())) {
            this.showDetail.append("(D)");
        }
        this.btnShowDetail.setText(this.showDetail.toString() + " >>");
        this.pnlTop.add((Component)this.lblImage, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 18, 0, new Insets(12, 12, 6, 6), 0, 0));
        this.pnlTop.add((Component)this.txtInfo, new GridBagConstraints(1, 0, 4, 1, 0.0, 1.0, 12, 2, new Insets(20, 6, 6, 12), 0, 0));
        JPanel pnlBtn = new JPanel();
        pnlBtn.setBackground(BaseStyle.BACKGROUND_COLOR);
        this.btnShowDetail.setPreferredSize(new Dimension(120, 21));
        pnlBtn.add((Component)this.btnShowDetail, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(12, 3, 6, 3), 0, 0));
        this.btnContinue.setPreferredSize(new Dimension(120, 21));
        pnlBtn.add((Component)this.btnContinue, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 3, 6, 3), 0, 0));
        this.btnCancel.setPreferredSize(new Dimension(120, 21));
        pnlBtn.add((Component)this.btnCancel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 3, 6, 12), 0, 0));
        this.pnlContent.add((Component)this.pnlTop, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlContent.add((Component)pnlBtn, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.txtInfo.setBackground(Color.getColor("f0f0f0"));
        this.txtDetail.setText(detailMessage);
        this.txtDetail.setAutoscrolls(true);
        this.txtDetail.setLineWrap(true);
        this.txtDetail.setWrapStyleWord(true);
        this.txtDetail.setCaretPosition(0);
        this.txtDetail.setLineWrap(true);
        this.txtDetail.setEditable(false);
        this.txtDetail.setFocusable(true);
        this.border1 = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
        this.pnlDetail.setBorder(this.border1);
        this.jspDetail.getViewport().add(this.txtDetail);
        this.jspDetail.setAutoscrolls(true);
        this.pnlDetail.setLayout(new BorderLayout());
        this.pnlDetail.add(this.jspDetail);
        this.pnlContent.add((Component)this.pnlDetail, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 15, 2, new Insets(2, 2, 2, 2), 0, 0));
        if (!this.showContinue) {
            this.btnContinue.setVisible(false);
        }
        this.setModal(true);
        this.setContentPane(this.pnlContent);
        this.isShowingDetail = true;
        this.showDetailOrNot();
        this.isShowingDetail = false;
        this.showDetailOrNot();
        Dimension dScreen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dComponent = this.getSize();
        Point pos = new Point();
        pos.x = (int)(dScreen.getWidth() / 2.0 - dComponent.getWidth() / 2.0);
        pos.y = (int)(dScreen.getHeight() / 2.0 - dComponent.getHeight() / 2.0);
        this.setLocation(pos);
        this.setResizable(false);
        this.btnShowDetail.requestFocus();
    }

    public int getSelectedOption() {
        return this.selectedOption;
    }

    public void escape() {
        this.selectedOption = 4;
        this.dispose();
    }

    protected void cancel() {
        this.selectedOption = 1;
        this.dispose();
    }

    private void initListener() {
        this.btnCancelActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowDetailDialog.this.cancel();
            }
        };
        if (OptionPaneUI.isToHandleEscAndCls()) {
            this.btnCancel.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        ShowDetailDialog.this.escape();
                    }
                    super.keyPressed(e);
                }
            });
        }
        this.btnCancel.addActionListener(this.btnCancelActionListener);
        this.btnContinueActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowDetailDialog.this.doContinue();
            }
        };
        if (OptionPaneUI.isToHandleEscAndCls()) {
            this.btnContinue.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        ShowDetailDialog.this.escape();
                    }
                    super.keyPressed(e);
                }
            });
        }
        this.btnContinue.addActionListener(this.btnContinueActionListener);
        this.btnShowDetailOrNotActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowDetailDialog.this.showDetailOrNot();
            }
        };
        if (OptionPaneUI.isToHandleEscAndCls()) {
            this.btnShowDetail.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        ShowDetailDialog.this.escape();
                    }
                    super.keyPressed(e);
                }
            });
        }
        this.btnShowDetail.addActionListener(this.btnShowDetailOrNotActionListener);
        if (OptionPaneUI.isToHandleEscAndCls()) {
            this.windowAdapter = new WAdapter();
            this.addWindowListener(this.windowAdapter);
        }
        this.pnlContent.addKeyListener(new KAdapter());
        this.txtInfo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    ShowDetailDialog.this.escape();
                }
                super.keyPressed(e);
            }
        });
        this.txtDetail.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    ShowDetailDialog.this.escape();
                }
                super.keyPressed(e);
            }
        });
    }

    protected void showDetailOrNot() {
        int detailHeight = this.txtDetail.getHeight();
        Dimension dComponent = this.pnlTop.getSize();
        if (detailHeight > 170) {
            this.jspDetail.setPreferredSize(new Dimension(dComponent.width, 170));
        }
        if (this.isShowingDetail) {
            this.pnlDetail.setVisible(true);
            this.validate();
            this.pack();
            this.repaint();
            this.isShowingDetail = false;
            this.btnShowDetail.setText(this.showDetail + " <<");
        } else {
            this.pnlDetail.setVisible(false);
            this.validate();
            this.pack();
            this.repaint();
            this.isShowingDetail = true;
            this.btnShowDetail.setText(this.showDetail + " >>");
        }
    }

    protected void doContinue() {
        this.selectedOption = 0;
        this.dispose();
    }

    public void setDetailMessage(String detailMessageTemp) {
        ShowDetailDialog.setDetailMessageValue(detailMessageTemp);
    }

    public static void setDetailMessageValue(String detailMessageTemp) {
        detailMessage = detailMessageTemp;
    }

    public void setDialogInfo(String dialogInfoTemp) {
        ShowDetailDialog.setDialogInfoValue(dialogInfoTemp);
    }

    public static void setDialogInfoValue(String dialogInfoTemp) {
        dialogInfo = dialogInfoTemp;
    }

    public void setDialogIcon(Icon dialogIconTemp) {
        ShowDetailDialog.setDialogIconValue(dialogIconTemp);
    }

    public static void setDialogIconValue(Icon dialogIconTemp) {
        dialogIcon = dialogIconTemp;
    }

    private static class WAdapter
    extends WindowAdapter {
        private WAdapter() {
        }
    }

    private class KAdapter
    extends KeyAdapter {
        private KAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                ShowDetailDialog.this.escape();
            }
            super.keyPressed(e);
        }
    }
}

