/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ui.panel;

import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.model.ContextPropVal;
import com.huawei.elog.base.model.WizardDialog;
import com.huawei.elog.check.EnvCheckerContainer;
import com.huawei.elog.check.common.EntCheckUtil;
import com.huawei.elog.ui.card.install.IntroductionCard;
import com.huawei.elog.ui.panel.IConclusionInfo;
import com.huawei.elog.ui.panel.LinkLabel;
import com.huawei.elog.ui.panel.StyleTable;
import com.huawei.elog.util.ResourceManager;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConclusionInfoPanel
extends JPanel {
    private static JLabel phase1;
    private static JLabel phase2;
    private static JLabel phase4;
    private static final long serialVersionUID = -9069977597055725294L;
    private static final Logger LOGGER;
    private static final String OK_ICON = "icon_ok";
    private static final String ERROR_ICON = "icon_error";
    private static final String LOADING_ICON = "icon_loading";
    private static final String WARN_ICON = "icon_warn";
    private static String strChecking;
    private static StyleTable table;
    private static Box box;
    private static JPanel bootPanel;
    private static JLabel phase3;
    private static LinkLabel reCheckLabel;
    private Icon headIcon;
    private JLabel phase0;
    private JLabel phaseError;
    private JLabel phaseWarn;
    private JLabel phase5;
    private IConclusionInfo iConclusionInfo;
    private JPanel rootPanel;
    private IntroductionCard card;

    public ConclusionInfoPanel(IConclusionInfo iConclusionInfoParam) {
        this.init(iConclusionInfoParam);
    }

    public ConclusionInfoPanel(IConclusionInfo iConclusionInfo, StyleTable resultTable, JPanel bootPanel) {
        this.initPanel(bootPanel);
        this.init(iConclusionInfo, resultTable);
    }

    public ConclusionInfoPanel(IConclusionInfo iConclusionInfo, StyleTable resultTable, Box box, IntroductionCard card) {
        ConclusionInfoPanel.initBox(box);
        this.init(iConclusionInfo, resultTable);
        this.card = card;
    }

    public IConclusionInfo getiConclusionInfo() {
        return this.iConclusionInfo;
    }

    public void setiConclusionInfo(IConclusionInfo iConclusionInfoParam) {
        this.iConclusionInfo = iConclusionInfoParam;
    }

    private void init(IConclusionInfo iConclusionInfoParam) {
        this.init(iConclusionInfoParam, null);
    }

    private void initPanel(JPanel bootPanelParam) {
        if (null == bootPanel) {
            bootPanel = bootPanelParam;
        }
    }

    private static void initBox(Box boxParam) {
        box = boxParam;
    }

    private void init(IConclusionInfo iConclusionInfoParam, StyleTable resultTable) {
        this.rootPanel = this;
        this.iConclusionInfo = iConclusionInfoParam;
        strChecking = EntCheckUtil.getValue("EnvCheck.CI.Checking");
        this.phaseError = new JLabel(EntCheckUtil.getValue("EnvCheck.CI.Discovery.Error"));
        phase1 = new JLabel(strChecking);
        phase2 = new JLabel();
        phase3 = new JLabel();
        this.phaseWarn = new JLabel(EntCheckUtil.getValue("EnvCheck.CI.Discovery.Warn"));
        phase4 = new JLabel();
        this.phase5 = new JLabel();
        SpringLayout layout = new SpringLayout();
        this.setLayout(layout);
        this.headIcon = ResourceManager.getIcon(OK_ICON);
        this.phase0 = new JLabel(this.headIcon);
        this.add(this.phase0);
        this.add(phase1);
        this.add(this.phaseError);
        this.add(phase2);
        this.add(phase3);
        this.add(this.phaseWarn);
        this.add(phase4);
        this.add(this.phase5);
        table = resultTable;
        reCheckLabel = new LinkLabel(EntCheckUtil.getValue("EnvCheck.CI.Recheck"));
        reCheckLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Thread appThread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            ConclusionInfoPanel.this.updateTable();
                        }
                        catch (Exception e) {
                            LOGGER.error("modified table occurs error.", (Throwable)e);
                        }
                        LOGGER.debug("Finished on the thread.");
                    }
                };
                appThread.setName("checkLabelThread");
                appThread.start();
            }
        });
        this.add(reCheckLabel);
        layout.putConstraint("West", (Component)this.phase0, 5, "West", (Component)this);
        layout.putConstraint("North", (Component)this.phase0, 3, "North", (Component)this);
        layout.putConstraint("South", (Component)this.phase0, 0, "South", (Component)this);
        layout.putConstraint("West", (Component)phase1, 5, "East", (Component)this.phase0);
        layout.putConstraint("North", (Component)phase1, 3, "North", (Component)this);
        layout.putConstraint("South", (Component)phase1, 0, "South", (Component)this);
        layout.putConstraint("West", (Component)this.phaseError, 5, "East", (Component)this.phase0);
        layout.putConstraint("North", (Component)this.phaseError, 3, "North", (Component)this);
        layout.putConstraint("South", (Component)this.phaseError, 0, "South", (Component)this);
        layout.putConstraint("West", (Component)phase2, 0, "East", (Component)this.phaseError);
        layout.putConstraint("North", (Component)phase2, 3, "North", (Component)this);
        layout.putConstraint("South", (Component)phase2, 0, "South", (Component)this);
        layout.putConstraint("West", (Component)phase3, 1, "East", (Component)phase2);
        layout.putConstraint("North", (Component)phase3, 3, "North", (Component)this);
        layout.putConstraint("South", (Component)phase3, 0, "South", (Component)this);
        layout.putConstraint("North", (Component)this.phaseWarn, 3, "North", (Component)this);
        layout.putConstraint("South", (Component)this.phaseWarn, 0, "South", (Component)this);
        layout.putConstraint("West", (Component)phase4, 0, "East", (Component)this.phaseWarn);
        layout.putConstraint("North", (Component)phase4, 3, "North", (Component)this);
        layout.putConstraint("South", (Component)phase4, 0, "South", (Component)this);
        layout.putConstraint("West", (Component)this.phase5, 1, "East", (Component)phase4);
        layout.putConstraint("North", (Component)this.phase5, 3, "North", (Component)this);
        layout.putConstraint("South", (Component)this.phase5, 0, "South", (Component)this);
        layout.putConstraint("East", (Component)reCheckLabel, -5, "East", (Component)this);
        layout.putConstraint("North", (Component)reCheckLabel, 3, "North", (Component)this);
        layout.putConstraint("South", (Component)reCheckLabel, 0, "South", (Component)this);
    }

    public void refreshByCheck() {
        SpringLayout layout = (SpringLayout)this.getLayout();
        this.phaseError.setText(EntCheckUtil.getValue("EnvCheck.CI.Discovery.Error"));
        phase2.setText(String.valueOf(this.iConclusionInfo.getErrorNum()));
        phase4.setText(String.valueOf(this.iConclusionInfo.getWarningNum()));
        this.phase5.setText(EntCheckUtil.getValue("EnvCheck.CI.Discovery.separator3"));
        phase1.setVisible(false);
        if (null != box) {
            box.getComponent(1).setVisible(true);
            reCheckLabel.setVisible(true);
        }
        if (this.iConclusionInfo.getErrorNum() > 0 && this.iConclusionInfo.getWarningNum() > 0) {
            this.headIcon = ResourceManager.getIcon(ERROR_ICON);
            this.getP3String(true);
            this.phaseError.setVisible(true);
            phase2.setVisible(true);
            phase3.setVisible(true);
            this.phaseWarn.setVisible(true);
            phase4.setVisible(true);
            this.phase5.setVisible(true);
            layout.putConstraint("West", (Component)this.phaseWarn, 1, "East", (Component)phase3);
        } else if (this.iConclusionInfo.getErrorNum() > 0 && this.iConclusionInfo.getWarningNum() == 0) {
            this.headIcon = ResourceManager.getIcon(ERROR_ICON);
            this.getP3String(false);
            this.phaseError.setVisible(true);
            phase2.setVisible(true);
            phase3.setVisible(true);
            this.phaseWarn.setVisible(false);
            phase4.setVisible(false);
            this.phase5.setVisible(false);
            layout.putConstraint("West", (Component)this.phaseWarn, 1, "East", (Component)phase3);
        } else if (this.iConclusionInfo.getErrorNum() == 0 && this.iConclusionInfo.getWarningNum() > 0) {
            this.headIcon = ResourceManager.getIcon(WARN_ICON);
            this.getP3String(false);
            this.phaseError.setVisible(false);
            phase2.setVisible(false);
            phase3.setVisible(false);
            this.phaseWarn.setVisible(true);
            phase4.setVisible(true);
            this.phase5.setVisible(true);
            layout.putConstraint("West", (Component)this.phaseWarn, 1, "East", (Component)this.phase0);
        } else {
            this.getP3String(false);
            this.phaseError.setText(EntCheckUtil.getValue("EnvCheck.OK"));
            this.phaseError.setVisible(true);
            phase2.setVisible(false);
            phase3.setVisible(false);
            this.phaseWarn.setVisible(false);
            phase4.setVisible(false);
            this.phase5.setVisible(false);
            this.headIcon = ResourceManager.getIcon(OK_ICON);
            reCheckLabel.setVisible(false);
            if (null != box) {
                box.getComponent(1).setVisible(false);
            }
        }
        this.phase0.setIcon(this.headIcon);
    }

    private void getP3String(boolean haveWarn) {
        if (haveWarn) {
            phase3.setText(EntCheckUtil.getValue("EnvCheck.CI.Discovery.separator1"));
        } else {
            phase3.setText(EntCheckUtil.getValue("EnvCheck.CI.Discovery.separator2"));
        }
    }

    public void updateTable() {
        Thread updateTableThread = new Thread(){

            @Override
            public void run() {
                try {
                    ConclusionInfoPanel.this.setNextBtnStatus(false);
                    ConclusionInfoPanel.this.card.setUpgardeInfoStatus(false);
                }
                catch (Exception e) {
                    LOGGER.error("updateTable occurs error.", (Throwable)e);
                }
                ConclusionInfoPanel.this.headIcon = ResourceManager.getIcon(ConclusionInfoPanel.LOADING_ICON);
                ConclusionInfoPanel.this.phase0.setIcon(ConclusionInfoPanel.this.headIcon);
                reCheckLabel.setVisible(false);
                phase1.setVisible(true);
                ConclusionInfoPanel.this.phaseError.setVisible(false);
                phase2.setVisible(false);
                phase3.setVisible(false);
                ConclusionInfoPanel.this.phaseWarn.setVisible(false);
                phase4.setVisible(false);
                ConclusionInfoPanel.this.phase5.setVisible(false);
                ConclusionInfoPanel.this.rootPanel.invalidate();
                ConclusionInfoPanel.this.rootPanel.getParent().invalidate();
                EnvCheckerContainer ecc = EnvCheckerContainer.getInstance();
                ecc.doCheck();
                int errnoNum = ecc.getErrorNum();
                int warningNum = ecc.getWarningNum();
                phase2.setText(String.valueOf(errnoNum));
                phase4.setText(String.valueOf(warningNum));
                ConclusionInfoPanel.this.refreshByCheck();
                StyleTable.adjustColumnPreferredWidths(table);
                ecc.fireTableDataChanged();
                try {
                    if (EnvCheckerContainer.getInstance().getErrorNum() > 0) {
                        ConclusionInfoPanel.this.setNextBtnStatus(false);
                    } else {
                        ConclusionInfoPanel.this.setNextBtnStatus(true);
                        ConclusionInfoPanel.this.card.setUpgardeInfoStatus(true);
                    }
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        };
        updateTableThread.setName("updateTableThread");
        updateTableThread.start();
    }

    private void setNextBtnStatus(boolean enabled) {
        WizardDialog.Card thisCard;
        Map<WizardDialog.Navigation, JButton> naviButtons;
        JButton nextBtn;
        ContextPropVal propVal = InstallContext.getInstance().getPropertyMap().getProp("lego.wizard.active.card");
        if (null != propVal && null != (nextBtn = (naviButtons = (thisCard = (WizardDialog.Card)propVal.getValue()).getNavigationButtons()).get((Object)WizardDialog.Navigation.Next))) {
            nextBtn.setEnabled(enabled);
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(ConclusionInfoPanel.class);
        strChecking = "";
        box = null;
        bootPanel = null;
    }
}

