/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ui.panel;

import com.huawei.elog.util.ResourceManager;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutedResultTable
extends JTable {
    private static final long serialVersionUID = -212257439297137509L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutedResultTable.class);
    private int taskIndex;

    public ExecutedResultTable(TableModel tdm) {
        super(tdm);
        this.setEnabled(true);
        this.paintColorButtonRow();
    }

    public void paintColorButtonRow() {
        TableColumnModel tcm = this.getColumnModel();
        if (tcm.getColumnCount() < 1) {
            return;
        }
        TableColumn tc = tcm.getColumn(0);
        tc.setCellRenderer(new ResultLabelRenderer());
    }

    public int getTaskIndex() {
        return this.taskIndex;
    }

    public void setTaskIndex(int taskIndex) {
        this.taskIndex = taskIndex;
    }

    private class ResultLabelRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 6636559633247453109L;

        private ResultLabelRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ImageIcon icon = null;
            LOGGER.debug("===================================taskIndex: {}, row: {} ", (Object)ExecutedResultTable.this.taskIndex, (Object)row);
            icon = ExecutedResultTable.this.taskIndex >= row ? ResourceManager.getIcon("yes") : ResourceManager.getIcon("icon_help");
            JPanel panel = new JPanel();
            JLabel label = new JLabel(icon);
            label.setOpaque(false);
            panel.add(label);
            panel.setToolTipText(table.getColumnName(column));
            this.setIcon(icon);
            return panel;
        }
    }
}

