/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ui.panel;

import com.huawei.elog.check.common.EntCheckUtil;
import com.huawei.elog.check.ui.IColorReader;
import com.huawei.elog.check.ui.MultiLineCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class StyleTable
extends JTable {
    private static final long serialVersionUID = 6087642799920889506L;
    private IColorReader colors = null;

    public StyleTable() {
    }

    public StyleTable(TableModel tdm, IColorReader colors) {
        super(tdm);
        this.setEnabled(true);
        this.colors = colors;
        this.paintColorButtonRow();
    }

    public void paintRow() {
        TableColumnModel tcm = this.getColumnModel();
        int n = tcm.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tc = tcm.getColumn(i);
            tc.setCellRenderer(new RowRenderer());
        }
    }

    public void paintColorButtonRow() {
        TableColumnModel tcm = this.getColumnModel();
        int n = tcm.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tc = tcm.getColumn(i);
            tc.setCellRenderer(new RowColorRenderer());
        }
        if (tcm.getColumnCount() < 1) {
            return;
        }
    }

    public void fitTableColumns(JTable myTable) {
        myTable.setAutoResizeMode(0);
        JTableHeader header = myTable.getTableHeader();
        header.setReorderingAllowed(false);
        int rowCount = myTable.getRowCount();
        Enumeration<TableColumn> columns = myTable.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            int col = header.getColumnModel().getColumnIndex(column.getIdentifier());
            int width = (int)header.getDefaultRenderer().getTableCellRendererComponent(myTable, column.getIdentifier(), false, false, -1, col).getPreferredSize().getWidth();
            for (int row = 0; row < rowCount; ++row) {
                int preferedWidth = (int)myTable.getCellRenderer(row, col).getTableCellRendererComponent(myTable, myTable.getValueAt(row, col), false, false, row, col).getPreferredSize().getWidth();
                width = Math.max(width, preferedWidth);
            }
            header.setResizingColumn(column);
            header.setPreferredSize(new Dimension(width + myTable.getIntercellSpacing().width, 40));
        }
    }

    public static void adjustColumnPreferredWidths(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        int colCount = table.getColumnCount();
        for (int col = 0; col < colCount; ++col) {
            int width = 0;
            TableColumn column = columnModel.getColumn(col);
            width = col == 4 ? 30 : (col == 1 ? 200 : 80);
            column.setPreferredWidth(width);
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return 4 == column;
    }

    public static void adjustRowPreferredWidths(JTable table) {
        table.setDefaultRenderer(String.class, new MultiLineCellRenderer());
    }

    public static void adjustHeader(JTable table) {
        table.getTableHeader().setReorderingAllowed(false);
    }

    private class RowColorRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -924071035665066884L;

        private RowColorRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable t, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(t, value, isSelected, hasFocus, row, column);
            String color = StyleTable.this.colors.getColor(row).trim();
            Color bg = EntCheckUtil.getColorByString(color);
            this.setBackground(bg);
            return super.getTableCellRendererComponent(t, value, isSelected, hasFocus, row, column);
        }
    }

    private static class RowRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -5736484858467786054L;

        private RowRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable t, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(t, value, isSelected, hasFocus, row, column);
            if (row % 2 == 0) {
                this.setBackground(Color.BLUE);
            } else {
                this.setBackground(Color.GREEN);
            }
            return super.getTableCellRendererComponent(t, value, isSelected, hasFocus, row, column);
        }
    }
}

