/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ui.table;

import com.huawei.elog.ui.table.CheckTableModle;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class CheckHeaderCellRenderer
implements TableCellRenderer {
    private final CheckTableModle tableModel;
    private final JTableHeader tableHeader;
    private final JCheckBox selectBox;

    public CheckHeaderCellRenderer(JTable table) {
        this.tableModel = (CheckTableModle)table.getModel();
        this.tableHeader = table.getTableHeader();
        this.selectBox = new JCheckBox(this.tableModel.getColumnName(0));
        this.selectBox.setSelected(false);
        this.tableHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int selectColumn;
                if (e.getClickCount() > 0 && (selectColumn = CheckHeaderCellRenderer.this.tableHeader.columnAtPoint(e.getPoint())) == 0) {
                    boolean value = !CheckHeaderCellRenderer.this.selectBox.isSelected();
                    CheckHeaderCellRenderer.this.tableModel.selectAllOrNull(value);
                    CheckHeaderCellRenderer.this.tableHeader.repaint();
                }
            }
        });
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String valueStr = (String)value;
        JLabel label = new JLabel(valueStr);
        label.setHorizontalAlignment(0);
        this.selectBox.setHorizontalAlignment(0);
        this.selectBox.setBorderPainted(true);
        JComponent component = column == 0 ? this.selectBox : label;
        component.setForeground(this.tableHeader.getForeground());
        component.setBackground(this.tableHeader.getBackground());
        component.setFont(this.tableHeader.getFont());
        component.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        return component;
    }
}

