/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ui.util;

import com.huawei.elog.util.ResourceManager;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CMDHelper {
    private static final Logger LOG = LoggerFactory.getLogger(CMDHelper.class);
    private static final String ENCODING_GB2312 = "GB2312";
    private static final String ENCODING_UTF8 = "UTF-8";
    private static CMDHelper instance = null;
    private static PrintStream ps;
    private static boolean ecodingErrFlag;

    private CMDHelper() {
        this.initializePrintStream();
    }

    public static CMDHelper getInstance() {
        if (null == instance) {
            instance = new CMDHelper();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePrintStream() {
        Locale locale = ResourceManager.getLocale();
        if (locale.equals(Locale.CHINESE)) {
            try {
                CMDHelper.setPs(new PrintStream((OutputStream)System.out, true, ENCODING_GB2312));
            }
            catch (UnsupportedEncodingException e) {
                CMDHelper.seteCodingErrFlag(true);
                LOG.error("Unsupported encoding : GB2312", (Throwable)e);
                try {
                    CMDHelper.setPs(new PrintStream((OutputStream)System.out, true, ENCODING_UTF8));
                    CMDHelper.seteCodingErrFlag(false);
                }
                catch (UnsupportedEncodingException e1) {
                    CMDHelper.seteCodingErrFlag(true);
                    LOG.error("Unsupported encoding : UTF-8", (Throwable)e);
                }
            }
            finally {
                if (ecodingErrFlag) {
                    try {
                        CMDHelper.setPs(new PrintStream((OutputStream)System.out, true, ENCODING_UTF8));
                    }
                    catch (UnsupportedEncodingException e) {
                        LOG.error("Unsupported encoding : UTF-8", (Throwable)e);
                    }
                }
            }
        } else {
            try {
                CMDHelper.setPs(new PrintStream((OutputStream)System.out, true, "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                LOG.error("UnsupportedEncoding:", (Throwable)e);
            }
        }
    }

    public void print(String text) {
        ps.print(text);
    }

    public void println(String text) {
        ps.println(text);
    }

    public static void seteCodingErrFlag(boolean ecodingErrFlagTemp) {
        ecodingErrFlag = ecodingErrFlagTemp;
    }

    public static void setPs(PrintStream pstemp) {
        ps = pstemp;
    }

    static {
        ecodingErrFlag = false;
    }
}

