/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ui.util;

import com.huawei.elog.util.PropertyManager;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RunningLock {
    private static final Logger LOGGER = LoggerFactory.getLogger(RunningLock.class);
    private static String ifAnotherInstanceRunning = null;
    private static final String DEFAULT_LOCK_FILE_NAME = ".LogCenterLockFile";
    private static String installDiskLockFolderPath = RunningLock.getTempFolder();
    private static FileChannel channel = null;
    private static RandomAccessFile raf = null;
    private static FileLock lock = null;
    private static RunningLock instance = new RunningLock();

    private RunningLock() {
    }

    public static FileChannel getChannel() {
        return channel;
    }

    public void setChannel(FileChannel channel) {
        RunningLock.setChannelValue(channel);
    }

    public static void setChannelValue(FileChannel achannel) {
        channel = achannel;
    }

    public static FileLock getLock() {
        return lock;
    }

    public void setLock(FileLock lock) {
        RunningLock.setLockValue(lock);
    }

    public static void setLockValue(FileLock alock) {
        lock = alock;
    }

    public static RunningLock getInstance() {
        return instance;
    }

    public boolean isAnotherInstanceRunning() {
        boolean retValue = false;
        if (ifAnotherInstanceRunning == null) {
            String lockFile = RunningLock.getInstallDiskLockTempPath() + File.separator + this.getLockFileName();
            File f = new File(lockFile);
            LOGGER.debug("lock file path exist: {}", (Object)f.exists());
            if (!f.exists()) {
                try {
                    boolean b = f.createNewFile();
                    LOGGER.debug("create lock file and result: {}", (Object)b);
                }
                catch (IOException e) {
                    LOGGER.error("create lock file occurs error. ", (Throwable)e);
                }
            }
            try {
                RunningLock.setRaf(new RandomAccessFile(lockFile, "rw"));
                this.setChannel(raf.getChannel());
                this.setLock(channel.tryLock());
                if (lock == null) {
                    retValue = true;
                }
            }
            catch (IOException localIOException) {
                retValue = true;
            }
            if (retValue) {
                RunningLock.setIfAnotherInstanceRunning("true");
            } else {
                RunningLock.setIfAnotherInstanceRunning("false");
            }
        } else if (ifAnotherInstanceRunning.equalsIgnoreCase("true")) {
            retValue = true;
        } else if (ifAnotherInstanceRunning.equalsIgnoreCase("false")) {
            retValue = false;
        }
        return retValue;
    }

    public void deleteLockTempFile() {
        String lockFile = RunningLock.getInstallDiskLockTempPath() + File.separator + this.getLockFileName();
        try {
            File file;
            if (lock != null && lock.isValid()) {
                lock.release();
                if (channel != null) {
                    channel.close();
                }
                if (raf != null) {
                    raf.close();
                }
            }
            if ((file = new File(lockFile)).exists()) {
                boolean b = file.delete();
                LOGGER.debug("Release the lock and del the file and the result:{} ", (Object)b);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to release the lock and del the file: {} ", (Throwable)e);
        }
    }

    private static String getTempFolder() {
        boolean isCreated = true;
        String osName = System.getProperty("os.name");
        File tempFolder = null;
        if (osName.indexOf("Windows") != -1 && !osName.equalsIgnoreCase("Windows98")) {
            StringBuffer folderPath = new StringBuffer("");
            String systemRootPath = System.getProperty("windir");
            if (systemRootPath != null) {
                int slashIndex = systemRootPath.indexOf("\\");
                if (slashIndex != -1) {
                    folderPath = new StringBuffer(systemRootPath.substring(0, slashIndex));
                    folderPath.append("/Temp");
                } else {
                    isCreated = false;
                }
                tempFolder = new File(folderPath.toString());
                if (!tempFolder.exists()) {
                    isCreated = tempFolder.mkdir();
                }
            } else {
                isCreated = false;
            }
        } else {
            isCreated = false;
        }
        if (isCreated) {
            try {
                return tempFolder.getCanonicalPath();
            }
            catch (IOException e) {
                LOGGER.error("path error", (Throwable)e);
            }
        }
        return System.getProperty("java.io.tmpdir");
    }

    private String getLockFileName() {
        String lockFileName = PropertyManager.getProValue("LockFileName");
        if (null == lockFileName || lockFileName.length() == 0) {
            lockFileName = DEFAULT_LOCK_FILE_NAME;
        }
        return lockFileName;
    }

    private static String getInstallDiskLockTempPath() {
        return installDiskLockFolderPath;
    }

    private static void setIfAnotherInstanceRunning(String iair) {
        ifAnotherInstanceRunning = iair;
    }

    private static void setRaf(RandomAccessFile rafTemp) {
        raf = rafTemp;
    }
}

