/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ui.window;

import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.ui.window.ShutdownWindow;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.ResourceManager;
import com.huawei.elog.util.ServiceUtil;
import javax.swing.JProgressBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShutDownWindowsThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShutDownWindowsThread.class);
    private static ShutDownWindowsThread sthread = null;
    private boolean feedBack = false;
    private boolean isFinished = false;
    private int maxNumber = 100;
    private int speed = 1000;

    private ShutDownWindowsThread() {
    }

    public static ShutDownWindowsThread getInstance() {
        if (null == sthread) {
            sthread = new ShutDownWindowsThread();
        }
        return sthread;
    }

    public int getMaxNumber() {
        return this.maxNumber;
    }

    public int getSpeed() {
        return this.speed;
    }

    public boolean isFeedBack() {
        return this.feedBack;
    }

    public boolean isIsFinished() {
        return this.isFinished;
    }

    @Override
    public void run() {
        int currentValue = 0;
        JProgressBar bar = null;
        currentValue = ShutdownWindow.getInstance().getProgressBar().getValue();
        bar = ShutdownWindow.getInstance().getProgressBar();
        LOGGER.debug("..........!isFinished......." + !this.isFinished);
        int i = 0;
        while (!this.isFinished) {
            boolean isWebRunShut = true;
            isWebRunShut = ServiceUtil.isServiceRunning("LEGOWebSrv");
            LOGGER.debug("..........maxNumber...currentValue...." + this.maxNumber + "  " + currentValue);
            if (!isWebRunShut && this.maxNumber == 10 && currentValue < 13 && ++i > 2000) {
                OptionPane.showInfoDialog(ResourceManager.getString("VSM.SYSTEM.ERROR"));
                CommonUtil.shutDownJvm(1);
            }
            if (currentValue < this.maxNumber) {
                bar.setValue(currentValue++);
                try {
                    Thread.sleep(this.speed);
                }
                catch (InterruptedException e) {
                    LOGGER.error("close io occurs error.", (Throwable)e);
                }
            }
            LOGGER.debug("..........!isFinishedin : " + !this.isFinished);
        }
        LOGGER.debug(" while (!isFinished) is isFinished");
        while (currentValue < 100) {
            this.speed = 50;
            LOGGER.debug("currentValue : " + currentValue);
            bar.setValue(++currentValue);
            try {
                Thread.sleep(this.speed);
            }
            catch (InterruptedException e) {
                LOGGER.error("thread sleep occurs error.", (Throwable)e);
            }
        }
        LOGGER.debug(" while (currentValue < 100) is isFinished");
        this.feedBack = true;
    }

    public void setFeedBack(boolean feedBack) {
        this.feedBack = feedBack;
    }

    public void setFinished(boolean finished) {
        this.isFinished = finished;
    }

    public void setMaxNumber(int maxNumber) {
        this.maxNumber = maxNumber;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }
}

