/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ui.window;

import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.context.ContextLoader;
import com.huawei.elog.base.exception.AccessException;
import com.huawei.elog.base.exception.StartException;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.ui.util.CMDHelper;
import com.huawei.elog.ui.util.RunningLock;
import com.huawei.elog.ui.window.SetStartWindowsThread;
import com.huawei.elog.ui.window.ShutDownWindowsThread;
import com.huawei.elog.ui.window.StartActionInvoke;
import com.huawei.elog.ui.window.WindowHolder;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.PropertyManager;
import com.huawei.elog.util.ResourceManager;
import com.huawei.elog.util.UIUtil;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShutdownWindow
extends JWindow {
    private static final long serialVersionUID = 9026229909948126055L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ShutdownWindow.class);
    private static ShutdownWindow sInstance = null;
    private static String softName = "";
    private JLabel jl1 = null;
    private JProgressBar progressBar;

    private ShutdownWindow() {
        this.addItem();
    }

    public static ShutdownWindow getInstance() {
        if (null == sInstance) {
            sInstance = new ShutdownWindow();
        }
        return sInstance;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setProgressBar(JProgressBar progressBar) {
        this.progressBar = progressBar;
    }

    public JLabel getJl1() {
        return this.jl1;
    }

    public void setJl1(JLabel jl1) {
        this.jl1 = jl1;
    }

    private void addItem() {
        try {
            this.setSize(400, 85);
            this.setEnabled(true);
            this.setAlwaysOnTop(true);
            int windowWidth = this.getWidth();
            int windowHeight = this.getHeight();
            Toolkit kit = Toolkit.getDefaultToolkit();
            Dimension screenSize = kit.getScreenSize();
            int screenWidth = screenSize.width;
            int screenHeight = screenSize.height;
            this.setLocation(screenWidth / 2 - windowWidth / 2, screenHeight / 2 - windowHeight / 2);
            this.setLayout(null);
            ImageIcon img = ResourceManager.getIcon("loading-balls");
            String softWareName = PropertyManager.getProValue("software.install.name");
            this.jl1 = InstallContext.getInstance().getInstallType().contains("Collector") ? new JLabel(ResourceManager.getString("LEGO.SHUTDOWN.INIT", "Collector")) : new JLabel(ResourceManager.getString("LEGO.SHUTDOWN.INIT", softWareName));
            this.jl1.setBounds(10, 10, 380, 30);
            this.jl1.setIcon(img);
            this.add(this.jl1);
            this.progressBar = new JProgressBar(1, 100);
            this.progressBar.setBounds(10, 45, 380, 30);
            this.progressBar.setStringPainted(true);
            this.progressBar.setValue(0);
            this.progressBar.setStringPainted(true);
            this.add(this.progressBar);
            this.setVisible(true);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("add item occurs error.", (Throwable)e);
        }
    }

    private static void testRunning() {
        if (RunningLock.getInstance().isAnotherInstanceRunning()) {
            LOGGER.error("There is another startaction or shutdownaction program running. Please exit the program before startaction.");
            String errMsg = ResourceManager.getString("AnotherInstance.shutdownRunning");
            OptionPane.showErrorDialog(errMsg);
            if (UIUtil.isSilentMode()) {
                CMDHelper.getInstance().println(errMsg);
            }
            CommonUtil.shutDownJvm(-1);
        }
    }

    public static void main(String[] args) {
        ShutdownWindow.testRunning();
        if (null != args && args.length > 0 && (args[0].equals("shutdownelog") || args[0].equals("shutdownddos"))) {
            InstallContext.getInstance().setInstallType("Collector");
        }
        if (null == args || args.length < 1) {
            softName = PropertyManager.getProValue("software.install.name");
        } else if (args[0].equalsIgnoreCase("shutdownelog")) {
            softName = PropertyManager.getProValue("collector.software.install.elog");
        }
        ContextLoader.loadConetext();
        LOGGER.debug("softName: " + softName, (Object)"main");
        if (null != args && args.length > 0 && args[0].equals("eSight2eLog")) {
            ShutdownWindow.initWindowHide();
        } else {
            ShutdownWindow.initWindow();
        }
        if (null == args || args.length < 1) {
            ShutdownWindow.startup(false);
        } else if (args[0].equalsIgnoreCase("shutdownelog")) {
            ShutdownWindow.shutdownelog();
        } else if (args[0].equalsIgnoreCase("shutdownddos")) {
            LOGGER.debug("args[0].is shutdownddos", (Object)"ShutdownWindow");
        } else if (args[0].equals("eSight2eLog")) {
            ShutdownWindow.startup(true);
        }
    }

    private static void initWindow() {
        WindowHolder.getInstance().setActiveWindow(ShutdownWindow.getInstance());
        ShutdownWindow.getInstance().setVisible(true);
        ShutDownWindowsThread.getInstance().setSpeed(1000);
        ShutDownWindowsThread.getInstance().start();
    }

    private static void initWindowHide() {
        ShutdownWindow.getInstance().setVisible(false);
        ShutDownWindowsThread.getInstance().setSpeed(1000);
        ShutDownWindowsThread.getInstance().start();
    }

    private static void startup(Boolean bEsight) {
        boolean needShutDown = false;
        try {
            StartActionInvoke.shutdownMonitor();
            StartActionInvoke.shutdownProductService();
            StartActionInvoke.shutdownLego();
            if (bEsight.booleanValue()) {
                CommonUtil.shutDownJvm(0);
            }
            ShutdownWindow.dealWithProcess();
            LOGGER.info("------------  //LogCenter stopped succeed, congratulate you!//  ------------", (Object)"shoutdown");
        }
        catch (AccessException e) {
            LOGGER.error("StutDown Error: " + e + e.getErrorCode() + ", meg: " + e.getMessage());
            String errorMessage = ResourceManager.getString("start.err." + e.getErrorCode());
            ShutdownWindow.getInstance().setVisible(false);
            if (!bEsight.booleanValue()) {
                OptionPane.showErrorDialog(errorMessage);
            }
            CommonUtil.shutDownJvm(1);
        }
        catch (StartException e) {
            LOGGER.error("ShutDown Error:", (Throwable)e);
            ShutdownWindow.getInstance().setVisible(false);
            if (!bEsight.booleanValue()) {
                OptionPane.showErrorDialog(ResourceManager.getString("start.err." + e.getMessage()));
            }
            CommonUtil.shutDownJvm(1);
        }
        catch (Exception e) {
            LOGGER.error("ShutDown Error:", (Throwable)e);
            ShutdownWindow.getInstance().setVisible(false);
            if (!bEsight.booleanValue()) {
                OptionPane.showErrorDialog(ResourceManager.getString("start.err." + e.getMessage()));
            }
            if (needShutDown) {
                ShutdownWindow.shutDownLego();
            }
            CommonUtil.shutDownJvm(1);
        }
        ShutdownWindow.getInstance().setVisible(false);
        if (!bEsight.booleanValue()) {
            OptionPane.showInfoDialog(ResourceManager.getString("LEGO.SHUTDOWN.SUCCESS", softName));
        }
        CommonUtil.shutDownJvm(0);
    }

    private static void shutDownLego() {
        ShutdownWindow.getInstance().setVisible(true);
        ShutDownWindowsThread.getInstance().start();
        try {
            StartActionInvoke.shutdownLego();
            ShutDownWindowsThread.getInstance().setFinished(true);
            while (!ShutDownWindowsThread.getInstance().isFeedBack()) {
                Thread.sleep(500L);
            }
            ShutdownWindow.getInstance().getProgressBar().setValue(100);
        }
        catch (Exception e) {
            LOGGER.error("shutdown Error:", (Throwable)e);
        }
    }

    private static void dealWithProcess() throws InterruptedException {
        LOGGER.debug("dealWithProcess : before setFinished");
        ShutDownWindowsThread.getInstance().setFinished(true);
        LOGGER.debug("dealWithProcess : after setFinished");
        while (!ShutDownWindowsThread.getInstance().isFeedBack()) {
            Thread.sleep(500L);
            LOGGER.debug("while  !SetStartWindowsThread.getInstance().isFeedBack()  " + !SetStartWindowsThread.getInstance().isFeedBack());
        }
        ShutdownWindow.getInstance().getProgressBar().setValue(100);
    }

    private static void shutdownelog() {
        try {
            StartActionInvoke.shutdownElog();
            ShutdownWindow.dealWithProcess();
        }
        catch (AccessException e) {
            ShutdownWindow.getInstance().setVisible(false);
            LOGGER.error("StutDown Error:" + e + "Error Code " + e.getErrorCode(), (Object)"shutdownelog");
            OptionPane.showErrorDialog(ResourceManager.getString("start.err." + e.getErrorCode()));
            CommonUtil.shutDownJvm(0);
        }
        catch (StartException e) {
            ShutdownWindow.getInstance().setVisible(false);
            LOGGER.error("StutDown Error:" + e + "Error Code " + e.getErrorCode(), (Object)"shutdownelog");
            OptionPane.showErrorDialog(ResourceManager.getString("stop.err." + e.getErrorCode()));
            CommonUtil.shutDownJvm(0);
        }
        catch (Exception e) {
            LOGGER.error("StutDown Error:" + e, (Object)"shutdownelog");
            OptionPane.showErrorDialog(ResourceManager.getString("start.err." + e.getMessage()));
            CommonUtil.shutDownJvm(0);
        }
        ShutdownWindow.getInstance().setVisible(false);
        OptionPane.showInfoDialog(ResourceManager.getString("LEGO.SHUTDOWN.SUCCESS", PropertyManager.getProValue("collector.software.install.elog")));
        CommonUtil.shutDownJvm(0);
    }
}

