/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.ui.window;

import com.huawei.elog.action.StartupAction;
import com.huawei.elog.base.InstallContext;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.ui.util.CMDHelper;
import com.huawei.elog.ui.util.JFrameUtil;
import com.huawei.elog.ui.util.RunningLock;
import com.huawei.elog.ui.window.SetStartWindowsThread;
import com.huawei.elog.ui.window.WindowHolder;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.ResourceManager;
import com.huawei.elog.util.UIUtil;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StartWindow
extends JWindow {
    private static final long serialVersionUID = 9026229909948126055L;
    private static final Logger LOGGER = LoggerFactory.getLogger(StartWindow.class);
    private static StartWindow instance = null;
    private String softName;
    private JLabel jl1 = null;
    private JProgressBar progressBar;

    private StartWindow() {
    }

    public static StartWindow getInstance() {
        if (null == instance) {
            instance = new StartWindow();
        }
        return instance;
    }

    private void initUI() {
        try {
            this.setLayout(null);
            ImageIcon img = ResourceManager.getIcon("loading-balls");
            this.jl1 = InstallContext.getInstance().getInstallType().contains("Collector") ? new JLabel(ResourceManager.getString("LEGO.START.INIT", "Collector")) : new JLabel(ResourceManager.getString("LEGO.START.INIT", this.softName));
            this.jl1.setBounds(10, 10, 380, 30);
            this.jl1.setIcon(img);
            this.add(this.jl1);
            this.setSize(400, 85);
            this.setEnabled(true);
            this.setAlwaysOnTop(true);
            this.setLocation(JFrameUtil.getScreenCenterPoint(this));
            this.progressBar = new JProgressBar(1, 100);
            this.progressBar.setBounds(10, 45, 380, 30);
            this.progressBar.setStringPainted(true);
            this.progressBar.setValue(0);
            this.progressBar.setStringPainted(true);
            this.add(this.progressBar);
        }
        catch (Exception e) {
            LOGGER.error("addItem", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        StartWindow launcher = new StartWindow();
        launcher.testRunning();
        StartupAction.launch(args);
    }

    private void testRunning() {
        if (RunningLock.getInstance().isAnotherInstanceRunning()) {
            LOGGER.error("There is another startaction or shutdownaction program running. Please exit the program before startaction or shutdownaction.");
            String errMsg = ResourceManager.getString("AnotherInstance.startRunning");
            OptionPane.showErrorDialog(errMsg);
            if (UIUtil.isSilentMode()) {
                CMDHelper.getInstance().println(errMsg);
            }
            CommonUtil.shutDownJvm(-1);
        }
    }

    public void showWindow(boolean isShow) {
        if (isShow) {
            this.initUI();
            WindowHolder.getInstance().setActiveWindow(this);
            StartWindow.getInstance().setVisible(true);
            SetStartWindowsThread.getInstance().start();
        } else {
            SetStartWindowsThread.getInstance().setEnable(false);
            StartWindow.getInstance().setVisible(false);
            this.dispose();
        }
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setProgressBar(JProgressBar progressBar) {
        this.progressBar = progressBar;
    }

    public JLabel getJl1() {
        return this.jl1;
    }

    public void setJl1(JLabel jl1) {
        this.jl1 = jl1;
    }

    public String getSoftName() {
        return this.softName;
    }

    public void setSoftName(String softName) {
        this.softName = softName;
    }
}

