/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import com.huawei.elog.util.PropertyManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CmdUtil {
    public static final char OSNAMEFONTCHAR = 'w';
    public static final char OSVERSIONCHAR = '6';
    private static final Logger LOGGER = LoggerFactory.getLogger(CmdUtil.class);

    public static void runbatParams(String path, String[] params) {
        StringBuffer sb = new StringBuffer();
        sb.append("cmd /c start /b ");
        sb.append(path.replace("/", "\\").replace(" ", "\" \""));
        if (null != params && params.length > 0) {
            for (String param : params) {
                sb.append(" " + param);
            }
        }
        CmdUtil.runbat(sb.toString());
    }

    public static void runbatPopupWihtParams(String path, String[] params) {
        StringBuffer sb = new StringBuffer();
        sb.append("cmd /c start ");
        sb.append(path.replace("/", "\\").replace(" ", "\" \""));
        if (null != params && params.length > 0) {
            for (String param : params) {
                sb.append(" " + param);
            }
        }
        CmdUtil.runbat(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runbat(String cmd) {
        LOGGER.info("Run Windows Program.");
        if (!CmdUtil.validateCmd(cmd)) {
            LOGGER.error("executeCommand error, command is valid.");
            return;
        }
        String[] finalCmd = cmd.split(" ");
        Process process = null;
        int isSuccessful = 0;
        ProcessBuilder pb = new ProcessBuilder(finalCmd);
        pb.redirectErrorStream(true);
        BufferedReader input = null;
        try {
            process = pb.start();
            InputStreamReader ir = new InputStreamReader(process.getInputStream(), "utf-8");
            input = new LineNumberReader(ir);
            String line = ((LineNumberReader)input).readLine();
            while (line != null) {
                line = ((LineNumberReader)input).readLine();
            }
            isSuccessful = process.waitFor();
            LOGGER.debug("CMD excute result:" + isSuccessful, (Object)"runbat");
        }
        catch (IOException ioe) {
            LOGGER.error("runbat", (Throwable)ioe);
        }
        catch (InterruptedException e) {
            LOGGER.error("Execute return error.", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Execute return error.", (Throwable)e);
        }
        finally {
            if (null != process) {
                process.destroy();
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    LOGGER.error("Exception occured {}", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String runShell(String shStr) {
        StringBuffer sb = new StringBuffer();
        Process process = null;
        try {
            ProcessBuilder pb = new ProcessBuilder("/bin/sh", "-c", shStr);
            pb.redirectErrorStream(true);
            process = pb.start();
        }
        catch (Exception ex) {
            LOGGER.error("run shell occurs error.", (Throwable)ex);
        }
        if (null == process) {
            LOGGER.error("init process object occurs error, then process is null.");
            return sb.toString();
        }
        InputStreamReader ir = null;
        BufferedReader input = null;
        try {
            String line;
            ir = new InputStreamReader(process.getInputStream(), "utf-8");
            input = new LineNumberReader(ir);
            while ((line = ((LineNumberReader)input).readLine()) != null) {
                if (sb.length() > 0) {
                    sb.append(System.getProperty("line.separator"));
                }
                LOGGER.info(line, (Object)"runShell");
                sb.append(line);
            }
        }
        catch (IOException ex) {
            LOGGER.error("parse response source shell occurs error.", (Throwable)ex);
        }
        finally {
            if (null != input) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    LOGGER.error("close io occurs error", (Throwable)e);
                }
            }
            if (null != ir) {
                try {
                    ir.close();
                }
                catch (IOException e) {
                    LOGGER.error("close io occurs error", (Throwable)e);
                }
            }
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                LOGGER.error("close io occurs error", (Throwable)e);
            }
        }
        return sb.toString();
    }

    public static void setAuthoInLinux(String savaPath) {
        String cmd = "";
        cmd = savaPath.endsWith("/") ? "chmod 777 -R " + savaPath + PropertyManager.getProValue("install.lego_version.platform.runtime") + "/*" : "chmod 777 -R " + savaPath + "/" + PropertyManager.getProValue("install.lego_version.platform.runtime") + "/*";
        CmdUtil.runShell(cmd);
    }

    public static boolean hasIpV6Ip() {
        boolean hasIPV6 = false;
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface nif = e.nextElement();
                Enumeration<InetAddress> l = nif.getInetAddresses();
                while (l.hasMoreElements()) {
                    InetAddress address = l.nextElement();
                    if (!(address instanceof Inet6Address)) continue;
                    hasIPV6 = true;
                    return hasIPV6;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("get Local IP Error", (Throwable)e);
            hasIPV6 = false;
        }
        return hasIPV6;
    }

    public static boolean validateCmd(String arg) {
        String[] badInput;
        for (String bad : badInput = new String[]{"&&", "&", "||", "|", ";", "$", ">", ">>", "<"}) {
            if (!arg.contains(bad)) continue;
            return false;
        }
        return true;
    }
}

